package info.textgrid.lab.conf;

import info.textgrid.lab.conf.client.ConfClient;

import java.net.URI;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;


public class ConfservPrefPage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	StringFieldEditor endpointEditor;
	BooleanFieldEditor proxyRadio;
	StringFieldEditor proxyString;
	IntegerFieldEditor portString;
	Composite compositeProxy;
	boolean shouldRestart = false;
	
	public ConfservPrefPage() {
		// TODO Auto-generated constructor stub
	}

	public ConfservPrefPage(int style) {
		super(style);
		// TODO Auto-generated constructor stub
	}

	public ConfservPrefPage(String title, int style) {
		super(title, style);
		// TODO Auto-generated constructor stub
	}

	public ConfservPrefPage(String title, ImageDescriptor image, int style) {
		super(title, image, style);
		// TODO Auto-generated constructor stub
	}

	private final class ControllableContentProposalAdapter extends ContentProposalAdapter {
		private ControllableContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter,
				IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
			super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
		}

		public void openProposalPopup() {
			super.openProposalPopup();
		}
	}


	private static class EndpointProposal implements IContentProposal {

		public EndpointProposal(final URI uri, final String description) {
			this.uri = uri;
			this.description = description;
		}

		private final URI uri;
		private final String description;

		public String getContent() {
			return uri.toString();
		}

		public int getCursorPosition() {
			return uri.getScheme().length() + uri.getHost().length() + 3;
		}

		public String getDescription() {
			return description;
		}

		public String getLabel() {
			return description + " (" + uri.toString() + ")";
		}

	}

	private static final IContentProposal[] ENDPOINTS = {
			new EndpointProposal(URI.create(ConfClient.DEFAULT_ENDPOINT), "Default Endpoint"),
			new EndpointProposal(URI.create("https://textgridlab.org/dev/confserv/"), "Development System (ws4)"),
	// ConfClient.DEFAULT_ENDPOINT,
	};

	@Override
	protected void createFieldEditors() {
		createEndpointFieldEditor();
		createCompressedTransferFieldEditor();
		createProxyFieldEditor();
	}

	private void createCompressedTransferFieldEditor() {
		// compressed data transfer
		Composite transferComposite = getFieldEditorParent();
		GridLayout transferGridlayout = new GridLayout();
		transferGridlayout.numColumns = 3;
		transferComposite.setLayout(transferGridlayout);
		BooleanFieldEditor comTrans = new BooleanFieldEditor("compressedTransfer", "Use Compressed Data Transfer", transferComposite);
		addField(comTrans);
	}

	private void createEndpointFieldEditor() {
		Composite endpointFieldParent = getFieldEditorParent();
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		endpointFieldParent.setLayout(gridLayout);
		endpointEditor = new StringFieldEditor("endpoint", "Configuration Service URI", endpointFieldParent);
		endpointEditor.setEmptyStringAllowed(false);
		addField(endpointEditor);

		IContentProposalProvider proposalProvider = new IContentProposalProvider() {

			public IContentProposal[] getProposals(String contents, int position) {
				return ENDPOINTS;
			}
		};
		Text textControl = endpointEditor.getTextControl(endpointFieldParent);
		final ControllableContentProposalAdapter proposals = new ControllableContentProposalAdapter(textControl, new TextContentAdapter(), proposalProvider, null, null);
		proposals.setFilterStyle(ContentProposalAdapter.FILTER_CHARACTER);
		proposals.setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_REPLACE);

		Label restartInfo = new Label(endpointFieldParent, SWT.WRAP);
		GridData layoutData = new GridData(SWT.FILL, SWT.CENTER, true, false);
		layoutData.horizontalSpan = 2;
		restartInfo.setLayoutData(layoutData);
		restartInfo.setText("After a change of the configuration service URI a restart of the lab is required.");

		Label modifiedInfo = new Label(endpointFieldParent, SWT.WRAP);
		GridData layoutData2 = new GridData(SWT.FILL, SWT.CENTER, true, false);
		layoutData2.horizontalSpan = 2;
		layoutData2.widthHint = 400;
		modifiedInfo.setLayoutData(layoutData2);
		try {
			String usedEndpoint = ConfClient.getInstance().getEndpoint();
			String configuredEndpoint = getPreferenceStore().getString("endpoint");
			if (!usedEndpoint.equals(configuredEndpoint)) {
				modifiedInfo
						.setText(NLS
								.bind(
										"The lab currently uses the instance at {0} until the next restart. After the next restart, the value configured using this preference page (by default {1}) will be used. You can always restart the lab using File → Restart.",
										usedEndpoint, configuredEndpoint));
				ControlDecoration modifiedWarning = new ControlDecoration(modifiedInfo, SWT.RIGHT);
				modifiedWarning.setImage(JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_WARNING));
			}
		} catch (OfflineException e) {
			modifiedInfo.setText("The lab is currently offline and thus does not use any endpoint.");
		}
	}
	
	private void createProxyFieldEditor() {
		Composite proxyComposite = getFieldEditorParent();
		proxyComposite.setLayout(new GridLayout());
		GridData proxyLayout = new GridData(SWT.FILL, SWT.CENTER, true, true);
		Group proxyGroup = new Group(proxyComposite, SWT.NULL);
		proxyGroup.setText("HTTP Proxy Settings");
		proxyGroup.setLayoutData(proxyLayout);

		proxyRadio = new BooleanFieldEditor("proxy_connection", "use proxy", proxyGroup);
		addField(proxyRadio);
		
		GridData proxyFieldLayout = new GridData(SWT.FILL, SWT.CENTER, true, false);
		proxyFieldLayout.horizontalIndent = 25;
		compositeProxy = new Composite(proxyGroup, SWT.FILL);
		compositeProxy.setLayoutData(proxyFieldLayout);
		
		proxyString = new StringFieldEditor("proxy_connection_http", "Proxy:",compositeProxy);
		portString = new IntegerFieldEditor("proxy_connection_port", "Port:",compositeProxy);
		addField(proxyString);
		addField(portString);
		
		if (!getPreferenceStore().getBoolean("proxy_connection")) {
			proxyString.setEnabled(false, compositeProxy);
    		portString.setEnabled(false, compositeProxy);
		}
	}
	
	public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
		if (event.getProperty().equals(FieldEditor.VALUE) && proxyRadio != null && proxyString != null) {
        	if (proxyRadio.getBooleanValue() == false) {
        		proxyString.setEnabled(false, compositeProxy);
        		portString.setEnabled(false, compositeProxy);
        	} else {
        		proxyString.setEnabled(true, compositeProxy);
        		portString.setEnabled(true, compositeProxy);
        	}        	
        }        
    }

	public void init(IWorkbench workbench) {
		setDescription("Configure basic TextGridLab settings like the URL of the configuration service (which will be used to retrieve all other service adresses).");
		setPreferenceStore(ConfPlugin.getDefault().getPreferenceStore());
		initialize();
	}
	
	protected void performApply() {
		shouldRestart = restartCheck();
		super.performApply();
		if (shouldRestart) {
			restartDialog();
		}	
	}
	
	public boolean performOk() {
		if (!shouldRestart)
			shouldRestart = restartCheck();
		boolean ok = super.performOk();
        if (ok && shouldRestart) {
        	restartDialog();
        }
        ConfClient.setProxySelector();
		return ok;
	}
	
	private boolean restartCheck() {
		if (!endpointEditor.getStringValue().equals(endpointEditor.getPreferenceStore().getString(ConfClient.PREF_ENDPOINT))) { 	
				return true;
			}
		return false;
	}
	
	private void restartDialog() {
		// Changing the endpoint with a running lab currently doesn't work (cf.
		// TG-351, TG-201). Thus, we require a restart instead of performing the
		// change. OTOH, a restart with an open editor is evil, so there.
		if (MessageDialog
				.openConfirm(
						null,
						"TextGridLab restart required",
						"A change of the TextGrid configuration service URI requires a restart of the TextGridLab. Would you like to restart the lab now? Otherwise you'll work on with the old instance until you restart the Lab via File / Restart.")) {
			PlatformUI.getWorkbench().restart();
		}
	}
}
