package info.textgrid.lab.welcome;

import java.util.Properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenMailAction implements IIntroAction {

	private static String TG_SUPPORT_MAIL_ADDRESS = "textgrid-support@gwdg.de";
	private static String TG_SUPPORT_MAIL_SUBJECT = "TextGrid";
	private static String TG_SUPPORT_MAIL_BODY = "";

	public void run(IIntroSite site, Properties params) {
		try {
			email(TG_SUPPORT_MAIL_SUBJECT, TG_SUPPORT_MAIL_BODY);
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, e.getMessage(), e);
			Activator.getDefault().getLog().log(status);
		}
	}

	/*
	 * This is working for WinOS and MacOS but not for Linux
	 */
	public void email(String subject, String body) throws Exception {
		String cmd = "open mailto:" + TG_SUPPORT_MAIL_ADDRESS;
		cmd += "?subject=" + urlEncode(subject);
		cmd += "&body=" + urlEncode(body);
		Runtime.getRuntime().exec(cmd);
	}

	private static String urlEncode(String s) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < s.length(); i++) {
			char ch = s.charAt(i);
			if (Character.isLetterOrDigit(ch)) {
				sb.append(ch);
			} else {
				sb.append(String.format("%%%02X", (int) ch));
			}
		}
		return sb.toString();
	}

}
