/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PickWorkspaceDialog
extends TitleAreaDialog {
    public static final String WS_IDENTIFIER = "TextGridLab.workspace";
    private static final String _KeyWorkspaceRootDir = "wsRootDir";
    private static final String _KeyRememberWorkspace = "wsRemember";
    private static final String _KeyLastUsedWorkspaces = "wsLastUsedWorkspaces";
    private static Preferences _preferences = Preferences.userNodeForPackage(PickWorkspaceDialog.class);
    private static final String _StrMsg = "Your workspace is where settings and various important files will be stored.";
    private static final String _StrInfo = "Please select a directory that will be the workspace root";
    private static final String _StrError = "You must set a directory";
    private Combo _workspacePathCombo;
    private List<String> _lastUsedWorkspaces;
    private Button _RememberWorkspaceButton;
    private static final String _SplitChar = "#";
    private static final int _MaxHistory = 20;
    private boolean _switchWorkspace;
    private String _selectedWorkspaceRootLocation;

    public PickWorkspaceDialog(boolean switchWorkspace, Image wizardImage) {
        super(Display.getDefault().getActiveShell());
        this._switchWorkspace = switchWorkspace;
        if (wizardImage != null) {
            this.setTitleImage(wizardImage);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this._switchWorkspace) {
            newShell.setText("Switch Workspace");
        } else {
            newShell.setText("Workspace Selection");
        }
    }

    public static boolean isRememberWorkspace() {
        return _preferences.getBoolean(_KeyRememberWorkspace, false);
    }

    public static String getLastSetWorkspaceDirectory() {
        return _preferences.get(_KeyWorkspaceRootDir, null);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Pick Workspace");
        this.setMessage(_StrMsg);
        try {
            Composite inner = new Composite(parent, 0);
            inner.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
            GridLayout gl_inner = new GridLayout(3, true);
            gl_inner.verticalSpacing = 2;
            gl_inner.marginWidth = 2;
            gl_inner.marginHeight = 2;
            gl_inner.horizontalSpacing = 2;
            inner.setLayout((Layout)gl_inner);
            CLabel label = new CLabel(inner, 0);
            GridData gd_label = new GridData(4, 4, true, true, 2, 1);
            gd_label.widthHint = 439;
            label.setLayoutData((Object)gd_label);
            label.setText("Workspace Root Path");
            new Label(inner, 0);
            this._workspacePathCombo = new Combo(inner, 2048);
            GridData gd__workspacePathCombo = new GridData(4, 0x1000000, true, true, 2, 1);
            gd__workspacePathCombo.widthHint = 235;
            this._workspacePathCombo.setLayoutData((Object)gd__workspacePathCombo);
            String wsRoot = _preferences.get(_KeyWorkspaceRootDir, "");
            if (wsRoot == null || wsRoot.length() == 0) {
                wsRoot = this.getWorkspacePathSuggestion();
            }
            this._workspacePathCombo.setText(wsRoot == null ? "" : wsRoot);
            Button browse = new Button(inner, 8);
            GridData gd_browse = new GridData(16384, 128, false, true, 1, 1);
            gd_browse.widthHint = 94;
            browse.setLayoutData((Object)gd_browse);
            browse.setText("Browse...");
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DirectoryDialog dd = new DirectoryDialog(PickWorkspaceDialog.this.getParentShell());
                    dd.setText("Select Workspace Root");
                    dd.setMessage(PickWorkspaceDialog._StrInfo);
                    dd.setFilterPath(PickWorkspaceDialog.this._workspacePathCombo.getText());
                    String pick = dd.open();
                    if (pick == null && PickWorkspaceDialog.this._workspacePathCombo.getText().length() == 0) {
                        PickWorkspaceDialog.this.setMessage(PickWorkspaceDialog._StrError, 3);
                    } else {
                        PickWorkspaceDialog.this.setMessage(PickWorkspaceDialog._StrMsg);
                        PickWorkspaceDialog.this._workspacePathCombo.setText(pick);
                    }
                }
            });
            this._RememberWorkspaceButton = new Button(inner, 32);
            this._RememberWorkspaceButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
            this._RememberWorkspaceButton.setText("Remember workspace");
            this._RememberWorkspaceButton.setSelection(_preferences.getBoolean(_KeyRememberWorkspace, false));
            String lastUsed = _preferences.get(_KeyLastUsedWorkspaces, "");
            this._lastUsedWorkspaces = new ArrayList<String>();
            if (lastUsed != null) {
                String[] all;
                String[] stringArray = all = lastUsed.split(_SplitChar);
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    this._lastUsedWorkspaces.add(str);
                    ++n2;
                }
            }
            for (String last : this._lastUsedWorkspaces) {
                this._workspacePathCombo.add(last);
            }
            return inner;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public String getSelectedWorkspaceLocation() {
        return this._selectedWorkspaceRootLocation;
    }

    private String getWorkspacePathSuggestion() {
        StringBuffer buf = new StringBuffer();
        String uHome = System.getProperty("user.home");
        if (uHome == null) {
            uHome = "c:" + File.separator + "temp";
        }
        buf.append(uHome);
        buf.append(File.separator);
        buf.append("My App Name");
        buf.append("_Workspace");
        return buf.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button clone = this.createButton(parent, 9, "Clone", false);
        clone.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    String txt = PickWorkspaceDialog.this._workspacePathCombo.getText();
                    File workspaceDirectory = new File(txt);
                    if (!workspaceDirectory.exists()) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"The currently entered workspace path does not exist. Please enter a valid path.");
                        return;
                    }
                    if (!workspaceDirectory.canRead()) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"The currently entered workspace path is not readable. Please check file system permissions.");
                        return;
                    }
                    File wsFile = new File(String.valueOf(txt) + File.separator + PickWorkspaceDialog.WS_IDENTIFIER);
                    if (!wsFile.exists()) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"The currently entered workspace path does not contain a valid workspace.");
                        return;
                    }
                    DirectoryDialog dd = new DirectoryDialog(Display.getDefault().getActiveShell());
                    dd.setFilterPath(txt);
                    String directory = dd.open();
                    if (directory == null) {
                        return;
                    }
                    File targetDirectory = new File(directory);
                    if (targetDirectory.getAbsolutePath().equals(workspaceDirectory.getAbsolutePath())) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Source and target workspaces are the same");
                        return;
                    }
                    if (PickWorkspaceDialog.this.isTargetSubdirOfDir(workspaceDirectory, targetDirectory)) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Target folder is a subdirectory of the current workspace");
                        return;
                    }
                    try {
                        PickWorkspaceDialog.copyFiles(workspaceDirectory, targetDirectory);
                    }
                    catch (Exception err) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("There was an error cloning the workspace: " + err.getMessage()));
                        return;
                    }
                    boolean setActive = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Workspace Cloned", (String)"Would you like to set the newly cloned workspace to be the active one?");
                    if (setActive) {
                        PickWorkspaceDialog.this._workspacePathCombo.setText(directory);
                    }
                }
                catch (Exception err) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"There was an internal error, please check the logs");
                    err.printStackTrace();
                }
            }
        });
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean isTargetSubdirOfDir(File source, File target) {
        ArrayList<File> subdirs = new ArrayList<File>();
        this.getAllSubdirectoriesOf(source, subdirs);
        return subdirs.contains(target);
    }

    private void getAllSubdirectoriesOf(File target, List<File> buffer) {
        File[] files = target.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                buffer.add(f);
                this.getAllSubdirectoriesOf(f, buffer);
            }
            ++n2;
        }
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("Can not find source: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Cannot read: " + src.getAbsolutePath() + ". Check file permissions.");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Could not create direcotry: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                PickWorkspaceDialog.copyFiles(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException("Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath());
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fin.close();
                }
            }
        }
    }

    protected void okPressed() {
        int i;
        String str = this._workspacePathCombo.getText();
        if (str.length() == 0) {
            this.setMessage(_StrError, 3);
            return;
        }
        String ret = PickWorkspaceDialog.checkWorkspaceDirectory(this.getParentShell(), str, true, true);
        if (ret != null) {
            this.setMessage(ret, 3);
            return;
        }
        this._lastUsedWorkspaces.remove(str);
        if (!this._lastUsedWorkspaces.contains(str)) {
            this._lastUsedWorkspaces.add(0, str);
        }
        if (this._lastUsedWorkspaces.size() > 20) {
            ArrayList<String> remove = new ArrayList<String>();
            i = 20;
            while (i < this._lastUsedWorkspaces.size()) {
                remove.add(this._lastUsedWorkspaces.get(i));
                ++i;
            }
            this._lastUsedWorkspaces.removeAll(remove);
        }
        StringBuffer buf = new StringBuffer();
        i = 0;
        while (i < this._lastUsedWorkspaces.size()) {
            buf.append(this._lastUsedWorkspaces.get(i));
            if (i != this._lastUsedWorkspaces.size() - 1) {
                buf.append(_SplitChar);
            }
            ++i;
        }
        _preferences.putBoolean(_KeyRememberWorkspace, this._RememberWorkspaceButton.getSelection());
        _preferences.put(_KeyLastUsedWorkspaces, buf.toString());
        boolean ok = PickWorkspaceDialog.checkAndCreateWorkspaceRoot(str);
        if (!ok) {
            this.setMessage("The workspace could not be created, please check the error log");
            return;
        }
        this._selectedWorkspaceRootLocation = str;
        _preferences.put(_KeyWorkspaceRootDir, str);
        super.okPressed();
    }

    public static String checkWorkspaceDirectory(Shell parentShell, String workspaceLocation, boolean askCreate, boolean fromDialog) {
        File f = new File(workspaceLocation);
        if (!f.exists() && askCreate) {
            boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)"New Directory", (String)"The directory does not exist. Would you like to create it?");
            if (create) {
                try {
                    f.mkdirs();
                    File wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                    wsDot.createNewFile();
                }
                catch (Exception exception) {
                    return "Error creating directories, please check folder permissions";
                }
            }
            if (!f.exists()) {
                return "The selected directory does not exist";
            }
        }
        if (!f.canRead()) {
            return "The selected directory is not readable";
        }
        if (!f.isDirectory()) {
            return "The selected path is not a directory";
        }
        File wsTest = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
        if (fromDialog) {
            if (!wsTest.exists()) {
                boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)"New Workspace", (String)("The directory '" + wsTest.getAbsolutePath() + "' is not set to be a workspace. Do note that files will be created directly under the specified directory and it is suggested you create a directory that has a name that represents your workspace. \n\nWould you like to create a workspace in the selected location?"));
                if (create) {
                    try {
                        f.mkdirs();
                        File wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                        wsDot.createNewFile();
                    }
                    catch (Exception exception) {
                        return "Error creating directories, please check folder permissions";
                    }
                } else {
                    return "Please select a directory for your workspace";
                }
                if (!wsTest.exists()) {
                    return "The selected directory does not exist";
                }
                return null;
            }
        } else if (!wsTest.exists()) {
            return "The selected directory is not a workspace directory";
        }
        return null;
    }

    public static boolean checkAndCreateWorkspaceRoot(String wsRoot) {
        block3: {
            try {
                File fRoot = new File(wsRoot);
                if (fRoot.exists()) break block3;
                return false;
            }
            catch (Exception err) {
                err.printStackTrace();
                return false;
            }
        }
        File dotFile = new File(String.valueOf(wsRoot) + File.separator + WS_IDENTIFIER);
        return dotFile.exists() || dotFile.createNewFile();
    }
}

