/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.versions.ui;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.core.swtutils.PendingLabelProvider;
import info.textgrid.lab.core.versions.ui.Messages;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrudWarningView
extends ViewPart {
    public static final String ID = "info.textgrid.lab.crudwarning.views.CrudWarningView";
    private TextGridObjectTableViewer viewer;
    private ComboViewer projectCombo;
    private Button refreshButton;
    private Image refreshImage;
    private Action doubleClickAction;
    private TextGridProject selectedProject = null;
    private boolean comboContainsData = false;

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        Composite mdSearchGroup = new Composite(parent, 16384);
        GridData gd2 = new GridData(4, 2, false, false);
        mdSearchGroup.setLayoutData((Object)gd2);
        GridLayout gl = new GridLayout(3, false);
        mdSearchGroup.setLayout((Layout)gl);
        Label projectLabel = new Label(mdSearchGroup, 0);
        projectLabel.setText(Messages.CrudWarningView_Project);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.projectCombo = new ComboViewer(mdSearchGroup, 8);
        this.projectCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DeferredListContentProvider pcContentProvider = new DeferredListContentProvider();
        this.projectCombo.setContentProvider((IContentProvider)pcContentProvider);
        this.projectCombo.setLabelProvider((IBaseLabelProvider)new PendingLabelProvider());
        this.projectCombo.setSorter(new ViewerSorter());
        this.projectCombo.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        pcContentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

            public void loadDone(Viewer filledViewer) {
                if (!CrudWarningView.this.comboContainsData) {
                    CrudWarningView.this.projectCombo.add((Object)Messages.CrudWarningView_AllProjects);
                }
                CrudWarningView.this.comboContainsData = true;
                if (CrudWarningView.this.selectedProject != null) {
                    CrudWarningView.this.refreshViewer(CrudWarningView.this.selectedProject);
                    CrudWarningView.this.selectedProject = null;
                }
            }
        });
        this.refreshButton = new Button(mdSearchGroup, 8);
        this.refreshImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"info.textgrid.lab.core.aggregations.ui", (String)"/icons/refresh.gif").createImage();
        this.refreshButton.setImage(this.refreshImage);
        this.refreshButton.setToolTipText(Messages.CrudWarningView_RefreshView);
        this.refreshButton.setLayoutData((Object)new GridData(16384, 2, true, false));
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CrudWarningView.this.refreshViewer(((IStructuredSelection)CrudWarningView.this.projectCombo.getSelection()).getFirstElement());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer = new TextGridObjectTableViewer(parent, 772);
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.WARNING));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setSorter(new ViewerSorter());
        this.makeActions();
        this.hookDoubleClickAction();
        this.hookContextMenu((TableViewer)this.viewer);
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = CrudWarningView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TextGridObject) {
                    try {
                        TextGridObject object = (TextGridObject)obj;
                        CrudWarningView.this.showMessage(MessageFormat.format(Messages.CrudWarningView_CrudWarning, object.getProject(), object.getTitle()), ((TextGridObject)obj).getCrudWarning());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CrudWarningView.this.doubleClickAction.run();
            }
        });
    }

    private void hookContextMenu(TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void showMessage(String title, String message) {
        MessageDialog.openWarning((Shell)this.viewer.getControl().getShell(), (String)title, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refreshViewer(Object project) {
        if (!this.comboContainsData) {
            if (project instanceof TextGridProject) {
                this.selectedProject = (TextGridProject)project;
            }
            return;
        }
        SearchRequest searchRequest = new SearchRequest();
        if (project != null) {
            this.projectCombo.setSelection((ISelection)new StructuredSelection(project), true);
        }
        IStructuredSelection spss = (IStructuredSelection)this.projectCombo.getSelection();
        TextGridProject comboProject = null;
        if (spss.getFirstElement() instanceof TextGridProject) {
            comboProject = (TextGridProject)spss.getFirstElement();
            if (comboProject != null) {
                searchRequest.setQueryMetadata("warning:\".\" and project:\"" + comboProject.getName() + "\"");
            }
        } else {
            searchRequest.setQueryMetadata("warning:\".\"");
        }
        this.viewer.setInput((Object)searchRequest);
    }
}

