/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.basicMetadata.wizard;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.basicMetadata.wizard.Messages;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.ProjectFileException;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WizardUtils {
    private TextGridProject project = null;
    private String type = null;
    private OMElement lastSavedMetadata = null;
    private TextGridProjectFile projectFile = null;

    void setData(TextGridProject project, String type) {
        try {
            this.project = TextGridProject.getProjectInstance((String)project.getId());
            this.type = type;
            this.projectFile = null;
            this.lastSavedMetadata = null;
            this.readConfig();
        }
        catch (RemoteException e) {
            Activator.handleError(e);
        }
        catch (CrudServiceException e) {
            Activator.handleError(e);
        }
        catch (ProjectDoesNotExistException e) {
            Activator.handleError(e);
        }
    }

    private void readConfig() {
        if (this.project == null) {
            return;
        }
        Job read_job = new Job(Messages.WizardUtils_readingProjectfile){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.WizardUtils_fetchingProjectfile, -1);
                WizardUtils.this.projectFile = new TextGridProjectFile(WizardUtils.this.project);
                try {
                    OMElement typeOMElem;
                    TgProjectFile projectFileData = WizardUtils.this.projectFile.getProjectFileData(false, true, monitor);
                    OMElement[] appDataChildren = TextGridProjectFile.extractAppDataChildren((TgProjectFile)projectFileData);
                    OMElement basicMetaSection = null;
                    if (appDataChildren != null && appDataChildren.length > 0) {
                        OMElement[] oMElementArray = appDataChildren;
                        int n = appDataChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OMElement child = oMElementArray[n2];
                            if (child.getQName().equals(TextGridProjectFile.basicMetadataSectionQName)) {
                                basicMetaSection = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (basicMetaSection != null && (typeOMElem = basicMetaSection.getFirstChildWithName(new QName(TextGridProjectFile.basicMetadataSectionNS, WizardUtils.this.type))) != null) {
                        WizardUtils.this.lastSavedMetadata = typeOMElem.getFirstElement();
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Activator.handleError(e, Messages.WizardUtils_readConfigurationFailed, new Object[0]);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        read_job.schedule();
        try {
            read_job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    OMElement getLastSavedOMElement() {
        return this.lastSavedMetadata;
    }

    void createAndSaveData(OMElement metadata) {
        System.out.println(metadata);
        try {
            this.addMetadataPartToProjectFile(metadata);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e, Messages.WizardUtils_setDatainProjectfileFailed, new Object[0]);
        }
    }

    private void addMetadataPartToProjectFile(final OMElement metadata) {
        if (this.projectFile == null) {
            return;
        }
        Job saveJob = new Job(Messages.WizardUtils_savingProjectfile){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    OMElement typeElem;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(Messages.WizardUtils_savingProjectfile, 100);
                    monitor.worked(10);
                    TgProjectFile projectFileData = WizardUtils.this.projectFile.getProjectFileData(true, true, monitor);
                    OMFactory omFactory = OMAbstractFactory.getOMFactory();
                    OMElement appDataOM = TextGridProjectFile.extractAppDataXML((TgProjectFile)projectFileData);
                    if (appDataOM == null) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(40);
                    OMElement basicMetaDataOM = appDataOM.getFirstChildWithName(TextGridProjectFile.basicMetadataSectionQName);
                    if (basicMetaDataOM == null) {
                        basicMetaDataOM = omFactory.createOMElement(TextGridProjectFile.basicMetadataSectionQName);
                        appDataOM.addChild((OMNode)basicMetaDataOM);
                    }
                    if ((typeElem = basicMetaDataOM.getFirstChildWithName(new QName(TextGridProjectFile.basicMetadataSectionNS, WizardUtils.this.type))) != null) {
                        typeElem.detach();
                    }
                    typeElem = omFactory.createOMElement(new QName(TextGridProjectFile.basicMetadataSectionNS, WizardUtils.this.type));
                    typeElem.addChild((OMNode)metadata);
                    basicMetaDataOM.addChild((OMNode)typeElem);
                    monitor.worked(10);
                    Iterator childElements = appDataOM.getChildElements();
                    LinkedList<Element> newAppData = new LinkedList<Element>();
                    if (childElements != null) {
                        while (childElements.hasNext()) {
                            OMElement next = (OMElement)childElements.next();
                            if (basicMetaDataOM.getLocalName().equals(next.getLocalName())) continue;
                            newAppData.add(WizardUtils.toDOM(next));
                        }
                    }
                    newAppData.add(WizardUtils.toDOM(basicMetaDataOM));
                    projectFileData.getAppData().getAny().clear();
                    projectFileData.getAppData().getAny().addAll(newAppData);
                    WizardUtils.this.projectFile.saveProjectFileData(projectFileData, monitor);
                    monitor.done();
                }
                catch (ProjectFileException e) {
                    Activator.handleError(e, Messages.WizardUtils_writeFailed_rights, new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e, Messages.WizardUtils_writeFailed_rights, new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
    }

    private static Element toDOM(OMElement element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            element.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(bais).getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
    }

    public static void main(String[] args) {
        SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        f.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }
        });
        try {
            StreamSource ss = new StreamSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xs:element name=\"nr\" type=\"xs:integer\"></xs:element></xs:schema>".getBytes("UTF-8")));
            StreamSource ss2 = new StreamSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><nr>124</nr>".getBytes("UTF-8")));
            Schema s = f.newSchema(ss);
            Validator v = s.newValidator();
            v.validate(ss2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

