/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.application;

import info.textgrid.lab.core.application.Activator;
import info.textgrid.lab.core.application.LabWorkbenchAdvisor;
import info.textgrid.lab.core.application.Messages;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static final String TEXT_GRID_LAB_WORKSPACE = "TextGridLab.workspace";
    private boolean msgLogged = false;

    public Object start(IApplicationContext context) throws Exception {
        String path;
        Location instanceLoc;
        Display display = PlatformUI.createDisplay();
        String[] javaVersion = System.getProperty("java.specification.version").split("\\.");
        if (javaVersion[0].equals("1")) {
            try {
                int subVersion = Integer.parseInt(javaVersion[1]);
                if (subVersion < 6) {
                    Shell shell = new Shell(display);
                    MessageBox mb = new MessageBox(shell, 40);
                    mb.setMessage(NLS.bind((String)Messages.Application_NeedJava6, (Object)System.getProperty("java.specification.version")));
                    mb.open();
                    System.exit(0);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((instanceLoc = Platform.getInstanceLocation()).isReadOnly()) {
            Shell shell = new Shell(display, 65536);
            MessageBox mb = new MessageBox(shell, 40);
            mb.setText(Messages.Application_Error_Message_Info);
            mb.setMessage(NLS.bind((String)(String.valueOf(Messages.Application_No_Rights_For_Workspace_Directory) + Messages.Application_Troobleshooting_Info), (Object)this));
            mb.open();
            System.exit(0);
        }
        if (instanceLoc.isReadOnly() && !instanceLoc.isSet()) {
            boolean standardPath = false;
            path = this.getWorkspacePathSuggestion(standardPath);
            instanceLoc.release();
            instanceLoc.set(new URL("file", null, path), false);
        }
        if (!instanceLoc.isSet()) {
            boolean standardPath = true;
            path = this.getWorkspacePathSuggestion(standardPath);
            instanceLoc.release();
            instanceLoc.set(new URL("file", null, path), false);
        }
        if (!this.msgLogged) {
            this.logWorkspacePath(new StringBuffer(instanceLoc.getURL().getPath()));
        }
        try {
            int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new LabWorkbenchAdvisor());
            Integer n = code == 1 ? EXIT_RESTART : EXIT_OK;
            return n;
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    private String getWorkspacePathSuggestion(boolean standardPath) {
        StringBuffer buf = new StringBuffer();
        String uHome = "";
        if (standardPath) {
            uHome = Platform.getInstanceLocation().toString();
        } else {
            uHome = System.getProperty("user.home");
            if (uHome == null) {
                uHome = "c:" + File.separator + "temp";
            }
        }
        buf.append(uHome);
        buf.append(File.separator);
        buf.append(TEXT_GRID_LAB_WORKSPACE);
        if (!this.msgLogged) {
            this.logWorkspacePath(buf);
        }
        return buf.toString();
    }

    private void logWorkspacePath(StringBuffer buf) {
        this.msgLogged = true;
        String msg = "path to workspace location: ";
        Activator.getDefault().getLog().log((IStatus)new Status(4, "info.textgrid.lab.core.application", String.valueOf(msg) + buf.toString()));
    }

    public void stop() {
    }
}

