/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class SaveLocalCopyHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = (ITextEditor)AdapterUtils.getAdapter((Object)editorPart, ITextEditor.class);
        if (textEditor == null) {
            Activator.handleProblem(4, null, Messages.SaveLocalCopyHandler_EM_SaveNotSupported, editorPart, editorPart == null ? null : editorPart.getClass());
        } else {
            IEditorInput inputFile = textEditor.getEditorInput();
            IFile file = (IFile)AdapterUtils.getAdapter((Object)inputFile, IFile.class);
            TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)file, TextGridObject.class);
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)inputFile);
            FileDialog dialog = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 8192);
            dialog.setText(NLS.bind((String)Messages.SaveLocalCopyHandler_SaveAs, (Object)file));
            dialog.setFileName(inputFile.getName());
            if (textGridObject != null) {
                try {
                    TGContentType contentType = null;
                    contentType = textGridObject.getContentType(false);
                    dialog.setFilterExtensions(new String[]{contentType.getExtension()});
                    dialog.setFilterNames(new String[]{contentType.getDescription()});
                }
                catch (CoreException e) {
                    Activator.handleProblem(2, e, Messages.SaveLocalCopyHandler_EM_NoContentType, e.getMessage());
                }
            }
            dialog.setOverwrite(true);
            String fileName = dialog.open();
            if (fileName != null) {
                File target = new File(fileName).getAbsoluteFile();
                if (target.getParentFile() != null && !target.getParentFile().exists()) {
                    target.getParentFile().mkdirs();
                }
                try {
                    FileOutputStream outputStream = new FileOutputStream(target);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                    writer.write(document.get());
                    writer.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    Activator.handleError(e, Messages.SaveLocalCopyHandler_EM_CouldNotSave, file, target, e.getMessage());
                }
            }
        }
        return null;
    }
}

