/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.Messages;
import info.textgrid.lab.core.metadataeditor.MetaDataSection;
import info.textgrid.lab.core.metadataeditor.ScrolledPageArea;
import info.textgrid.lab.core.model.TextGridObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MetaDataDialog
extends TrayDialog {
    private MetaDataSection metaDataSection = null;
    private TextGridObject tgObj = null;
    private boolean isEditable = true;
    private Button save = null;

    public static void openMetaDataDialog(TextGridObject tgO) {
        MetaDataDialog d = new MetaDataDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        d.addTGObject(tgO);
        d.open();
    }

    protected MetaDataDialog(Shell parentShell) {
        super(parentShell);
    }

    public void addTGObject(TextGridObject tg) {
        this.tgObj = tg;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            this.save = super.createButton(parent, id, Messages.MetaDataDialog_save, defaultButton);
            this.save.setText(Messages.MetaDataDialog_save);
            this.save.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MetaDataDialog.this.metaDataSection.updateTextGridObject();
                    Job makePersistent = new Job(Messages.MetaDataDialog_makePersistent){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                MetaDataDialog.this.tgObj.makeMetadataPersistent(monitor);
                            }
                            catch (CoreException e1) {
                                Activator.handleError(e1);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    makePersistent.schedule();
                    try {
                        makePersistent.join();
                    }
                    catch (InterruptedException e1) {
                        Activator.handleWarning(e1);
                    }
                    MetaDataDialog.this.okPressed2();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.save.setEnabled(this.isEditable);
            return this.save;
        }
        if (id == 1) {
            return super.createButton(parent, id, Messages.MetaDataDialog_cancel, defaultButton);
        }
        return null;
    }

    protected void okPressed() {
    }

    private void okPressed2() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = parent;
        ScrolledPageArea scrolledPageArea = new ScrolledPageArea(area);
        Composite composite = scrolledPageArea.getPageAreaComposite();
        ScrolledForm scrolledForm = scrolledPageArea.getPageAreaScrolledForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 400).applyTo((Control)composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolledForm);
        Group metadataGroup = new Group(composite, 16);
        metadataGroup.setLayout((Layout)new GridLayout(1, false));
        this.metaDataSection = new MetaDataSection((Composite)metadataGroup, scrolledForm, null);
        if (this.tgObj != null) {
            this.metaDataSection.setNewTGObject(this.tgObj, true);
            this.metaDataSection.checkAllFields();
            try {
                if (!this.tgObj.hasPermissions(4)) {
                    this.metaDataSection.setEditable(false);
                    if (this.save != null) {
                        this.save.setEnabled(false);
                    }
                    this.isEditable = false;
                }
            }
            catch (CoreException e) {
                Activator.handleError(e);
            }
        }
        return composite;
    }
}

