/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.configurators;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import info.textgrid.lab.core.importexport.configurators.Messages;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractAggregationSupplier {
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String ORE_NS = "http://www.openarchives.org/ore/terms/";
    private ImportEntry entry;

    public AbstractAggregationSupplier(ImportEntry entry) {
        this.entry = entry;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLStreamWriter xml = XMLOutputFactory.newInstance().createXMLStreamWriter(baos, "UTF-8");
            xml.writeStartDocument();
            xml.setPrefix("rdf", RDF_NS);
            xml.setPrefix("ore", ORE_NS);
            xml.writeStartElement(RDF_NS, "RDF");
            xml.writeNamespace("rdf", RDF_NS);
            xml.writeNamespace("ore", ORE_NS);
            xml.writeStartElement(RDF_NS, "Description");
            for (String entry : this.filterAggregationEntries(this.getAggregationEntries())) {
                xml.writeCharacters("\n  ");
                xml.writeEmptyElement(ORE_NS, "aggregates");
                xml.writeAttribute(RDF_NS, "resource", entry);
            }
            xml.writeCharacters("\n");
            xml.writeEndDocument();
            xml.close();
            baos.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        System.out.println(baos.toString("UTF-8"));
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected Collection<String> filterAggregationEntries(String[] aggregationEntries) {
        if (this.entry == null) {
            return ImmutableList.copyOf((Object[])aggregationEntries);
        }
        final Set<File> importedFiles = this.entry.getModel().getFiles();
        Predicate<String> usableEntry = new Predicate<String>(){

            public boolean apply(String uri) {
                if (uri.startsWith("textgrid:")) {
                    return true;
                }
                try {
                    File file = new File(AbstractAggregationSupplier.this.getFile().getParent(), uri).getCanonicalFile();
                    boolean imported = importedFiles.contains(file);
                    if (!imported) {
                        StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.AbstractAggregationSupplier_NotImportedWarning, (Object)uri, (Object)AbstractAggregationSupplier.this.entry.getLocalData())));
                    }
                    return imported;
                }
                catch (IOException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.AbstractAggregationSupplier_FailedToCanonicalizeWarning, (Object)uri, (Object)((Object)AbstractAggregationSupplier.this.entry)), (Throwable)e));
                    return true;
                }
            }
        };
        return Collections2.filter((Collection)ImmutableList.copyOf((Object[])aggregationEntries), (Predicate)usableEntry);
    }

    protected abstract String[] getAggregationEntries();

    public abstract File getFile();
}

