/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.wizard;

import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.templateeditor.wizard.ITemplateEditorPage;
import info.textgrid.lab.templateeditor.wizard.TemplateEditorWizard;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PageOne
extends WizardPage
implements IWizardPage,
ITemplateEditorPage,
ISelectionChangedListener {
    private Composite container = null;
    private TableViewer projectViewer;
    private TextGridProject currentProject = null;
    private Label projectDescLabel;
    private Wizard wizard = null;
    private TextGridProject project = null;

    protected PageOne() {
        this(null);
    }

    public PageOne(TextGridProject project) {
        super("Please select a project");
        this.setTitle("Please select a project");
        this.currentProject = project;
    }

    @Override
    public void init(Wizard wizard) {
        this.wizard = wizard;
    }

    private void createProjectGroup(Composite control) {
        Group projectGroup = new Group(control, 16);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        projectGroup.setLayout((Layout)new GridLayout(1, true));
        projectGroup.setText("");
        this.projectViewer = new TableViewer((Composite)projectGroup, 268438276);
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        this.projectViewer.getTable().setLayoutData((Object)projectTreeData);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(true));
        this.projectDescLabel = new Label((Composite)projectGroup, 64);
        GridData projectDescData = new GridData(4, 4, true, false);
        projectDescData.heightHint = 48;
        this.projectDescLabel.setLayoutData((Object)projectDescData);
        UpdatingDeferredListContentProvider contentProvider = new UpdatingDeferredListContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)contentProvider);
        this.projectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.PROJECT_LEADER));
        this.projectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.currentProject != null) {
            contentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

                public void loadDone(Viewer viewer) {
                    StructuredSelection sel = new StructuredSelection((Object)PageOne.this.currentProject);
                    PageOne.this.projectViewer.setSelection((ISelection)sel, true);
                    if (sel.equals(PageOne.this.projectViewer.getSelection())) {
                        PageOne.this.setPageComplete(true);
                    } else {
                        PageOne.this.setPageComplete(false);
                    }
                }
            });
        } else {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Label intro = new Label(this.container, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText("To use the Metadata Template editor, please select a project first. Note that you just see the projects where you have the Project Manager role.");
        this.setControl((Control)this.container);
        this.createProjectGroup(this.container);
    }

    public Control getControl() {
        return this.container;
    }

    @Override
    public void finishPage() {
        ((TemplateEditorWizard)this.wizard).setSelectedProject(this.project);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.projectViewer) {
            Object selectedObject = null;
            if (event.getSelection() instanceof IStructuredSelection) {
                selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            if (selectedObject instanceof TextGridProject) {
                this.project = (TextGridProject)selectedObject;
                this.projectDescLabel.setText(NLS.bind((String)"{0} ({1})", (Object)this.project.getDescription(), (Object)this.project.getId()));
                this.setPageComplete(true);
            } else {
                this.project = null;
                this.projectDescLabel.setText("");
            }
        }
    }
}

