/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.locking;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.locking.LockingJob;
import info.textgrid.lab.ui.core.locking.Messages;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class LockingService {
    public static final long LOCKING_DELAY = 1740000L;
    private static LockingService instance;
    private static Map<TextGridObject, LockingJob> jobRegistry;

    static {
        jobRegistry = new ConcurrentHashMap<TextGridObject, LockingJob>();
    }

    private LockingService() {
    }

    public static synchronized LockingService getInstance() {
        if (instance == null) {
            instance = new LockingService();
        }
        return instance;
    }

    public boolean lockObject(TextGridObject object, boolean message) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob == null) {
            try {
                if (!object.hasPermissions(4)) {
                    return false;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core");
            }
        } else {
            return true;
        }
        lockingJob = new LockingJob(NLS.bind((String)"Locking object {0}", (Object)object.toString()), object, message);
        jobRegistry.put(object, lockingJob);
        try {
            IStatus status;
            do {
                lockingJob.schedule();
                lockingJob.join();
            } while ((status = lockingJob.getResult()).getSeverity() == 4 && this.retryLock(object, status));
            return lockingJob.isLocked();
        }
        catch (InterruptedException e) {
            Activator.handleError(e, e.getMessage(), object);
            return false;
        }
    }

    private boolean retryLock(TextGridObject object, IStatus status) {
        if (Display.getCurrent() == null) {
            StatusManager.getManager().handle(status);
            return false;
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Locking Problem", null, NLS.bind((String)Messages.LockingJob_IM_NoConnection, (Object)object.toString(), (Object)status.getMessage()), 3, new String[]{Messages.LockingJob_Retry, Messages.LockingJob_Cancel}, 1);
        dialog.setBlockOnOpen(true);
        boolean retry = dialog.open() == 0;
        MultiStatus multiStatus = new MultiStatus("info.textgrid.lab.ui.core", 0, retry ? "Locking problem, trying again" : "Locking problem, canceling", null);
        multiStatus.add(status);
        StatusManager.getManager().handle((IStatus)multiStatus);
        return retry;
    }

    public boolean unlockObject(TextGridObject object) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob != null) {
            this.removeJobFromRegistry(object);
            String sid = RBACSession.getInstance().getSID(false);
            TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
            try {
                return crudServiceStub.unlock(sid, "", object.getURI().toString());
            }
            catch (AuthFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
            catch (IoFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
            catch (ObjectNotFoundFault e) {
                Activator.handleError(e, e.getMessage(), object);
            }
        }
        return false;
    }

    public boolean removeJobFromRegistry(TextGridObject object) {
        LockingJob lockingJob = jobRegistry.get(object);
        if (lockingJob != null) {
            lockingJob.cancel();
            jobRegistry.remove(object);
            return true;
        }
        return false;
    }

    public boolean objectIsLocked(TextGridObject object) {
        return jobRegistry.containsKey(object);
    }

    public void removeAllJobsFromRegistry() {
        for (Map.Entry<TextGridObject, LockingJob> e : jobRegistry.entrySet()) {
            this.unlockObject((TextGridObject)e.getValue());
        }
    }
}

