/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class WatchExpressionAction
implements IViewActionDelegate {
    IWorkbenchPart fPart = null;
    private static IWatchExpression[] EMPTY_EXPRESSION_ARRAY = new IWatchExpression[0];
    static /* synthetic */ Class class$0;

    public void init(IViewPart view) {
        this.fPart = view;
    }

    protected IDebugElement getContext() {
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        return context;
    }

    protected IWatchExpression[] getSelectedExpressions() {
        LinkedList list = new LinkedList();
        IStructuredSelection currentSelection = this.getCurrentSelection();
        if (currentSelection == null) {
            return EMPTY_EXPRESSION_ARRAY;
        }
        Iterator iter = currentSelection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IWatchExpression) {
                list.add(element);
                continue;
            }
            if (element instanceof IAdaptable) {
                IWatchExpression expr;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.core.model.IWatchExpression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((expr = (IWatchExpression)iAdaptable.getAdapter((Class)clazz)) != null) {
                    list.add(expr);
                    continue;
                }
                return EMPTY_EXPRESSION_ARRAY;
            }
            return EMPTY_EXPRESSION_ARRAY;
        }
        return list.toArray(new IWatchExpression[list.size()]);
    }

    public void selectionChanged(IAction action, ISelection sel) {
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected void showErrorMessage(String message) {
        if (this.fPart instanceof IViewPart) {
            IViewSite viewSite = ((IViewPart)this.fPart).getViewSite();
            IStatusLineManager manager = viewSite.getActionBars().getStatusLineManager();
            manager.setErrorMessage(message);
            Display.getCurrent().beep();
        }
    }
}

