/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import com.google.common.base.Predicate;
import info.textgrid._import.ImportObject;
import info.textgrid.lab.core.importexport.ImportPlugin;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.importexport.ui.Messages;
import info.textgrid.lab.core.importexport.ui.ResultPage;
import info.textgrid.lab.core.importexport.ui.TargetProjectCombo;
import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wb.swt.ResourceManager;

public abstract class ImportExportPart
extends EditorPart {
    private TargetProjectCombo projectCombo;
    private ImportModel importModel;
    private TreeViewer objectsViewer;
    private TextGridObject.ITextGridObjectListener textGridObjectListener;
    protected boolean export;
    private Button performButton;
    private Composite content;
    protected ControlEnableState noProjectDisabledState;
    protected Group importGroup;
    private boolean dirty;
    private IResourceChangeListener resourceChangeListener;
    protected PageBook pages;
    protected ResultPage resultPage;
    private Button nextButton;

    protected Composite getContent() {
        return this.content;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.importModel != null) {
            IFile file = (IFile)AdapterUtils.getAdapter((Object)this.getEditorInput(), IFile.class);
            if (file != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    this.importModel.save(new StreamResult(outputStream));
                    file.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, true, monitor);
                    this.setDirty(false);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                }
            } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
                URI targetURI = ((FileStoreEditorInput)this.getEditorInput()).getURI();
                try {
                    IFileStore store = EFS.getStore((URI)targetURI);
                    OutputStream outputStream = store.openOutputStream(0, monitor);
                    this.importModel.save(new StreamResult(outputStream));
                    outputStream.close();
                    this.setDirty(false);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                }
                catch (IOException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportExportPart_Save_Failed, (Object)targetURI, (Object)e.getLocalizedMessage()), (Throwable)e), 3);
                }
            } else {
                this.doSaveAs();
            }
        }
    }

    public void doSaveAs() {
        int selection = new MessageDialog(this.getSite().getShell(), Messages.ImportExportPart_Save_As_Title, null, Messages.ImportExportPart_Save_As_What, 6, new String[]{Messages.ImportExportPart_TextGridRep, Messages.ImportExportPart_Local_File, Messages.ImportExportPart_Cancel}, this.isExport() ? 1 : 0).open();
        switch (selection) {
            case 0: {
                this.saveAsTextGridObject(true);
                break;
            }
            case 1: {
                this.saveAsLocalFile();
            }
        }
    }

    public void saveAsTextGridObject(boolean forceNew) {
        TextGridObject object = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            object = (TextGridObject)AdapterUtils.getAdapter((Object)((IFileEditorInput)this.getEditorInput()).getFile(), TextGridObject.class);
        }
        if (object == null || forceNew) {
            object = TextGridObject.getNewObjectInstance((TextGridProject)this.getImportModel().getTargetProject(), (TGContentType)TGContentType.of((String)"text/tg.imex+xml"));
            InputDialog dialog = new InputDialog(this.getSite().getShell(), Messages.ImportExportPart_Save_as_TextGrid_Title, NLS.bind((String)Messages.ImportExportPart_Save_to_Target_Project, (Object)this.getImportModel().getTargetProject()), "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.trim().isEmpty()) {
                        return Messages.ImportExportPart_Title_Validation_Warning;
                    }
                    return null;
                }
            });
            if (dialog.open() == 1) {
                return;
            }
            object.setTitle(dialog.getValue().trim());
            IEditorInput input = (IEditorInput)AdapterUtils.getAdapter((Object)object, IEditorInput.class);
            this.setInputWithNotify(input);
        }
        new Job(NLS.bind((String)Messages.ImportExportPart_Saving_x, (Object)object)){

            protected IStatus run(IProgressMonitor monitor) {
                ImportExportPart.this.doSave(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void saveAsLocalFile() {
        FileDialog fileDialog = new FileDialog(this.getSite().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"." + TGContentType.getContentType((String)"text/tg.imex+xml").getExtension()});
        fileDialog.setFilterNames(new String[]{TGContentType.getContentType((String)"text/tg.imex+xml").getDescription()});
        fileDialog.setText(Messages.ImportExportPart_SaveImportSpecAsTitle);
        String fileName = fileDialog.open();
        if (fileName != null) {
            URI fileURI = new File(fileName).toURI();
            try {
                FileStoreEditorInput input = new FileStoreEditorInput(EFS.getStore((URI)fileURI));
                this.setPartName(input.getName());
                this.setInputWithNotify((IEditorInput)input);
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (ImportExportPart.this.getEditorInput() instanceof IFileEditorInput) {
                    IFile inputFile = ((IFileEditorInput)ImportExportPart.this.getEditorInput()).getFile();
                    IResourceDelta delta = event.getDelta().findMember(inputFile.getFullPath());
                    if (delta != null) {
                        if ((delta.getFlags() & 0x2000) != 0) {
                            IPath newPath = delta.getMovedToPath();
                            final IResource newFile = inputFile.getWorkspace().getRoot().findMember(newPath);
                            new UIJob(Messages.ImportExportPart_Updating_input){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ImportExportPart.this.setInputWithNotify((IEditorInput)new FileEditorInput((IFile)newFile));
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        } else {
                            StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.core.importexport", "There was a resource change event to our input which we didn't handle: " + ((ResourceDelta)delta).toDebugString()));
                        }
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        file = (IFile)AdapterUtils.getAdapter((Object)input, IFile.class);
        if (file != null) {
            try {
                uri = file.getLocationURI();
                if (!uri.isAbsolute() || uri.getScheme().equals("textgrid-efs")) {
                    object = (TextGridObject)AdapterUtils.getAdapter((Object)input, TextGridObject.class);
                    uri = object.getURI();
                }
                this.importModel = ImportModel.load(new StreamSource(file.getContents(), uri.toString()));
                if (this.export) ** GOTO lbl34
                this.importModel.initializeLoadedModelForImport(null);
            }
            catch (JAXBException e) {
                throw new PartInitException(NLS.bind((String)Messages.ImportExportPart_Could_not_load_import_definition, (Object)input, (Object)e.getLocalizedMessage()), (Throwable)e);
            }
            catch (CoreException e) {
                throw new PartInitException(NLS.bind((String)Messages.ImportExportPart_Could_not_load_import_definition, (Object)input, (Object)e.getLocalizedMessage()), (Throwable)e);
            }
        } else if (input instanceof FileStoreEditorInput) {
            try {
                uri = ((FileStoreEditorInput)input).getURI();
                fileStore = EFS.getStore((URI)uri);
                this.importModel = ImportModel.load(new StreamSource(fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor()), uri.toString()));
                this.setPartName(input.getName());
                if (this.export) ** GOTO lbl34
                this.handleMissingFiles(input);
                this.importModel.initializeLoadedModelForImport(null);
            }
            catch (CoreException e) {
                throw new PartInitException(NLS.bind((String)Messages.ImportExportPart_Could_not_load_import_definition, (Object)input, (Object)e.getLocalizedMessage()), (Throwable)e);
            }
            catch (JAXBException e) {
                throw new PartInitException(NLS.bind((String)Messages.ImportExportPart_Could_not_load_import_definition, (Object)input, (Object)e.getLocalizedMessage()), (Throwable)e);
            }
        } else {
            this.setPartName(Messages.ImportExportPart_GenericTitle);
        }
lbl34:
        // 5 sources

        this.setInputWithNotify(input);
    }

    private void handleMissingFiles(IEditorInput input) throws PartInitException {
        ImportModel.LocalFileStatus localFileStatus;
        block4: while ((localFileStatus = this.importModel.checkLocalFiles(null)).allMissing()) {
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), NLS.bind((String)Messages.ImportExportPart_LoadingImex, (Object)input.getName()), null, NLS.bind((String)Messages.ImportExportPart_NoFileFoundChoice, (Object)localFileStatus.missingFiles.get(0)), 3, new String[]{Messages.ImportExportPart_SelectRootFolder, Messages.ImportExportPart_OpenForExport, Messages.ImportExportPart_OpenAnyway}, 1);
            dialog.setBlockOnOpen(true);
            int choice = dialog.open();
            switch (choice) {
                case 0: {
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.getSite().getShell());
                    directoryDialog.setFilterPath(this.importModel.getRoot().toOSString());
                    directoryDialog.setFilterPath(Messages.ImportExportPart_ImportRootTitle);
                    directoryDialog.setMessage(NLS.bind((String)Messages.ImportExportPart_ImportRootPrompt, (Object)localFileStatus.missingFiles.get(0)));
                    String newRoot = directoryDialog.open();
                    if (newRoot == null) continue block4;
                    this.importModel.setRoot((IPath)new Path(newRoot));
                    break;
                }
                case 1: {
                    final IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
                    page.openEditor(input, "info.textgrid.lab.core.importexport.ExportEditor");
                    new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            page.closeEditor((IEditorPart)ImportExportPart.this, false);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.getEditorInput() != null && this.getImportModel() != null;
    }

    private void setErrorMessage(String message) {
        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", message), 3);
    }

    public ImportModel getImportModel() {
        if (this.importModel == null) {
            this.importModel = new ImportModel();
        }
        return this.importModel;
    }

    private void setObjectsViewer(TreeViewer objectsViewer) {
        this.objectsViewer = objectsViewer;
    }

    TreeViewer getObjectsViewer() {
        return this.objectsViewer;
    }

    private static TreeViewerColumn makeColumn(TreeViewer treeViewer, int style, String text, String tooltip, int width) {
        TreeViewerColumn result = new TreeViewerColumn(treeViewer, style);
        result.getColumn().setText(text);
        result.getColumn().setToolTipText(tooltip);
        result.getColumn().setWidth(width);
        result.getColumn().setMoveable(true);
        return result;
    }

    protected void addSelection(IStructuredSelection selection) {
        List list = selection.toList();
        AddObjectsJob addObjectsJob = new AddObjectsJob(Messages.ImportExportPart_Adding_objects, list);
        addObjectsJob.setUser(true);
        addObjectsJob.schedule();
    }

    public void createPartControl(Composite parent) {
        this.pages = new PageBook(parent, 0);
        this.content = new Composite((Composite)this.pages, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.content);
        GridLayout contentLayout = GridLayoutFactory.fillDefaults().create();
        this.content.setLayout((Layout)contentLayout);
        this.importGroup = new Group(this.content, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.importGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.importGroup);
        this.createTopArea((Composite)this.importGroup);
        this.setObjectsViewer(new TreeViewer((Composite)this.importGroup, 65536));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getObjectsViewer().getTree());
        this.getObjectsViewer().getTree().setHeaderVisible(true);
        this.getObjectsViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MetaDataView metadataView;
                if (event.getSelection().isEmpty() && (metadataView = (MetaDataView)ImportExportPart.this.getSite().getPage().findView("info.textgrid.lab.core.metadataeditor.view")) != null) {
                    metadataView.setVisible(false);
                }
            }
        });
        this.createFileColumn(this.getObjectsViewer());
        this.createUriColumn(this.getObjectsViewer());
        this.createTitleColumn(this.getObjectsViewer());
        this.createFormatColumn(this.getObjectsViewer());
        this.createRewriteColumn(this.getObjectsViewer());
        this.getObjectsViewer().setContentProvider((IContentProvider)new ImportModelContentProvider());
        this.getObjectsViewer().setInput((Object)this.getImportModel());
        this.createAreaBelowObjectsViewer(this.content);
        Composite targetArea = this.createTargetArea(this.content);
        this.createBottomButtons(targetArea);
        this.hookTextGridObjectListener();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getObjectsViewer());
        if (!this.export && this.getProjectCombo().getSelection().isEmpty()) {
            this.getProjectCombo().getControl().setFocus();
            this.noProjectDisabledState = ControlEnableState.disable((Control)this.importGroup);
        }
        this.resultPage = new ResultPage((Composite)this.pages, this);
        this.pages.showPage((Control)this.getContent());
    }

    protected void createTopArea(Composite parent) {
    }

    protected void createAreaBelowObjectsViewer(Composite content2) {
    }

    protected abstract Composite createTargetArea(Composite var1);

    private void hookTextGridObjectListener() {
        this.textGridObjectListener = new TextGridObject.ITextGridObjectListener(){

            public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, final TextGridObject object) {
                if (event == TextGridObject.ITextGridObjectListener.Event.METADATA_CHANGED && ImportExportPart.this.importModel != null && ImportExportPart.this.getObjectsViewer() != null) {
                    try {
                        final ImportObject importObject = ImportExportPart.this.importModel.findEntry((Predicate<? super ImportObject>)new Predicate<ImportObject>(){

                            public boolean apply(ImportObject input) {
                                return input.getTextgridUri().equals(object.getURI().toString());
                            }
                        });
                        new UIJob(Messages.ImportExportPart_Updating){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (ImportExportPart.this.getObjectsViewer().getTree() != null && !ImportExportPart.this.getObjectsViewer().getTree().isDisposed()) {
                                    ImportExportPart.this.getObjectsViewer().refresh((Object)importObject);
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
        };
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this.textGridObjectListener);
    }

    private void createBottomButtons(Composite targetComposite) {
        Composite buttonBar = new Composite(targetComposite, 0);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.wrap = false;
        buttonBar.setLayout((Layout)layout);
        this.performButton = new Button(buttonBar, 8);
        this.performButton.setText(this.isExport() ? Messages.ImportExportPart_Export : Messages.ImportExportPart_Import);
        if (ImportPlugin.useNewGUI()) {
            this.performButton.setImage(ImportPlugin.getDefault().getImageRegistry().get(this.isExport() ? "icon-export" : "icon-import"));
        }
        this.performButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportPart.this.perform();
            }
        });
        this.getSite().getShell().setDefaultButton(this.performButton);
        if (ImportPlugin.useNewGUI()) {
            this.createNextButton(buttonBar);
        }
    }

    protected abstract void perform();

    public void dispose() {
        TextGridObject.removeListener((TextGridObject.ITextGridObjectListener)this.textGridObjectListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    private void createFormatColumn(final TreeViewer importObjects) {
        TreeViewerColumn contentTypeColumn = ImportExportPart.makeColumn(importObjects, 16384, Messages.ImportExportPart_Format, Messages.ImportExportPart_Format_Desc, 100);
        contentTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return this.getContentType(element).getDescription();
            }

            public Image getImage(Object element) {
                return this.getContentType(element).getImage(false);
            }

            private TGContentType getContentType(Object element) {
                TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (object != null) {
                    try {
                        return object.getContentType(false);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                    }
                }
                return TGContentType.getContentType((String)"unknown/unknown");
            }
        });
        if (!this.isExport()) {
            contentTypeColumn.setEditingSupport(new EditingSupport((ColumnViewer)importObjects){
                private ComboBoxViewerCellEditor editor;

                protected CellEditor getCellEditor(Object element) {
                    if (this.editor == null) {
                        this.editor = new ComboBoxViewerCellEditor((Composite)importObjects.getTree());
                        this.editor.setContenProvider(new IStructuredContentProvider(){

                            public void dispose() {
                            }

                            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                            }

                            public Object[] getElements(Object inputElement) {
                                return TGContentType.getContentTypes((boolean)false);
                            }
                        });
                        this.editor.setInput(TGContentType.class);
                    }
                    return this.editor;
                }

                protected boolean canEdit(Object element) {
                    return AdapterUtils.getAdapter((Object)element, TextGridObject.class) != null;
                }

                protected Object getValue(Object element) {
                    try {
                        return ((TextGridObject)AdapterUtils.getAdapterChecked((Object)element, TextGridObject.class)).getContentType(true);
                    }
                    catch (AdapterUtils.AdapterNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                protected void setValue(Object element, Object value) {
                    TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                    if (object != null) {
                        if (value == null) {
                            String mimeType = this.editor.getViewer().getCCombo().getText();
                            if (mimeType != null && !"".equals(mimeType)) {
                                object.setContentType(TGContentType.of((String)mimeType.trim()));
                                object.notifyMetadataEditor();
                                this.editor.getViewer().refresh();
                            }
                        } else {
                            object.setContentType((TGContentType)value);
                            object.notifyMetadataEditor();
                        }
                    }
                }
            });
        }
    }

    private void createTitleColumn(final TreeViewer importObjects) {
        TreeViewerColumn titleColumn = ImportExportPart.makeColumn(importObjects, 16384, Messages.ImportExportPart_Title, Messages.ImportExportPart_Title_Desc, 200);
        titleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ImportObject) {
                    try {
                        return TextGridObject.getInstanceOffline((URI)URI.create(((ImportObject)element).getTextgridUri())).getTitle();
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                    }
                }
                return "";
            }
        });
        if (!this.isExport()) {
            titleColumn.setEditingSupport(new EditingSupport((ColumnViewer)importObjects){
                private TextCellEditor editor;
                {
                    super($anonymous0);
                    this.editor = null;
                }

                protected void setValue(Object element, Object value) {
                    TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                    if (value instanceof String) {
                        object.setTitle((String)value);
                        object.notifyMetadataEditor();
                    }
                }

                protected Object getValue(Object element) {
                    TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                    String title = null;
                    if (object != null) {
                        try {
                            title = object.getTitle();
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                        }
                    }
                    if (title == null) {
                        title = "";
                    }
                    return title;
                }

                protected CellEditor getCellEditor(Object element) {
                    if (this.editor == null) {
                        this.editor = new TextCellEditor((Composite)importObjects.getTree());
                    }
                    return this.editor;
                }

                protected boolean canEdit(Object element) {
                    return AdapterUtils.getAdapter((Object)element, TextGridObject.class) != null;
                }
            });
        }
    }

    private void createUriColumn(TreeViewer importObjects) {
        TreeViewerColumn uriColumn = ImportExportPart.makeColumn(importObjects, 16384, Messages.ImportExportPart_URI, Messages.ImportExportPart_URI_Desc, 100);
        uriColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ImportEntry) {
                    ImportEntry entry = (ImportEntry)((Object)element);
                    if (entry.isNewRevisionImport()) {
                        return String.valueOf(entry.getExistingObject().getLatestURI()) + ".*";
                    }
                    return entry.getTextgridUri();
                }
                return "";
            }

            public Image getImage(Object element) {
                ImportEntry entry;
                if (element instanceof ImportEntry && (entry = (ImportEntry)((Object)element)).isReimport()) {
                    if (entry.isNewRevisionImport()) {
                        return ImportPlugin.getDefault().getImageRegistry().get("reimport-revision");
                    }
                    return ImportPlugin.getDefault().getImageRegistry().get("reimport-new");
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof ImportEntry) {
                    ImportEntry entry = (ImportEntry)((Object)element);
                    if (entry.isReimport()) {
                        if (entry.isNewRevisionImport()) {
                            return NLS.bind((String)Messages.ImportExportPart_x_Reimport_New_Revision_y, (Object)entry.getLocalFile().getName(), (Object)entry.getExistingObject());
                        }
                        return NLS.bind((String)Messages.ImportExportPart_x_Reimport_New_Object, (Object)entry.getLocalFile().getName());
                    }
                    return NLS.bind((String)Messages.ImportExportPart_x_Import_New_Object, (Object)entry.getLocalFile().getName());
                }
                return super.getToolTipText(element);
            }
        });
    }

    private void createFileColumn(TreeViewer importObjects) {
        TreeViewerColumn fileColumn = ImportExportPart.makeColumn(importObjects, 16384, Messages.ImportExportPart_File, Messages.ImportExportPart_File_Desc, 200);
        fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ImportObject) {
                    ImportObject o = (ImportObject)element;
                    Path path = new Path(o.getLocalData());
                    return path.toOSString();
                }
                return element.toString();
            }
        });
    }

    private void createRewriteColumn(final TreeViewer importObjects) {
        TreeViewerColumn rewriteColumn = ImportExportPart.makeColumn(importObjects, 16384, Messages.ImportExportPart_Rewriting, Messages.ImportExportPart_Rewriting_Desc, 100);
        rewriteColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ImportEntry) {
                    return ((ImportEntry)((Object)element)).getRewriteSetup().toString();
                }
                return super.getText(element);
            }
        });
        rewriteColumn.setEditingSupport(new EditingSupport((ColumnViewer)importObjects){
            private ComboBoxViewerCellEditor editor;

            protected void setValue(Object element, Object value) {
                if (element instanceof ImportEntry && value instanceof RewriteSetup) {
                    ((ImportEntry)((Object)element)).setRewriteSetup((RewriteSetup)value);
                    importObjects.refresh(element);
                    ImportExportPart.this.setDirty(true);
                }
                if (value == null) {
                    String text = this.editor.getViewer().getCCombo().getText();
                    if (element instanceof ImportEntry) {
                        try {
                            URI uri = new URI(text.trim());
                            RewriteSetup setup = new RewriteSetup(ImportExportPart.this.getImportModel(), uri);
                            List<RewriteSetup> setups = ImportExportPart.this.getImportModel().getAvailableSetups();
                            if (!setups.contains(setup)) {
                                setups.add(setup);
                                this.editor.setInput(setups);
                            }
                            ((ImportEntry)((Object)element)).setRewriteSetup(setup);
                        }
                        catch (URISyntaxException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportExportPart_RewriteSetupNotURI, (Object)text), (Throwable)e));
                        }
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ImportEntry) {
                    return ((ImportEntry)((Object)element)).getRewriteSetup();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.editor == null) {
                    this.editor = new ComboBoxViewerCellEditor((Composite)importObjects.getTree());
                    this.editor.setContenProvider((IStructuredContentProvider)new ArrayContentProvider());
                    this.editor.setInput(ImportExportPart.this.getImportModel().getAvailableSetups());
                }
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof ImportObject;
            }
        });
    }

    public void setFocus() {
        if (this.content != null) {
            this.content.setFocus();
        }
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
        UIJob uiJob = new UIJob("Set dirty"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ImportExportPart.this.firePropertyChange(257);
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    protected void setExport(boolean export) {
        this.export = export;
    }

    public void setProjectCombo(TargetProjectCombo projectCombo) {
        this.projectCombo = projectCombo;
    }

    public TargetProjectCombo getProjectCombo() {
        return this.projectCombo;
    }

    protected boolean isExport() {
        return this.export;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        String title = input instanceof NullEditorInput ? (this.isExport() ? Messages.ImportExportPart_Export_Part_Title : Messages.ImportExportPart_Import_Part_Title) : NLS.bind((String)(this.isExport() ? Messages.ImportExportPart_Export_Part_Title_File : Messages.ImportExportPart_Import_Part_Title_File), (Object)input.getName());
        this.setPartName(title);
        this.setContentDescription(input.getToolTipText());
        this.firePropertyChange(1);
    }

    protected void setInputWithNotify(IEditorInput input) {
        this.setInput(input);
        this.firePropertyChange(258);
    }

    protected void createRemoveButton(Composite topGroup) {
        Button remButton = new Button(topGroup, 0x800000);
        remButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        remButton.setText(Messages.ImportExportPart_Remove);
        remButton.setToolTipText(Messages.ImportExportPart_Remove_Tooltip);
        remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection selection = (ITreeSelection)ImportExportPart.this.getObjectsViewer().getSelection();
                TreePath[] treePathArray = selection.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    ImportExportPart.this.getImportModel().remove(path);
                    ++n2;
                }
                ImportExportPart.this.getObjectsViewer().refresh();
            }
        });
    }

    protected void createNextButton(Composite targetArea) {
        this.nextButton = new Button(targetArea, 0x800000);
        this.getNextButton().setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/elcl16/forward_nav.gif"));
        this.getNextButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportPart.this.pages.showPage(ImportExportPart.this.pages.getChildren()[1]);
            }
        });
        this.getNextButton().setEnabled(false);
    }

    protected Button getNextButton() {
        return this.nextButton;
    }

    private final class AddObjectsJob
    extends Job {
        private final List<?> objects;
        private ImportEntry entry;

        private AddObjectsJob(String name, List<?> objects) {
            super(name);
            this.objects = objects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.objects.size() * 100));
            for (Object o : this.objects) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                TGObjectReference reference = (TGObjectReference)AdapterUtils.getAdapter(o, TGObjectReference.class);
                if (reference != null) {
                    this.entry = ImportExportPart.this.getImportModel().addObject(reference, (IProgressMonitor)progress.newChild(100));
                } else {
                    TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter(o, TextGridObject.class);
                    if (textGridObject != null) {
                        this.entry = ImportExportPart.this.getImportModel().addObject(new TGObjectReference(textGridObject.getURI().toString(), textGridObject), (IProgressMonitor)progress.newChild(100));
                    }
                }
                new UIJob(Messages.ImportExportPart_Updating_Display){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TreeViewer viewer = ImportExportPart.this.getObjectsViewer();
                        if (viewer.getControl().isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        viewer.refresh(true);
                        if (AddObjectsJob.this.entry != null) {
                            viewer.setSelection((ISelection)new StructuredSelection((Object)AddObjectsJob.this.entry), true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            return Status.OK_STATUS;
        }
    }

    private final class ImportModelContentProvider
    implements ITreeContentProvider {
        private ImportModelContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ImportModel && !((ImportModel)((Object)element)).getImportObject().isEmpty()) {
                return true;
            }
            if (element instanceof ImportEntry) {
                return !((ImportEntry)((Object)element)).getChildEntries().isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ImportModel) {
                return ((ImportModel)((Object)parentElement)).getChildren().toArray();
            }
            if (parentElement instanceof ImportEntry) {
                return ((ImportEntry)((Object)parentElement)).getChildEntries().toArray();
            }
            return new Object[0];
        }
    }
}

