/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.newsearch;

import info.textgrid.lab.search.ui.newsearch.Messages;
import java.util.ArrayList;

public class SearchTextType {
    private SearchTextType root;
    private String textType;
    private String label;
    private ArrayList<SearchTextType> children = new ArrayList();

    public SearchTextType(String label, String textType, boolean init) {
        this.textType = textType;
        this.label = label;
        if (init) {
            this.root = this;
            this.init();
        }
    }

    public String toString() {
        return this.label;
    }

    public String getTextType() {
        return this.textType;
    }

    public void add(SearchTextType child) {
        this.children.add(child);
    }

    public SearchTextType[] getChildren() {
        return this.children.toArray(new SearchTextType[0]);
    }

    public int getChildCount() {
        return this.root.getChildren()[0].getChildren().length + 1;
    }

    private void init() {
        SearchTextType textTypes = new SearchTextType(Messages.SearchTextType_TextTypes, "", false);
        this.root.add(textTypes);
        SearchTextType drama = new SearchTextType(Messages.SearchTextType_Drama, "drama", false);
        SearchTextType prose = new SearchTextType(Messages.SearchTextType_Prose, "prose", false);
        SearchTextType verse = new SearchTextType(Messages.SearchTextType_Verse, "verse", false);
        SearchTextType referencework = new SearchTextType(Messages.SearchTextType_ReferenceWork, "referencework", false);
        SearchTextType nonfiction = new SearchTextType(Messages.SearchTextType_NonFiction, "none-fiction", false);
        SearchTextType nontext = new SearchTextType(Messages.SearchTextType_NonText, "none-text", false);
        SearchTextType other = new SearchTextType(Messages.SearchTextType_Other, "other", false);
        textTypes.add(drama);
        textTypes.add(prose);
        textTypes.add(verse);
        textTypes.add(referencework);
        textTypes.add(nonfiction);
        textTypes.add(nontext);
        textTypes.add(other);
    }
}

