/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.core.aggregations.ui.treeWriter.AggregationWriter;
import info.textgrid.lab.core.model.AggregationReader;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.navigator.Activator;
import info.textgrid.lab.navigator.CopyService;
import info.textgrid.lab.navigator.Messages;
import info.textgrid.lab.navigator.NaviView;
import info.textgrid.lab.ui.core.DropSetValues;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    private boolean ToggleState;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, final Object aTarget) {
        if (aDropTargetEvent.data == null) return Status.CANCEL_STATUS;
        if (aDropTargetEvent.data instanceof TreeSelection) {
            try {
                MessageDialog messageDialog;
                int buttonID;
                LocalSelectionTransfer localTransfer = LocalSelectionTransfer.getTransfer();
                ArrayList<String> tgSelectionUris = new ArrayList<String>();
                if (aTarget instanceof TextGridProject) {
                    String targetName = ((TextGridProject)aTarget).getId();
                    if (!(localTransfer.getSelection() instanceof TreeSelection)) return Status.OK_STATUS;
                    TreeSelection treeSelection = (TreeSelection)localTransfer.getSelection();
                    for (Object next : treeSelection) {
                        TextGridObject tgo1 = (TextGridObject)AdapterUtils.getAdapter(next, TextGridObject.class);
                        if (tgo1 == null) continue;
                        if (tgo1.getProject().equals(targetName)) {
                            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                            return Status.CANCEL_STATUS;
                        }
                        tgSelectionUris.add(tgo1.getURI().toString());
                    }
                    CopyService.getInstance().copy(tgSelectionUris, targetName);
                    return Status.OK_STATUS;
                }
                if (!(aTarget instanceof TGObjectReference)) return Status.OK_STATUS;
                this.ToggleState = ConfPlugin.getDefault().getPreferenceStore().getBoolean("movewarning");
                if (this.ToggleState && (buttonID = (messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.MOVE_ShowReport, null, Messages.MOVE_ReportMessage, 3, new String[]{"OK", Messages.CopyService_Cancel}, 1)).open()) != 0) {
                    return Status.CANCEL_STATUS;
                }
                final TextGridObject target = ((TGObjectReference)aTarget).getTgo();
                target.refreshWorkspaceIfNeccessary();
                final HashMap<TextGridObject, LinkedList<String>> aggregationMap = new HashMap<TextGridObject, LinkedList<String>>();
                final List aggregatesTarget = AggregationReader.read((TextGridObject)target, (boolean)false);
                final ArrayList<TGObjectReference> movedTGOs = new ArrayList<TGObjectReference>();
                if (!(localTransfer.getSelection() instanceof TreeSelection)) return Status.OK_STATUS;
                TreeSelection treeSelection = (TreeSelection)localTransfer.getSelection();
                for (Object next : treeSelection) {
                    if (!(next instanceof TGObjectReference)) continue;
                    try {
                        aggregatesTarget.add(new URI(((TGObjectReference)next).getTgo().getLatestURI()));
                        movedTGOs.add((TGObjectReference)next);
                        if (!((TGObjectReference)next).isPartOfAggregation()) continue;
                        TextGridObject aggregation = ((TGObjectReference)next).getAggregation().getTgo();
                        LinkedList<String> list = (LinkedList<String>)aggregationMap.get(aggregation);
                        if (list == null) {
                            list = new LinkedList<String>();
                        }
                        list.add(((TGObjectReference)next).getRefUri());
                        aggregationMap.put(aggregation, list);
                    }
                    catch (URISyntaxException e) {
                        Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotCreateURI, ((TGObjectReference)next).getTgo());
                    }
                }
                for (TGObjectReference ref : movedTGOs) {
                    ref.setAggregation((TGObjectReference)aTarget);
                }
                Job saveJob = new Job(NLS.bind((String)Messages.CommonDropAdapterAssistant_IM_SavingAggregation, (Object)((TGObjectReference)aTarget).getTgo())){

                    protected IStatus run(IProgressMonitor monitor) {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CommonDropAdapterAssistant_IM_SavingAggregaion, null), (int)aggregatesTarget.size());
                        ByteArrayOutputStream aggregationContent = null;
                        try {
                            aggregationContent = new AggregationWriter().writeAggregation(null, aggregatesTarget, false, (IProgressMonitor)progress);
                        }
                        catch (XMLStreamException e) {
                            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, target);
                        }
                        catch (CoreException e) {
                            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, target);
                        }
                        IFile file = (IFile)AdapterUtils.getAdapter((Object)target, IFile.class);
                        if (file == null) {
                            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                        } else {
                            try {
                                file.setContents((InputStream)new ByteArrayInputStream(aggregationContent.toByteArray()), true, false, (IProgressMonitor)progress.newChild(aggregatesTarget.size()));
                            }
                            catch (CoreException e) {
                                Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, target);
                            }
                        }
                        for (Map.Entry e : aggregationMap.entrySet()) {
                            TextGridObject sourceAggregation = (TextGridObject)e.getKey();
                            List val = (List)e.getValue();
                            LinkedList<URI> sourceURIs = new LinkedList<URI>();
                            try {
                                sourceAggregation.refreshWorkspaceIfNeccessary();
                                List aggregatesSource = AggregationReader.read((TextGridObject)sourceAggregation, (boolean)false);
                                for (URI uri : aggregatesSource) {
                                    if (val.remove(uri.toString())) continue;
                                    sourceURIs.add(uri);
                                }
                                try {
                                    aggregationContent = new AggregationWriter().writeAggregation(null, sourceURIs, false, (IProgressMonitor)progress);
                                }
                                catch (XMLStreamException e2) {
                                    Activator.handleError(e2, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, sourceAggregation);
                                }
                                catch (CoreException e2) {
                                    Activator.handleError(e2, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, sourceAggregation);
                                }
                                IFile sourceFile = (IFile)AdapterUtils.getAdapter((Object)sourceAggregation, IFile.class);
                                if (sourceFile == null) {
                                    StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                                    continue;
                                }
                                try {
                                    sourceFile.setContents((InputStream)new ByteArrayInputStream(aggregationContent.toByteArray()), true, false, (IProgressMonitor)progress.newChild(aggregatesTarget.size()));
                                }
                                catch (CoreException e2) {
                                    Activator.handleError(e2, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, sourceAggregation);
                                }
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                            }
                        }
                        aggregationMap.clear();
                        return Status.OK_STATUS;
                    }
                };
                saveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            UIJob uiJob = new UIJob(Messages.CommonDropAdapterAssistant_IM_UpdateNavigatorGUI){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    for (TGObjectReference tgoRef : movedTGOs) {
                                        try {
                                            if (((TGObjectReference)aTarget).getTgo().getProjectInstance() == tgoRef.getTgo().getProjectInstance()) {
                                                NaviView.getViewer().remove((Object)tgoRef);
                                            }
                                        }
                                        catch (CoreException e) {
                                            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotUpdateNavigatorGUI, new Object[0]);
                                        }
                                        NaviView.getViewer().add(aTarget, (Object)tgoRef);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule(500L);
                        }
                    }
                });
                saveJob.setUser(true);
                saveJob.schedule();
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand("info.textgrid.lab.core.importexport.import");
        try {
            IParameter parameter = command.getParameter("info.textgrid.lab.core.importexport.import.usedroppedset");
            Parameterization parm = new Parameterization(parameter, "true");
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
            DropSetValues.setValues((String[])((String[])aDropTargetEvent.data));
            if (aTarget instanceof TextGridProject) {
                DropSetValues.setProject((TextGridProject)((TextGridProject)aTarget));
            }
            handlerService.executeCommand(parmCommand, null);
            return Status.OK_STATUS;
        }
        catch (NotDefinedException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
            return Status.OK_STATUS;
        }
        catch (ExecutionException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
            return Status.OK_STATUS;
        }
        catch (NotEnabledException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
            return Status.OK_STATUS;
        }
        catch (NotHandledException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        return Status.OK_STATUS;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        return true;
    }
}

