/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui;

import info.textgrid.lab.core.aggregations.ui.Messages;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.revisions.ui.SaveAsRevisionAggregationDialog;
import info.textgrid.lab.newsearch.SearchRequest;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveNewAggregationRevisionHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && editor instanceof AggregationComposerEditor) {
            TextGridObject tgo = ((AggregationComposerEditor)editor).getAggregationRoot().getObject();
            try {
                if (!tgo.getProjectInstance().hasPermissions(2)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SaveNewAggregationRevisionHandler_SaveAsNewRevision, (String)NLS.bind((String)Messages.SaveNewAggregationRevisionHandler_IM_NotAllowedToSave, (Object)tgo.getProjectInstance().getName()));
                    return null;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.aggregations.ui");
            }
            if (!SearchRequest.isTgoLatestRevision((String)tgo.getURI().toString())) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SaveNewAggregationRevisionHandler_SaveAsNewRevision, (String)Messages.SaveNewAggregationRevisionHandler_IM_SuccessiveRevision);
                return null;
            }
            SaveAsRevisionAggregationDialog dialog = new SaveAsRevisionAggregationDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            dialog.setBlockOnOpen(false);
            dialog.open();
            dialog.init((AggregationComposerEditor)editor);
        } else {
            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.aggregations.ui", Messages.SaveNewAggregationRevisionHandler_EM_NoOpenEditor), 2);
        }
        return null;
    }
}

