/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.views.WorkflowInputs;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddtoWorkflowHandler
extends AbstractHandler
implements IHandler {
    public static final String WORKFLOW_INPUTS_VIEW_ID = "info.textgrid.lab.workflow.views.WorkflowInputs";
    public static final String WORKFLOW_PERSPECTIVE_ID = "info.textgrid.lab.workflow.WorkflowPerspective";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Iterator iterator = selection.iterator();
            ArrayList<TextGridObject> tgos = new ArrayList<TextGridObject>();
            while (iterator.hasNext()) {
                TextGridObject object;
                Object next = iterator.next();
                if (!(next instanceof IAdaptable) || (object = (TextGridObject)((IAdaptable)next).getAdapter(TextGridObject.class)) == null) continue;
                tgos.add(object);
            }
            try {
                PlatformUI.getWorkbench().showPerspective(WORKFLOW_PERSPECTIVE_ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open workflow perspective", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            IViewPart wfView = null;
            wfView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(WORKFLOW_INPUTS_VIEW_ID);
            if (wfView != null && wfView instanceof WorkflowInputs) {
                WorkflowInputs wiInstance = (WorkflowInputs)wfView;
                wiInstance.addtoInputs(tgos, 0);
            }
        }
        return null;
    }
}

