/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.export.filenames;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.ibm.icu.text.Transliterator;
import info.textgrid.namespaces.metadata.agent._2010.AgentRoleType;
import info.textgrid.namespaces.metadata.agent._2010.AgentType;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.export.aggregations.AggregationEntry;
import info.textgrid.utils.export.aggregations.IAggregation;
import info.textgrid.utils.export.aggregations.IAggregationEntry;
import info.textgrid.utils.export.filenames.DefaultFilenamePolicy;
import info.textgrid.utils.export.filenames.FileExtensionMap;
import info.textgrid.utils.export.filenames.IFilenamePolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurableFilenamePolicy
implements IFilenamePolicy {
    private Iterable<Segment> segments;
    private boolean isParentPolicy;
    private Transliterator transliterator;
    private boolean uniqueFilenames = true;
    private Map<String, Map<URI, Integer>> usedNames = Maps.newHashMap();

    @Override
    public String translate(String source) {
        return this.transliterator.transliterate(source);
    }

    @Override
    public String getFilename(ObjectType object, boolean asParent) {
        return this.getFilename(new AggregationEntry(object, null)).toASCIIString();
    }

    @Override
    @Deprecated
    public URI getFilename(IAggregationEntry entry, boolean asParent) {
        return this.getFilename(entry);
    }

    @Override
    public URI getFilename(IAggregationEntry entry) {
        if (this.isParentPolicy) {
            if (entry.getParent().isPresent()) {
                entry = (IAggregationEntry)entry.getParent().get();
            } else {
                return URI.create("");
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Segment segment : this.segments) {
            segment.append(builder, entry);
        }
        String path = builder.toString();
        if (this.uniqueFilenames) {
            if (this.usedNames.containsKey(path)) {
                StringBuilder uniqueBuilder = new StringBuilder();
                for (Segment segment : this.segments) {
                    if (segment instanceof Builder.UniqueSegment) {
                        Builder.UniqueSegment seg = (Builder.UniqueSegment)segment;
                        seg.append(uniqueBuilder, entry, this.usedNames.get(path));
                        continue;
                    }
                    segment.append(uniqueBuilder, entry);
                }
                path = uniqueBuilder.toString();
            } else {
                HashMap uriMap = Maps.newHashMap();
                uriMap.put(entry.getTextGridURI(), 0);
                this.usedNames.put(path, uriMap);
            }
        }
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The path that this filename policy resolved to, " + path + ", cannot be used in an URI.", e);
        }
    }

    @Override
    public Optional<URI> getBase(IAggregationEntry entry) {
        URI filename = this.getFilename(entry);
        URI resolved = filename.resolve(".");
        if (resolved == null || resolved.getPath().isEmpty() || ".".equals(resolved.getPath())) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)resolved);
    }

    public boolean isUniqueFilenames() {
        return this.uniqueFilenames;
    }

    public ConfigurableFilenamePolicy setUniqueFilenames(boolean uniqueFilenames) {
        this.uniqueFilenames = uniqueFilenames;
        return this;
    }

    public static Builder builder(String pattern) {
        return new Builder(pattern);
    }

    private void setSegments(Iterable<Segment> segments) {
        this.segments = segments;
    }

    private void setIsParentPolicy(boolean isParentPolicy) {
        this.isParentPolicy = isParentPolicy;
    }

    private void setTransliterator(Transliterator transliterator) {
        this.transliterator = transliterator;
    }

    protected ConfigurableFilenamePolicy() {
    }

    public static class Builder {
        private String pattern;
        private boolean parent;
        private Transliterator transliterator;
        private Map<String, ConfigurableFilenamePolicy> subPolicies = Maps.newHashMap();
        private final ConfigurableFilenamePolicy policy;

        protected Builder(String pattern) {
            this.pattern = pattern;
            this.policy = new ConfigurableFilenamePolicy();
        }

        public Builder isParent() {
            this.parent = true;
            return this;
        }

        public Builder transliterator(Transliterator transliterator) {
            this.transliterator = transliterator;
            return this;
        }

        public Builder subPolicy(String name, ConfigurableFilenamePolicy policy) {
            this.subPolicies.put(name, policy);
            return this;
        }

        public ConfigurableFilenamePolicy build() {
            if (this.pattern == null) {
                throw new IllegalArgumentException("Cannot build a configurable filename policy without a pattern.");
            }
            if (this.transliterator == null) {
                this.transliterator = DefaultFilenamePolicy.getTransliterator();
            }
            this.policy.setIsParentPolicy(this.parent);
            this.policy.setTransliterator(this.transliterator);
            if (this.parent && !this.subPolicies.containsKey("parent")) {
                this.subPolicies.put("parent", this.policy);
            }
            ImmutableList<Segment> segments = this.parsePattern();
            this.policy.setSegments(segments);
            return this.policy;
        }

        private Segment parseVariable(StringCharacterIterator iter) {
            if (iter.current() == '{') {
                iter.next();
            }
            StringBuilder buf = new StringBuilder();
            char c = iter.current();
            while (c != '}' && c != '\uffff') {
                buf.append(c);
                c = iter.next();
            }
            String[] split = buf.toString().split("[|]");
            String var = split[0];
            String[] options = Arrays.copyOfRange(split, 1, split.length);
            if (this.subPolicies.containsKey(var)) {
                return new SubPolicySegment(this.subPolicies.get(var), options);
            }
            if ("uri".equals(var)) {
                return new URISegment(options);
            }
            if ("title".equals(var)) {
                return new TitleSegment(options);
            }
            if ("ext".equals(var)) {
                return new ExtensionSegment(options);
            }
            if ("author".equals(var)) {
                return new AuthorSegment(options);
            }
            if ("*".equals(var)) {
                return new UniqueSegment(options);
            }
            return new StaticSegment("{" + buf.toString() + "}");
        }

        protected ImmutableList<Segment> parsePattern() {
            StringBuilder buffer = new StringBuilder();
            ImmutableList.Builder segments = ImmutableList.builder();
            boolean escape = false;
            StringCharacterIterator iter = new StringCharacterIterator(this.pattern);
            char c = iter.first();
            while (c != '\uffff') {
                if (escape) {
                    buffer.append(c);
                    escape = false;
                } else if (c == '\\') {
                    escape = true;
                } else if (c == '{') {
                    String s = buffer.toString();
                    if (!s.isEmpty()) {
                        segments.add((Object)new StaticSegment(s));
                        buffer = new StringBuilder();
                    }
                    segments.add((Object)this.parseVariable(iter));
                } else if (c == '*') {
                    segments.add((Object)new UniqueSegment(new String[0]));
                } else {
                    buffer.append(c);
                }
                c = iter.next();
            }
            if (buffer.length() > 0) {
                segments.add((Object)new StaticSegment(buffer.toString()));
            }
            return segments.build();
        }

        public class AuthorSegment
        extends ListSegment {
            private final Function<AgentType, String> AGENT_NAME;
            private boolean fallback;

            public AuthorSegment(String ... options) {
                super(options);
                this.AGENT_NAME = new Function<AgentType, String>(){

                    public String apply(AgentType input) {
                        return input.getValue();
                    }
                };
            }

            @Override
            protected boolean handleOption(String option) {
                if (super.handleOption(option)) {
                    return true;
                }
                if ("fallback".equals(option)) {
                    this.fallback = true;
                    return true;
                }
                return false;
            }

            @Override
            public Iterable<String> getContentItems(IAggregationEntry entry) {
                if (entry.getMetadata().getWork() != null) {
                    List agents = entry.getMetadata().getWork().getAgent();
                    Iterable authors = Iterables.filter((Iterable)agents, (Predicate)new Predicate<AgentType>(){

                        public boolean apply(AgentType agent) {
                            return AgentRoleType.AUTHOR.equals((Object)agent.getRole());
                        }
                    });
                    if (authors.iterator().hasNext()) {
                        return Iterables.transform((Iterable)authors, this.AGENT_NAME);
                    }
                    if (this.fallback) {
                        return Iterables.transform((Iterable)agents, this.AGENT_NAME);
                    }
                } else {
                    if (entry instanceof IAggregation && ((IAggregation)entry).getWork().isPresent()) {
                        return this.getContentItems((IAggregationEntry)((IAggregation)entry).getWork().get());
                    }
                    if (entry.getParent().isPresent()) {
                        return this.getContentItems((IAggregationEntry)entry.getParent().get());
                    }
                }
                return null;
            }
        }

        public class TitleSegment
        extends ListSegment {
            @Override
            public Iterable<String> getContentItems(IAggregationEntry entry) {
                return entry.getMetadata().getGeneric().getProvided().getTitle();
            }

            public TitleSegment(String ... options) {
                super(options);
            }
        }

        public abstract class ListSegment
        extends MetadataSegment {
            protected Optional<String> separator;

            public ListSegment(String ... options) {
                super(options);
                this.separator = Optional.absent();
            }

            @Override
            protected boolean handleOption(String option) {
                if (super.handleOption(option)) {
                    return true;
                }
                Pattern SEP = Pattern.compile("^sep=(.+)$");
                Matcher matcher = SEP.matcher(option);
                if (matcher.matches()) {
                    this.separator = Optional.of((Object)matcher.group(1));
                    return true;
                }
                return false;
            }

            public abstract Iterable<String> getContentItems(IAggregationEntry var1);

            @Override
            public String getContent(IAggregationEntry entry) {
                Iterable<String> items = this.getContentItems(entry);
                if (items == null) {
                    return "";
                }
                if (this.separator.isPresent()) {
                    return Joiner.on((String)((String)this.separator.get())).join(items);
                }
                Iterator<String> iter = items.iterator();
                if (iter.hasNext()) {
                    return iter.next();
                }
                return "";
            }
        }

        public class URISegment
        extends MetadataSegment
        implements Segment {
            public URISegment(String ... options) {
                super(options);
            }

            @Override
            public String getContent(IAggregationEntry entry) {
                return entry.getMetadata().getGeneric().getGenerated().getTextgridUri().getValue();
            }
        }

        public class UniqueSegment
        extends MetadataSegment {
            private String pre;
            private String post;

            public UniqueSegment(String ... options) {
                super(options);
                this.pre = ".";
                this.post = "";
            }

            @Override
            public String getContent(IAggregationEntry entry) {
                return "";
            }

            public StringBuilder append(StringBuilder builder, IAggregationEntry entry, Map<URI, Integer> uriMap) {
                if (uriMap != null) {
                    Integer count;
                    URI uri = entry.getTextGridURI();
                    if (uriMap.containsKey(uri)) {
                        count = uriMap.get(uri);
                    } else {
                        count = uriMap.size();
                        uriMap.put(uri, count);
                    }
                    if (count > 0) {
                        builder.append(this.pre).append(count).append(this.post);
                    }
                }
                return builder;
            }

            @Override
            protected boolean handleOption(String option) {
                String[] split = option.split("=", 2);
                if (split.length < 2) {
                    return false;
                }
                if ("pre".equals(split[0])) {
                    this.pre = split[1];
                } else if ("post".equals(split[0])) {
                    this.post = split[1];
                } else {
                    return false;
                }
                return true;
            }

            @Override
            public StringBuilder append(StringBuilder builder, IAggregationEntry entry) {
                return this.append(builder, entry, null);
            }
        }

        protected abstract class MetadataSegment
        implements Segment {
            protected boolean raw = false;
            protected int maxlength = -1;

            public MetadataSegment(String ... options) {
                for (String option : options) {
                    this.handleOption(option);
                }
            }

            protected boolean handleOption(String option) {
                if ("raw".equals(option)) {
                    this.raw = true;
                } else if (option.matches("\\d+")) {
                    this.maxlength = Integer.parseInt(option);
                } else {
                    return false;
                }
                return true;
            }

            public abstract String getContent(IAggregationEntry var1);

            @Override
            public StringBuilder append(StringBuilder builder, IAggregationEntry entry) {
                String content = this.getContent(entry);
                if (!this.raw) {
                    content = Builder.this.transliterator.transform(content);
                }
                if (this.maxlength > 0) {
                    content = content.substring(0, Math.min(content.length(), this.maxlength));
                }
                return builder.append(content);
            }
        }

        protected class StaticSegment
        implements Segment {
            protected final String content;

            public StaticSegment(String content) {
                this.content = content;
            }

            @Override
            public StringBuilder append(StringBuilder builder, IAggregationEntry entry) {
                return builder.append(this.content);
            }
        }

        public class ExtensionSegment
        extends MetadataSegment
        implements Segment {
            public ExtensionSegment(String ... options) {
                super(options);
                this.raw = true;
            }

            @Override
            public String getContent(IAggregationEntry entry) {
                String format = entry.getMetadata().getGeneric().getProvided().getFormat();
                return (String)FileExtensionMap.getInstance().getFirstExtension(format).or((Object)"dat");
            }
        }

        public class SubPolicySegment
        extends MetadataSegment
        implements Segment {
            private final ConfigurableFilenamePolicy policy;
            private boolean addSlash;

            public SubPolicySegment(ConfigurableFilenamePolicy policy, String ... options) {
                super(options);
                this.policy = policy;
                this.raw = true;
            }

            @Override
            protected boolean handleOption(String option) {
                if ("/".equals(option)) {
                    this.addSlash = true;
                    return true;
                }
                return super.handleOption(option);
            }

            @Override
            public String getContent(IAggregationEntry entry) {
                String expansion = this.policy.getFilename(entry).toString();
                if (this.addSlash && expansion != null && !expansion.isEmpty() && !expansion.endsWith("/")) {
                    expansion = expansion.concat("/");
                }
                return expansion;
            }
        }
    }

    protected static interface Segment {
        public StringBuilder append(StringBuilder var1, IAggregationEntry var2);
    }
}

