/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.export.filenames;

import com.google.common.base.Optional;
import com.ibm.icu.text.Transliterator;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.export.aggregations.IAggregationEntry;
import info.textgrid.utils.export.filenames.FileExtensionMap;
import info.textgrid.utils.export.filenames.IFilenamePolicy;
import java.net.URI;

public class DefaultFilenamePolicy
implements IFilenamePolicy {
    public static final DefaultFilenamePolicy INSTANCE = new DefaultFilenamePolicy();
    protected static String TRANSFORM_RULES = "::Any-Latin;\n\u00c4 } [[:Upper:]] > AE;\n\u00c4 > Ae;\n\u00e4 > ae;\n\u00d6 } [[:Upper:]] > OE;\n\u00d6 > Oe;\n\u00f6 > oe;\n\u00dc } [[:Upper:]] > UE;\n\u00dc > Ue;\n\u00fc > ue;\n\u017f > s;\n\u1e9e > SS;\n::NFD();\n[:Latin:]{[:Mn:]+} > ;\n::NFC();\n\u00c6 > AE;\n\u00d0 > D;\n\u00d8 > O;\n\u00de > TH;\n\u00df > ss;\n\u00e6 > ae;\n\u00f0 > d;\n\u00f8 > o;\n\u00fe > th;\n\u0110 > D;\n\u0111 > d;\n\u0126 > H;\n\u0127 > h;\n\u0131 > i;\n\u0132 > IJ;\n\u0133 > ij;\n\u0138 > q;\n\u013f > L;\n\u0140 > l;\n\u0141 > L;\n\u0142 > l;\n\u0149 > \\'n;\n\u014a > N;\n\u014b > n;\n\u0152 > OE;\n\u0153 > oe;\n\u0166 > T;\n\u0167 > t;\n\u017f > s;\n\u0180 > b;\n\u0181 > B;\n\u0182 > B;\n\u0183 > b;\n\u0187 > C;\n\u0188 > c;\n\u0189 > D;\n\u018a > D;\n\u018b > D;\n\u018c > d;\n\u0190 > E;\n\u0191 > F;\n\u0192 > f;\n\u0193 > G;\n\u0195 > hv;\n\u0196 > I;\n\u0197 > I;\n\u0198 > K;\n\u0199 > k;\n\u019a > l;\n\u019d > N;\n\u019e > n;\n\u01a2 > OI;\n\u01a3 > oi;\n\u01a4 > P;\n\u01a5 > p;\n\u01ab > t;\n\u01ac > T;\n\u01ad > t;\n\u01ae > T;\n\u01b2 > V;\n\u01b3 > Y;\n\u01b4 > y;\n\u01b5 > Z;\n\u01b6 > z;\n\u01c4 > DZ;\n\u01c5 > Dz;\n\u01c6 > dz;\n\u01c7 > LJ;\n\u01c8 > Lj;\n\u01c9 > lj;\n\u01ca > NJ;\n\u01cb > Nj;\n\u01cc > nj;\n\u01e4 > G;\n\u01e5 > g;\n\u01f1 > DZ;\n\u01f2 > Dz;\n\u01f3 > dz;\n\u0221 > d;\n\u0224 > Z;\n\u0225 > z;\n\u0234 > l;\n\u0235 > n;\n\u0236 > t;\n\u0237 > j;\n\u0238 > db;\n\u0239 > qp;\n\u023a > A;\n\u023b > C;\n\u023c > c;\n\u023d > L;\n\u023e > T;\n\u023f > s;\n\u0240 > z;\n\u0243 > B;\n\u0244 > U;\n\u0246 > E;\n\u0247 > e;\n\u0248 > J;\n\u0249 > j;\n\u024c > R;\n\u024d > r;\n\u024e > Y;\n\u024f > y;\n\u0253 > b;\n\u0255 > c;\n\u0256 > d;\n\u0257 > d;\n\u025b > e;\n\u025f > j;\n\u0260 > g;\n\u0261 > g;\n\u0262 > G;\n\u0266 > h;\n\u0267 > h;\n\u0268 > i;\n\u026a > I;\n\u026b > l;\n\u026c > l;\n\u026d > l;\n\u0271 > m;\n\u0272 > n;\n\u0273 > n;\n\u0274 > N;\n\u0276 > OE;\n\u027c > r;\n\u027d > r;\n\u027e > r;\n\u0280 > R;\n\u0282 > s;\n\u0288 > t;\n\u0289 > u;\n\u028b > v;\n\u028f > Y;\n\u0290 > z;\n\u0291 > z;\n\u0299 > B;\n\u029b > G;\n\u029c > H;\n\u029d > j;\n\u029f > L;\n\u02a0 > q;\n\u02a3 > dz;\n\u02a5 > dz;\n\u02a6 > ts;\n\u02aa > ls;\n\u02ab > lz;\n\u1d00 > A;\n\u1d01 > AE;\n\u1d03 > B;\n\u1d04 > C;\n\u1d05 > D;\n\u1d06 > D;\n\u1d07 > E;\n\u1d0a > J;\n\u1d0b > K;\n\u1d0c > L;\n\u1d0d > M;\n\u1d0f > O;\n\u1d18 > P;\n\u1d1b > T;\n\u1d1c > U;\n\u1d20 > V;\n\u1d21 > W;\n\u1d22 > Z;\n\u1d6b > ue;\n\u1d6c > b;\n\u1d6d > d;\n\u1d6e > f;\n\u1d6f > m;\n\u1d70 > n;\n\u1d71 > p;\n\u1d72 > r;\n\u1d73 > r;\n\u1d74 > s;\n\u1d75 > t;\n\u1d76 > z;\n\u1d7a > th;\n\u1d7b > I;\n\u1d7d > p;\n\u1d7e > U;\n\u1d80 > b;\n\u1d81 > d;\n\u1d82 > f;\n\u1d83 > g;\n\u1d84 > k;\n\u1d85 > l;\n\u1d86 > m;\n\u1d87 > n;\n\u1d88 > p;\n\u1d89 > r;\n\u1d8a > s;\n\u1d8c > v;\n\u1d8d > x;\n\u1d8e > z;\n\u1d8f > a;\n\u1d91 > d;\n\u1d92 > e;\n\u1d93 > e;\n\u1d96 > i;\n\u1d99 > u;\n\u1e9a > a;\n\u1e9c > s;\n\u1e9d > s;\n\u1e9e > SS;\n\u1efa > LL;\n\u1efb > ll;\n\u1efc > V;\n\u1efd > v;\n\u1efe > Y;\n\u1eff > y;\n\ufb00 > ff;\n\ufb01 > fi;\n\ufb02 > fl;\n\ufb03 > ffi;\n\ufb04 > ffl;\n\ufb05 > st;\n\ufb06 > st;\n\uff21 > A;\n\uff22 > B;\n\uff23 > C;\n\uff24 > D;\n\uff25 > E;\n\uff26 > F;\n\uff27 > G;\n\uff28 > H;\n\uff29 > I;\n\uff2a > J;\n\uff2b > K;\n\uff2c > L;\n\uff2d > M;\n\uff2e > N;\n\uff2f > O;\n\uff30 > P;\n\uff31 > Q;\n\uff32 > R;\n\uff33 > S;\n\uff34 > T;\n\uff35 > U;\n\uff36 > V;\n\uff37 > W;\n\uff38 > X;\n\uff39 > Y;\n\uff3a > Z;\n\uff41 > a;\n\uff42 > b;\n\uff43 > c;\n\uff44 > d;\n\uff45 > e;\n\uff46 > f;\n\uff47 > g;\n\uff48 > h;\n\uff49 > i;\n\uff4a > j;\n\uff4b > k;\n\uff4c > l;\n\uff4d > m;\n\uff4e > n;\n\uff4f > o;\n\uff50 > p;\n\uff51 > q;\n\uff52 > r;\n\uff53 > s;\n\uff54 > t;\n\uff55 > u;\n\uff56 > v;\n\uff57 > w;\n\uff58 > x;\n\uff59 > y;\n\uff5a > z;\n\u00a9 > '(C)';\n\u00ae > '(R)';\n\u20a0 > CE;\n\u20a2 > Cr;\n\u20a3 > Fr'.';\n\u20a4 > L'.';\n\u20a7 > Pts;\n\u20b9 > Rs;\n\u2100 > a'_c';\n\u2101 > a'_s';\n\u2102 > C;\n\u2105 > c'_o';\n\u2106 > c'_u';\n\u210a > g;\n\u210b > H;\n\u210c > x;\n\u210d > H;\n\u210e > h;\n\u2110 > I;\n\u2111 > I;\n\u2112 > L;\n\u2113 > l;\n\u2115 > N;\n\u2116 > No;\n\u2119 > P;\n\u211a > Q;\n\u211b > R;\n\u211c > R;\n\u211d > R;\n\u211e > Rx;\n\u2121 > TEL;\n\u2124 > Z;\n\u2128 > Z;\n\u212c > B;\n\u212d > C;\n\u212f > e;\n\u2130 > E;\n\u2131 > F;\n\u2133 > M;\n\u2134 > o;\n\u2139 > i;\n\u213b > FAX;\n\u2145 > D;\n\u2146 > d;\n\u2147 > e;\n\u2148 > i;\n\u2149 > j;\n\u3371 > hPa;\n\u3372 > da;\n\u3373 > AU;\n\u3374 > bar;\n\u3375 > oV;\n\u3376 > pc;\n\u3377 > dm;\n\u337a > IU;\n\u3380 > pA;\n\u3381 > nA;\n\u3383 > mA;\n\u3384 > kA;\n\u3385 > KB;\n\u3386 > MB;\n\u3387 > GB;\n\u3388 > cal;\n\u3389 > kcal;\n\u338a > pF;\n\u338b > nF;\n\u338e > mg;\n\u338f > kg;\n\u3390 > Hz;\n\u3391 > kHz;\n\u3392 > MHz;\n\u3393 > GHz;\n\u3394 > THz;\n\u3399 > fm;\n\u339a > nm;\n\u339c > mm;\n\u339d > cm;\n\u339e > km;\n\u33a7 > m'_s';\n\u33a9 > Pa;\n\u33aa > kPa;\n\u33ab > MPa;\n\u33ac > GPa;\n\u33ad > rad;\n\u33ae > rad'_s';\n\u33b0 > ps;\n\u33b1 > ns;\n\u33b3 > ms;\n\u33b4 > pV;\n\u33b5 > nV;\n\u33b7 > mV;\n\u33b8 > kV;\n\u33b9 > MV;\n\u33ba > pW;\n\u33bb > nW;\n\u33bd > mW;\n\u33be > kW;\n\u33bf > MW;\n\u33c2 > a'.m.';\n\u33c3 > Bq;\n\u33c4 > cc;\n\u33c5 > cd;\n\u33c6 > C'_kg';\n\u33c7 > Co'.';\n\u33c8 > dB;\n\u33c9 > Gy;\n\u33ca > ha;\n\u33cb > HP;\n\u33cc > in;\n\u33cd > KK;\n\u33ce > KM;\n\u33cf > kt;\n\u33d0 > lm;\n\u33d1 > ln;\n\u33d2 > log;\n\u33d3 > lx;\n\u33d4 > mb;\n\u33d5 > mil;\n\u33d6 > mol;\n\u33d7 > pH;\n\u33d8 > p'.m.';\n\u33d9 > PPM;\n\u33da > PR;\n\u33db > sr;\n\u33dc > Sv;\n\u33dd > Wb;\n\u33de > V'_m';\n\u33df > A'_m';\n\u249c > '(a)';\n\u249d > '(b)';\n\u249e > '(c)';\n\u249f > '(d)';\n\u24a0 > '(e)';\n\u24a1 > '(f)';\n\u24a2 > '(g)';\n\u24a3 > '(h)';\n\u24a4 > '(i)';\n\u24a5 > '(j)';\n\u24a6 > '(k)';\n\u24a7 > '(l)';\n\u24a8 > '(m)';\n\u24a9 > '(n)';\n\u24aa > '(o)';\n\u24ab > '(p)';\n\u24ac > '(q)';\n\u24ad > '(r)';\n\u24ae > '(s)';\n\u24af > '(t)';\n\u24b0 > '(u)';\n\u24b1 > '(v)';\n\u24b2 > '(w)';\n\u24b3 > '(x)';\n\u24b4 > '(y)';\n\u24b5 > '(z)';\n\u2160 > I;\n\u2161 > II;\n\u2162 > III;\n\u2163 > IV;\n\u2164 > V;\n\u2165 > VI;\n\u2166 > VII;\n\u2167 > VIII;\n\u2168 > IX;\n\u2169 > X;\n\u216a > XI;\n\u216b > XII;\n\u216c > L;\n\u216d > C;\n\u216e > D;\n\u216f > M;\n\u2170 > i;\n\u2171 > ii;\n\u2172 > iii;\n\u2173 > iv;\n\u2174 > v;\n\u2175 > vi;\n\u2176 > vii;\n\u2177 > viii;\n\u2178 > ix;\n\u2179 > x;\n\u217a > xi;\n\u217b > xii;\n\u217c > l;\n\u217d > c;\n\u217e > d;\n\u217f > m;\n\u00bc > '_1_4';\n\u00bd > '_1_2';\n\u00be > '_3_4';\n\u2153 > '_1_3';\n\u2154 > '_2_3';\n\u2155 > '_1_5';\n\u2156 > '_2_5';\n\u2157 > '_3_5';\n\u2158 > '_4_5';\n\u2159 > '_1_6';\n\u215a > '_5_6';\n\u215b > '_1_8';\n\u215c > '_3_8';\n\u215d > '_5_8';\n\u215e > '_7_8';\n\u215f > '_1_';\n\u2474 > '(1)';\n\u2475 > '(2)';\n\u2476 > '(3)';\n\u2477 > '(4)';\n\u2478 > '(5)';\n\u2479 > '(6)';\n\u247a > '(7)';\n\u247b > '(8)';\n\u247c > '(9)';\n\u247d > '(10)';\n\u247e > '(11)';\n\u247f > '(12)';\n\u2480 > '(13)';\n\u2481 > '(14)';\n\u2482 > '(15)';\n\u2483 > '(16)';\n\u2484 > '(17)';\n\u2485 > '(18)';\n\u2486 > '(19)';\n\u2487 > '(20)';\n\u2488 > 1'.';\n\u2489 > 2'.';\n\u248a > 3'.';\n\u248b > 4'.';\n\u248c > 5'.';\n\u248d > 6'.';\n\u248e > 7'.';\n\u248f > 8'.';\n\u2490 > 9'.';\n\u2491 > 10'.';\n\u2492 > 11'.';\n\u2493 > 12'.';\n\u2494 > 13'.';\n\u2495 > 14'.';\n\u2496 > 15'.';\n\u2497 > 16'.';\n\u2498 > 17'.';\n\u2499 > 18'.';\n\u249a > 19'.';\n\u249b > 20'.';\n\u3007 > 0;\n\uff10 > 0;\n\uff11 > 1;\n\uff12 > 2;\n\uff13 > 3;\n\uff14 > 4;\n\uff15 > 5;\n\uff16 > 6;\n\uff17 > 7;\n\uff18 > 8;\n\uff19 > 9;\n\u00a0 > '_';\n\u2002 > '_';\n\u2003 > '_';\n\u2004 > '_';\n\u2005 > '_';\n\u2006 > '_';\n\u2007 > '_';\n\u2008 > '_';\n\u2009 > '_';\n\u200a > '_';\n\u205f > '_';\n\u3000 > '_';\n{ [^\\r\\n,0-9A-Za-z\\$\\(\\)!._-] } > \\_\n";
    private static Transliterator transliterator;

    protected static Transliterator getTransliterator() {
        if (transliterator == null) {
            transliterator = Transliterator.createFromRules((String)"TgFilenames", (String)TRANSFORM_RULES, (int)0);
        }
        return transliterator;
    }

    @Override
    public String translate(String title) {
        return DefaultFilenamePolicy.getTransliterator().transform(title);
    }

    @Override
    public String getFilename(ObjectType object, boolean asParent) {
        String title = this.translate((String)object.getGeneric().getProvided().getTitle().get(0));
        String uri = object.getGeneric().getGenerated().getTextgridUri().getValue().substring(9);
        String format = object.getGeneric().getProvided().getFormat();
        String extension = (String)FileExtensionMap.getInstance().getFirstExtension(format).or((Object)"dat");
        StringBuilder result = new StringBuilder(title);
        result.append('.').append(uri);
        if (!asParent) {
            result.append('.').append(extension);
        } else {
            result.append('/');
        }
        return result.toString();
    }

    @Override
    public URI getFilename(IAggregationEntry entry) {
        return this.getFilename(entry, false);
    }

    @Override
    public URI getFilename(IAggregationEntry entry, boolean asParent) {
        String localName = this.getFilename(entry.getMetadata(), asParent);
        Optional<URI> base = this.getBase(entry);
        URI result = base.isPresent() ? ((URI)base.get()).resolve(localName) : URI.create(localName);
        return result;
    }

    @Override
    public Optional<URI> getBase(IAggregationEntry entry) {
        if (entry.getParent().isPresent()) {
            return Optional.of((Object)this.getFilename((IAggregationEntry)entry.getParent().get(), true));
        }
        return Optional.absent();
    }
}

