/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.navigator.CopyReportDialog;
import info.textgrid.lab.navigator.Messages;
import info.textgrid.lab.navigator.NaviView;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishObject;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishResponse;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishStatus;
import info.textgrid.middleware.tgpublish.client.PublishClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class CopyService {
    private static CopyService instance;
    private static PublishClient publishClient;
    private Job copyJob = null;
    private AuthBrowser.ISIDChangedListener sidChangedListener;
    private boolean showCopyReport = true;
    private boolean userAbort = false;
    private List<PublishObject> publishObjects;
    private HashMap<String, HashMap<String, Integer>> allCopyURIs;
    private int count;

    private CopyService() {
        String SID = RBACSession.getInstance().getSID(false);
        try {
            publishClient = new PublishClient(ConfClient.getInstance().getValue("tgpublish"), SID);
            this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

                public void sidChanged(String newSID, String newEPPN) {
                    instance = null;
                }
            };
            AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        }
        catch (OfflineException e) {
            Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{"CopyService"});
        }
    }

    public static synchronized CopyService getInstance() {
        if (instance == null) {
            instance = new CopyService();
        }
        return instance;
    }

    public void copy(final List<String> objects, final String projectID) {
        this.userAbort = false;
        GetURIsJob getURIsJob = new GetURIsJob(Messages.CopyService_IM_FindNumberOfObjects, objects);
        getURIsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    UIJob copydialog = new UIJob("Copy Service"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            String message = CopyService.this.count == 1 ? NLS.bind((String)Messages.CopyService_QE_DoYouReallyWantToCopy, objects.get(0)) : NLS.bind((String)Messages.CopyService_QU_DoYouReallyWantToCopyNumber, (Object)CopyService.this.count);
                            if (objects.size() < 1) {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CopyService_UI_NothingToCopy, (String)Messages.CopyService_UI_NoSelection);
                                return Status.CANCEL_STATUS;
                            }
                            MessageDialogWithToggle dialog = new MessageDialogWithToggle(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.CopyService_UI_CopyObjects, null, message, 3, new String[]{Messages.CopyService_Cancel, "OK"}, 1, Messages.CopyService_ShowReport, CopyService.this.showCopyReport);
                            int doCopy = dialog.open();
                            CopyService.this.showCopyReport = dialog.getToggleState();
                            if (doCopy != 0) {
                                return Status.CANCEL_STATUS;
                            }
                            CopyService.this.copyJob = new CopyJob(Messages.CopyService_UI_Copying, objects, projectID);
                            CopyService.this.copyJob.setUser(true);
                            CopyService.this.copyJob.schedule();
                            return Status.OK_STATUS;
                        }
                    };
                    copydialog.setUser(true);
                    copydialog.schedule();
                }
            }
        });
        getURIsJob.setUser(true);
        getURIsJob.schedule();
    }

    private void gatherObjectURIs(List<String> objects) {
        this.allCopyURIs = new HashMap();
        SearchRequest searchRequestPublic = null;
        SearchRequest searchRequestNonPublic = null;
        for (String object : objects) {
            try {
                HashMap<Object, Object> titleCount;
                TextGridObject tgo = TextGridObject.getInstance((URI)new URI(object), (boolean)true);
                String title = tgo.getTitle();
                if (this.allCopyURIs.containsKey(object)) {
                    titleCount = this.allCopyURIs.get(object);
                    int count = (Integer)titleCount.get(title);
                    titleCount.put(title, ++count);
                } else {
                    titleCount = new HashMap<String, Integer>();
                    titleCount.put(title, 1);
                    this.allCopyURIs.put(object, titleCount);
                }
                if (!tgo.getContentTypeID().contains("aggregation")) continue;
                if (tgo.isPublic()) {
                    if (searchRequestPublic == null) {
                        searchRequestPublic = new SearchRequest(SearchRequest.EndPoint.PUBLIC);
                    }
                    this.allCopyURIs = searchRequestPublic.gatherAggregationURIs(tgo.getURI().toString(), this.allCopyURIs);
                    continue;
                }
                if (searchRequestNonPublic == null) {
                    searchRequestNonPublic = new SearchRequest();
                }
                this.allCopyURIs = searchRequestNonPublic.gatherAggregationURIs(tgo.getURI().toString(), this.allCopyURIs);
            }
            catch (CrudServiceException e) {
                Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{object});
            }
            catch (URISyntaxException e) {
                Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{object});
            }
            catch (CoreException e) {
                Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{object});
            }
        }
    }

    private int getObjectCounter() {
        int counter = 0;
        for (Map.Entry<String, HashMap<String, Integer>> e : this.allCopyURIs.entrySet()) {
            HashMap<String, Integer> titleCount = e.getValue();
            for (Map.Entry<String, Integer> t : titleCount.entrySet()) {
                counter += t.getValue().intValue();
            }
        }
        return counter;
    }

    private final class CopyJob
    extends Job {
        private final List<String> objects;
        private final String projectID;

        private CopyJob(String name, List<String> objects, String projectID) {
            super(name);
            this.objects = objects;
            this.projectID = projectID;
        }

        public IStatus run(IProgressMonitor monitor) {
            block9: {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CopyService_IM_CopyObjects, (Object)CopyService.this.count), (int)100);
                Response response = publishClient.copy(this.objects, this.projectID);
                InputStream is = (InputStream)response.getEntity();
                try {
                    PublishResponse publishResponse;
                    String UUID = this.convertStreamToString(is);
                    int lastProgress = 0;
                    do {
                        publishResponse = publishClient.getStatus(UUID);
                        PublishStatus publishStatus = publishResponse.getPublishStatus();
                        int currentProgress = publishStatus.progress;
                        if (currentProgress == 100) {
                            CopyService.this.publishObjects = publishResponse.getPublishObjects();
                            break block9;
                        }
                        if (currentProgress != lastProgress) {
                            progress.worked(currentProgress - lastProgress);
                            lastProgress = currentProgress;
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{"CopyService"});
                        }
                    } while (!progress.isCanceled());
                    publishClient.abort(UUID);
                    CopyService.this.publishObjects = publishResponse.getPublishObjects();
                    CopyService.this.userAbort = true;
                }
                catch (IOException e) {
                    Activator.handleError((Throwable)e, (String)e.getMessage(), (Object[])new Object[]{"CopyService"});
                    return Status.CANCEL_STATUS;
                }
            }
            UIJob refreshNavi = new UIJob(Messages.CopyTGObjectByWorkflow_RefreshNavigator){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    NaviView navi = (NaviView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.navigator.view");
                    NaviView.refreshNavigator();
                    return new Status(0, "info.textgrid.lab.ui.core", Messages.CopyTGObjectByWorkflow_RefreshNavigator);
                }
            };
            refreshNavi.schedule();
            if (CopyService.this.showCopyReport || CopyService.this.userAbort) {
                UIJob copyReport = new UIJob("Copy Report Dialog"){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        CopyReportDialog reportDialog = new CopyReportDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        reportDialog.setPublishObjects(CopyService.this.publishObjects, CopyService.this.allCopyURIs, CopyService.this.userAbort);
                        reportDialog.open();
                        return Status.OK_STATUS;
                    }
                };
                copyReport.schedule();
            }
            if (CopyService.this.userAbort) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public String convertStreamToString(InputStream is) throws IOException {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            return sb.toString();
        }
    }

    private final class GetURIsJob
    extends Job {
        private List<String> objects;

        public GetURIsJob(String name, List<String> objects) {
            super(name);
            this.objects = objects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.setTaskName(Messages.CopyService_IM_CanTageAMoment);
            CopyService.this.gatherObjectURIs(this.objects);
            CopyService.this.count = CopyService.this.getObjectCounter();
            return Status.OK_STATUS;
        }
    }
}

