/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.linkrewriter;

import info.textgrid.utils.linkrewriter.AbstractReplacement;
import info.textgrid.utils.linkrewriter.AbstractRewriter;
import info.textgrid.utils.linkrewriter.ILinkRewriter;
import info.textgrid.utils.linkrewriter.ImportMapping;
import info.textgrid.utils.linkrewriter.TokenReplacement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLLinkRewriter
extends AbstractRewriter
implements ILinkRewriter {
    private final List<TokenReplacement> replacements;

    protected XMLLinkRewriter(ImportMapping mapping, boolean export) {
        super(mapping, export);
        this.replacements = AbstractReplacement.create(TokenReplacement.class, mapping, export);
    }

    @Override
    public void rewrite(InputStream input, OutputStream output) throws IOException, XMLStreamException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLEventReader reader = inputFactory.createXMLEventReader(input);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(output);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    StartElement newStartElement = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), null, null, startElement.getNamespaceContext());
                    writer.add(newStartElement);
                    Iterator<Attribute> attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        String value = attribute.getValue();
                        String result = AbstractReplacement.apply(this.replacements, value);
                        writer.add(eventFactory.createAttribute(attribute.getName(), result));
                    }
                    continue;
                }
                if (event.isCharacters()) {
                    Characters characters = event.asCharacters();
                    String data = characters.getData();
                    String result = AbstractReplacement.apply(this.replacements, data);
                    writer.add(eventFactory.createCharacters(result));
                    continue;
                }
                writer.add(event);
            }
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }
}

