/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import net.sf.vex.VexToolkitPlugin;

public class ListenerList {
    private Class<?> listenerClass;
    private Class<?>[] methodParams;
    private Collection<Object> listeners = new ArrayList<Object>();
    private Map<String, Method> methods = new HashMap<String, Method>();

    public ListenerList(Class<?> listenerClass, Class<?> eventClass) {
        this.listenerClass = listenerClass;
        this.methodParams = new Class[]{eventClass};
    }

    public void add(Object listener) {
        if (!this.listenerClass.isInstance(listener)) {
            this.handleException(new IllegalArgumentException(listener + " is not an instance of " + this.listenerClass), "Tried to add an invalid object to ListenerList", new Object[0]);
        }
        this.listeners.add(listener);
    }

    public void fireEvent(String methodName, EventObject event) {
        Method method = this.methods.get(methodName);
        if (method == null) {
            try {
                method = this.listenerClass.getMethod(methodName, this.methodParams);
                this.methods.put(methodName, method);
            }
            catch (Exception e) {
                this.handleException(e, "Could not extract method {0}({1}) from {2}", methodName, this.methodParams, this.listenerClass);
                return;
            }
        }
        Object[] args = new Object[]{event};
        for (Object listener : this.listeners) {
            try {
                method.invoke(listener, args);
            }
            catch (Exception ex) {
                this.handleException(ex, "An {0}\u00a0occured while calling {1} with listener {2}", ex.getClass().getSimpleName(), method, listener);
            }
        }
    }

    public void handleException(Exception ex, String message, Object ... args) {
        VexToolkitPlugin.log(4, ex, message, args);
    }

    public void remove(Object listener) {
        this.listeners.remove(listener);
    }
}

