/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.vex.dom.DFAState;

public class DFABuilder {
    public static Node createChoiceNode(Node child1, Node child2) {
        return new OrNode(child1, child2);
    }

    public static DFAState createDFA(Node root) {
        SymbolNode sentinelNode = new SymbolNode(Sentinel.getInstance());
        CatNode fakeRoot = new CatNode(root, sentinelNode);
        HashMap<Set, DFAState> stateMap = new HashMap<Set, DFAState>();
        HashSet<Set> marked = new HashSet<Set>();
        Stack<Set> unmarked = new Stack<Set>();
        FollowPosBuilder fpb = new FollowPosBuilder();
        fakeRoot.accept(fpb);
        Map followPos = fpb.getFollowPos();
        Map symbolMap = fpb.getSymbolMap();
        Set nodeSet = fakeRoot.getFirstPos();
        DFAState startState = new DFAState();
        if (nodeSet.contains(sentinelNode)) {
            startState.setAccepting(true);
        }
        stateMap.put(nodeSet, startState);
        unmarked.push(nodeSet);
        while (unmarked.size() > 0) {
            nodeSet = (Set)unmarked.pop();
            marked.add(nodeSet);
            DFAState state = (DFAState)stateMap.get(nodeSet);
            if (state == null) {
                state = new DFAState();
                stateMap.put(nodeSet, state);
            }
            for (Object symbol : symbolMap.keySet()) {
                DFAState targetState;
                HashSet targetSet = new HashSet();
                for (SymbolNode node : nodeSet) {
                    if (!node.getSymbol().equals(symbol)) continue;
                    targetSet.addAll((Set)followPos.get(node));
                }
                if (targetSet.isEmpty()) continue;
                if (!unmarked.contains(targetSet) && !marked.contains(targetSet)) {
                    unmarked.push(targetSet);
                }
                if ((targetState = (DFAState)stateMap.get(targetSet)) == null) {
                    targetState = new DFAState();
                    if (targetSet.contains(sentinelNode)) {
                        targetState.setAccepting(true);
                    }
                    stateMap.put(targetSet, targetState);
                }
                state.addTransition(symbol, targetState);
            }
        }
        return startState;
    }

    public static Node createOptionalNode(Node child) {
        return new OrNode(child, new NullNode());
    }

    public static Node createRepeatingNode(Node child, int minRepeat) {
        AbstractNode node = new StarNode(child);
        int i = 0;
        while (i < minRepeat) {
            node = new CatNode(node, (Node)child.clone());
            ++i;
        }
        return node;
    }

    public static Node createSequenceNode(Node child1, Node child2) {
        return new CatNode(child1, child2);
    }

    public static Node createSymbolNode(Object symbol) {
        return new SymbolNode(symbol);
    }

    private static abstract class AbstractNode
    implements Node {
        protected Set firstPos;
        protected Set lastPos;
        protected boolean nullable;

        private AbstractNode() {
        }

        @Override
        public abstract Object clone();

        @Override
        public Set getFirstPos() {
            return this.firstPos;
        }

        @Override
        public Set getLastPos() {
            return this.lastPos;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        protected Set union(Set set1, Set set2) {
            HashSet retval = new HashSet();
            retval.addAll(set1);
            retval.addAll(set2);
            return retval;
        }
    }

    private static class CatNode
    extends AbstractNode {
        private Node leftChild;
        private Node rightChild;

        public CatNode(Node leftChild, Node rightChild) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.firstPos = leftChild.isNullable() ? this.union(leftChild.getFirstPos(), rightChild.getFirstPos()) : leftChild.getFirstPos();
            this.lastPos = rightChild.isNullable() ? this.union(leftChild.getLastPos(), rightChild.getLastPos()) : rightChild.getLastPos();
            this.nullable = leftChild.isNullable() && rightChild.isNullable();
        }

        @Override
        public void accept(NodeVisitor visitor) {
            this.leftChild.accept(visitor);
            this.rightChild.accept(visitor);
            visitor.visitCatNode(this);
        }

        @Override
        public Object clone() {
            return new CatNode((Node)this.leftChild.clone(), (Node)this.rightChild.clone());
        }

        public Node getLeftChild() {
            return this.leftChild;
        }

        public Node getRightChild() {
            return this.rightChild;
        }
    }

    private static class FollowPosBuilder
    implements NodeVisitor {
        private Map followPos = new HashMap();
        private Map symbolMap = new HashMap();

        private FollowPosBuilder() {
        }

        public Map getFollowPos() {
            return this.followPos;
        }

        public Map getSymbolMap() {
            return this.symbolMap;
        }

        @Override
        public void visitCatNode(CatNode node) {
            for (SymbolNode symbolNode : node.getLeftChild().getLastPos()) {
                Set set = this.getFollowPos(symbolNode);
                set.addAll(node.getRightChild().getFirstPos());
            }
        }

        @Override
        public void visitNullNode(NullNode node) {
        }

        @Override
        public void visitOrNode(OrNode node) {
        }

        @Override
        public void visitStarNode(StarNode node) {
            for (SymbolNode symbolNode : node.getChild().getLastPos()) {
                Set set = this.getFollowPos(symbolNode);
                set.addAll(node.getChild().getFirstPos());
            }
        }

        @Override
        public void visitSymbolNode(SymbolNode node) {
            this.getFollowPos(node);
            Object symbol = node.getSymbol();
            HashSet<SymbolNode> symbolNodeSet = (HashSet<SymbolNode>)this.symbolMap.get(symbol);
            if (symbolNodeSet == null) {
                symbolNodeSet = new HashSet<SymbolNode>();
                this.symbolMap.put(symbol, symbolNodeSet);
            }
            symbolNodeSet.add(node);
        }

        private Set getFollowPos(SymbolNode node) {
            HashSet ret = (HashSet)this.followPos.get(node);
            if (ret == null) {
                ret = new HashSet();
                this.followPos.put(node, ret);
            }
            return ret;
        }
    }

    public static interface Node {
        public void accept(NodeVisitor var1);

        public Object clone();

        public Set getFirstPos();

        public Set getLastPos();

        public boolean isNullable();
    }

    private static interface NodeVisitor {
        public void visitCatNode(CatNode var1);

        public void visitNullNode(NullNode var1);

        public void visitOrNode(OrNode var1);

        public void visitStarNode(StarNode var1);

        public void visitSymbolNode(SymbolNode var1);
    }

    private static class NullNode
    extends AbstractNode {
        public NullNode() {
            this.firstPos = Collections.EMPTY_SET;
            this.lastPos = Collections.EMPTY_SET;
            this.nullable = true;
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visitNullNode(this);
        }

        @Override
        public Object clone() {
            return new NullNode();
        }
    }

    private static class OrNode
    extends AbstractNode {
        private Node leftChild;
        private Node rightChild;

        public OrNode(Node leftChild, Node rightChild) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.firstPos = this.union(leftChild.getFirstPos(), rightChild.getFirstPos());
            this.lastPos = this.union(leftChild.getLastPos(), rightChild.getLastPos());
            this.nullable = leftChild.isNullable() || rightChild.isNullable();
        }

        @Override
        public void accept(NodeVisitor visitor) {
            this.leftChild.accept(visitor);
            this.rightChild.accept(visitor);
            visitor.visitOrNode(this);
        }

        @Override
        public Object clone() {
            return new OrNode((Node)this.leftChild.clone(), (Node)this.rightChild.clone());
        }

        public Node getLeftChild() {
            return this.leftChild;
        }

        public Node getRightChild() {
            return this.rightChild;
        }
    }

    private static class Sentinel {
        private static final Sentinel instance = new Sentinel();

        private Sentinel() {
        }

        public static Sentinel getInstance() {
            return instance;
        }

        public String toString() {
            return "#";
        }
    }

    private static class StarNode
    extends AbstractNode {
        private Node child;

        public StarNode(Node child) {
            this.child = child;
            this.firstPos = child.getFirstPos();
            this.lastPos = child.getLastPos();
            this.nullable = true;
        }

        @Override
        public void accept(NodeVisitor visitor) {
            this.child.accept(visitor);
            visitor.visitStarNode(this);
        }

        @Override
        public Object clone() {
            return new StarNode((Node)this.child.clone());
        }

        public Node getChild() {
            return this.child;
        }
    }

    private static class SymbolNode
    extends AbstractNode {
        private static int pos = 1;
        private int myPos;
        private Object symbol;

        public SymbolNode(Object symbol) {
            this.symbol = symbol;
            this.firstPos = Collections.singleton(this);
            this.lastPos = Collections.singleton(this);
            this.nullable = false;
            this.myPos = pos++;
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visitSymbolNode(this);
        }

        @Override
        public Object clone() {
            return new SymbolNode(this.symbol);
        }

        public int getMyPos() {
            return this.myPos;
        }

        public Object getSymbol() {
            return this.symbol;
        }
    }
}

