/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.impl;

import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.Position;

public class SwingGapContentWrapper
implements Content {
    private GapContent swingGapContent;

    public SwingGapContentWrapper(int initialCapacity) {
        this.swingGapContent = new GapContent(initialCapacity);
    }

    @Override
    public Position createPosition(int offset) {
        try {
            return new SwingPositionWrapper(this.swingGapContent.createPosition(offset));
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException("Bad offset " + e.offsetRequested() + "must be between " + 0 + " and " + this.swingGapContent.length());
        }
    }

    @Override
    public int getLength() {
        return this.swingGapContent.length();
    }

    @Override
    public String getString(int offset, int length) {
        try {
            return this.swingGapContent.getString(offset, length);
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException("Bad offset " + e.offsetRequested() + "must be between " + 0 + " and " + this.swingGapContent.length());
        }
    }

    @Override
    public void insertString(int offset, String s) {
        try {
            this.swingGapContent.insertString(offset, s);
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException("Bad offset " + e.offsetRequested() + "must be between " + 0 + " and " + this.swingGapContent.length());
        }
    }

    @Override
    public void remove(int offset, int length) {
        try {
            this.swingGapContent.remove(offset, length);
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException("Bad offset " + e.offsetRequested() + "must be between " + 0 + " and " + this.swingGapContent.length());
        }
    }

    public String toString() {
        int length = this.getLength();
        return "SwingGapContentWrapper(" + this.getString(0, length).replace("\u0000", "\\0").replace("\n", "\\n") + ")";
    }

    private class SwingPositionWrapper
    implements Position {
        private javax.swing.text.Position swingPosition;

        public SwingPositionWrapper(javax.swing.text.Position pos) {
            this.swingPosition = pos;
        }

        @Override
        public int getOffset() {
            return this.swingPosition.getOffset();
        }

        public String toString() {
            return this.swingPosition.toString();
        }
    }
}

