/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import com.google.common.base.Joiner;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.util.collection.Filter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.dom.linked.LinkedCDATASection;
import net.sf.vex.dom.linked.LinkedComment;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedModelException;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.dom.linked.LinkedRootElement;
import net.sf.vex.dom.linked.LinkedText;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LinkedElement
extends LinkedNode
implements IVexElement {
    private List<IVexNode> children = Collections.synchronizedList(new ArrayList());
    private Filter<IVexElement> childElements = new Filter(this.children, IVexElement.class);

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result) {
            if (obj instanceof LinkedElement) {
                LinkedElement other = (LinkedElement)obj;
                return this.getName().equals(other.getName()) && this.getDomNode().equals(other.getDomNode());
            }
            return false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getName().hashCode();
    }

    @Override
    public IVexElement clone() {
        return new LinkedElement(this.getDomNode().cloneNode(false));
    }

    @Override
    public Element getDomNode() {
        return (Element)super.getDomNode();
    }

    public LinkedElement(Node domNode) {
        super(domNode);
    }

    public LinkedElement(IVexNode parent, Element element) throws LinkedModelException {
        this(element);
        if (!(parent instanceof IVexElement)) {
            throw new LinkedModelException("Could not create a Vex element from {0}: The provided parent, {1}, is not an IVexElement", null, element, parent);
        }
        this.setParent((IVexElement)parent);
    }

    public void addChild(IVexNode child) {
        WrongModelException.throwIfNeeded(child, LinkedNode.class);
        this.children.add(child);
        ((LinkedNode)child).setParent(this);
    }

    @Override
    public String getAttribute(String name) {
        Attr attributeNode = this.getDomNode().getAttributeNode(name);
        return attributeNode == null ? null : attributeNode.getValue();
    }

    @Override
    public String[] getAttributeNames() {
        NamedNodeMap attributes = this.getDomNode().getAttributes();
        String[] names = new String[attributes.getLength()];
        int i = 0;
        while (i < names.length) {
            names[i] = attributes.item(i).getNodeName();
            ++i;
        }
        return names;
    }

    @Override
    public IVexElement[] getChildElements() {
        LinkedList<IVexElement> elements = new LinkedList<IVexElement>();
        for (IVexNode child : this.children) {
            if (!(child instanceof IVexElement)) continue;
            elements.add((IVexElement)child);
        }
        return elements.toArray(new IVexElement[0]);
    }

    @Override
    public Iterator<IVexElement> getChildIterator() {
        return this.childElements.iterator();
    }

    @Override
    public Iterator<IVexNode> getChildNodeIterator() {
        return this.children.iterator();
    }

    @Override
    public IVexNode[] getChildNodes() {
        return this.children.toArray(new IVexNode[0]);
    }

    @Override
    public LinkedDocument getDocument() {
        IVexElement root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root instanceof LinkedRootElement) {
            return ((LinkedRootElement)root).getDocument();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getDomNode().getTagName();
    }

    @Override
    public LinkedElement getParent() {
        return (LinkedElement)super.getParent();
    }

    @Override
    public boolean isEmpty() {
        return this.getDomNode().getChildNodes().getLength() == 0;
    }

    @Override
    public void removeAttribute(String name) throws DocumentValidationException {
        this.getDomNode().getAttributes().removeNamedItem(name);
    }

    @Override
    public void setAttribute(String name, String value) throws DocumentValidationException {
        this.getDomNode().setAttribute(name, value);
    }

    @Override
    public void internalInsertChild(int index, IVexElement newElement) {
        if (index < this.children.size()) {
            this.getDomNode().insertBefore(((LinkedElement)newElement).getDomNode(), ((LinkedNode)this.children.get(index)).getDomNode());
        } else {
            this.getDomNode().appendChild(((LinkedNode)((Object)newElement)).getDomNode());
        }
        this.children.add(index, newElement);
        newElement.setParent(this);
    }

    @Override
    public void addChild(IVexElement child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean hasValidContent() {
        boolean valid = true;
        if (!"\u0000".equals(this.getContent().getString(this.getStartOffset(), 1))) {
            valid = false;
            System.err.println("Element's Content must start with \\0! " + this);
        }
        for (IVexNode child : this.children) {
            valid &= ((LinkedNode)child).hasValidContent();
        }
        if (this.getEndOffset() < this.getContent().getLength() && !"\u0000".equals(this.getContent().getString(this.getEndOffset(), 1))) {
            valid = false;
            System.err.println("Element's Content must end with \\0! " + this);
        }
        return valid;
    }

    @Override
    public boolean isPre() {
        IWhitespacePolicy policy = this.getDocument().getWhitespacePolicy();
        if (policy != null) {
            return policy.isPre(this);
        }
        return false;
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/nodeadapter")) {
            System.out.println("Processing: " + this.formatNotification(notifier, eventType, changedFeature, oldValue, newValue, pos));
        }
        switch (eventType) {
            case 3: {
                this.removeDomChild((Node)changedFeature);
                break;
            }
            case 2: {
                if (!(newValue instanceof Node)) break;
                this.addDomChild((Node)newValue);
                break;
            }
            case 5: {
                this.getDomNode().normalize();
                break;
            }
            default: {
                super.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
            }
        }
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/validate-model")) {
            LinkedList<LinkedDocument.ModelError> errors = new LinkedList<LinkedDocument.ModelError>();
            if (!LinkedDocument.isSubtreeConsistent(this.getParent(), errors, false)) {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", "Part of the linked document is broken: \n" + Joiner.on((String)"\n").join(errors) + ".\n   Detected after processing this model change: " + this.formatNotification(notifier, eventType, changedFeature, oldValue, newValue, pos)));
            }
        }
    }

    protected void removeDomChild(Node node) {
        Iterator<IVexNode> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LinkedNode candidate = (LinkedNode)iterator.next();
            if (candidate.getDomNode() != node) continue;
            iterator.remove();
            int startOffset = candidate.getStartOffset();
            int contentLength = candidate.getEndOffset() - startOffset;
            if (candidate instanceof LinkedElement) {
                ++contentLength;
            }
            if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/nodeadapter")) {
                System.err.println(MessageFormat.format("Removing ''{0}'' from {1}''s content", this.getContent().getString(startOffset, contentLength).replace("\u0000", "\\0"), this));
            }
            if (contentLength > 0) {
                candidate.getContent().remove(startOffset, contentLength);
            }
            if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/nodeadapter")) {
                System.err.println("  ... which resulted in " + this);
            }
            if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
                System.out.println(MessageFormat.format("deleted child {1} from {0}", this, node));
            }
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot remove {0}: No corresponding child found in {1}", node, this));
    }

    protected LinkedNode addDomChild(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.addDomChildElement((Element)node);
            }
            case 4: {
                return this.addDomChildCDATASection((CDATASection)node);
            }
            case 3: {
                return this.addDomChildText((Text)node);
            }
            case 8: {
                return this.addDomChildComment((Comment)node);
            }
        }
        return this.addDomChildGeneric(node);
    }

    private LinkedNode addDomChildGeneric(Node node) {
        VexToolkitPlugin.log(2, new IllegalArgumentException("addDomChild called with unknown node type."), "I don't know what corresponding LinkedNode to create for the {0} {1} has been added in the source code editor.", node.getClass().getSimpleName(), node);
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
            System.err.println(MessageFormat.format("don't know how to add {1} to {0}", this, node));
        }
        return null;
    }

    private LinkedNode addDomChildComment(Comment node) {
        int position = this.findInsertPositionFor(node);
        LinkedComment linkedComment = new LinkedComment(node);
        int startOffset = position == 0 ? this.getStartOffset() : this.children.get(position - 1).getEndOffset();
        String string = linkedComment.getDomNode().getData();
        this.getContent().insertString(startOffset + 1, "\u0000\u0000");
        this.getContent().insertString(startOffset + 2, string);
        linkedComment.setContent(this.getContent(), startOffset + 1, startOffset + 2 + string.length());
        this.children.add(position, linkedComment);
        linkedComment.setParent(this);
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
            System.out.println(MessageFormat.format("added comment {1} to {0}", this, linkedComment));
        }
        return linkedComment;
    }

    private LinkedNode addDomChildCDATASection(CDATASection node) {
        int position = this.findInsertPositionFor(node);
        LinkedCDATASection linkedCS = new LinkedCDATASection(node);
        int startOffset = position == 0 ? this.getStartOffset() : this.children.get(position - 1).getEndOffset();
        String string = linkedCS.getDomNode().getData();
        this.getContent().insertString(startOffset + 1, "\u0000\u0000");
        this.getContent().insertString(startOffset + 2, string);
        linkedCS.setContent(this.getContent(), startOffset + 1, startOffset + 2 + string.length());
        this.children.add(position, linkedCS);
        linkedCS.setParent(this);
        return linkedCS;
    }

    private LinkedNode addDomChildText(Text node) {
        int position = this.findInsertPositionFor(node);
        LinkedText linkedText = new LinkedText(this, node, this.getContent());
        int startOffset = this.findStartOffsetForPosition(position);
        String normalizedString = linkedText.getWSNormalizedString();
        this.getContent().insertString(startOffset, normalizedString);
        linkedText.setContent(this.getContent(), startOffset, startOffset + normalizedString.length());
        this.children.add(position, linkedText);
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
            System.out.println(MessageFormat.format("added text {1} to {0}", this, linkedText));
        }
        return linkedText;
    }

    private int findStartOffsetForPosition(int position) {
        int offset;
        if (position == 0) {
            offset = this.getStartOffset() + 1;
        } else {
            IVexNode previousSibling = this.children.get(position - 1);
            offset = previousSibling.getEndOffset() + 1;
            if (previousSibling instanceof IVexText) {
                --offset;
            }
        }
        return offset;
    }

    private LinkedNode addDomChildElement(Element node) {
        IVexNode previousSibling;
        int position = this.findInsertPositionFor(node);
        LinkedElement linkedElement = new LinkedElement(node);
        int startOffset = this.findStartOffsetForPosition(position);
        this.getContent().insertString(startOffset, "\u0000\u0000");
        if (startOffset == this.getEndOffset()) {
            this.setContent(this.getContent(), this.getStartOffset(), this.getEndOffset() + 2);
        }
        if (position > 0 && (previousSibling = this.children.get(position - 1)).getEndOffset() == startOffset + 2) {
            previousSibling.setContent(previousSibling.getContent(), previousSibling.getStartOffset(), startOffset);
        }
        linkedElement.setContent(this.getContent(), startOffset, startOffset + 1);
        this.children.add(position, linkedElement);
        linkedElement.setParent(this);
        NodeList grandChildren = node.getChildNodes();
        int i = 0;
        while (i < grandChildren.getLength()) {
            linkedElement.addDomChild(grandChildren.item(i));
            ++i;
        }
        this.getDocument().fireElementChanged(this);
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
            System.out.println(MessageFormat.format("added child {1} to {0}", this, linkedElement));
        }
        return linkedElement;
    }

    private int findInsertPositionFor(Node node) {
        int result = -2;
        if (this.children.size() < 1) {
            result = 0;
        } else {
            Node nextSibling;
            Node previousSibling;
            IndexedRegion nodeRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)node, IndexedRegion.class);
            final int nodeStartOffset = nodeRegion.getStartOffset();
            IVexNode[] childNodes = this.getChildNodes();
            LinkedNode lastNode = (LinkedNode)childNodes[childNodes.length - 1];
            int endOffset = ((IndexedRegion)lastNode.getDomNode()).getEndOffset();
            if (endOffset <= nodeStartOffset) {
                result = childNodes.length;
            }
            if (result < 0 && (previousSibling = node.getPreviousSibling()) != null) {
                result = this.findChildIndex(new Criterion<IVexNode>(){

                    @Override
                    public boolean matches(IVexNode candidate) {
                        return ((LinkedNode)candidate).getDomNode().equals(previousSibling);
                    }
                }) + 1;
            }
            if (result < 0 && (nextSibling = node.getNextSibling()) != null) {
                result = this.findChildIndex(new Criterion<IVexNode>(){

                    @Override
                    public boolean matches(IVexNode candidate) {
                        return ((LinkedNode)candidate).getDomNode().equals(nextSibling);
                    }
                });
            }
            if (result < 0) {
                result = this.findChildIndex(new Criterion<IVexNode>(){

                    @Override
                    public boolean matches(IVexNode child) {
                        IndexedRegion childRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)child, IndexedRegion.class);
                        int childStartOffset = childRegion.getStartOffset();
                        return nodeStartOffset >= childStartOffset;
                    }
                });
            }
        }
        return Math.max(result, 0);
    }

    public int findChildIndex(Criterion<IVexNode> c) {
        int pos = 0;
        Iterator<IVexNode> iter = this.children.iterator();
        while (iter.hasNext()) {
            if (c.matches(iter.next())) {
                return pos;
            }
            ++pos;
        }
        return -2;
    }

    @Override
    public void setParent(IVexElement parent) {
        super.setParent(parent);
    }

    public static interface Criterion<T> {
        public boolean matches(T var1);
    }
}

