/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.ColorResource;
import net.sf.vex.core.Drawable;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;

public class DrawableBox
extends AbstractBox
implements InlineBox {
    public static final byte NO_MARKER = 0;
    public static final byte START_MARKER = 1;
    public static final byte END_MARKER = 2;
    public static final byte BOTTOM_MARKER = 4;
    private Drawable drawable;
    private IVexElement element;
    private byte marker;

    public DrawableBox(Drawable drawable, IVexElement element) {
        this(drawable, element, 0);
    }

    public DrawableBox(Drawable drawable, IVexElement element, byte marker) {
        this.drawable = drawable;
        this.element = element;
        this.marker = marker;
        Rectangle bounds = drawable.getBounds();
        this.setWidth(bounds.getWidth());
        this.setHeight(bounds.getHeight());
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public boolean isEOL() {
        return false;
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, int maxWidth, boolean force) {
        return new InlineBox.Pair(null, this);
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(this.element);
        boolean drawSelected = false;
        if (this.marker == 1) {
            drawSelected = this.getElement().getStartOffset() >= context.getSelectionStart() && this.getElement().getStartOffset() + 1 <= context.getSelectionEnd();
        } else if (this.marker == 2) {
            drawSelected = this.getElement().getEndOffset() >= context.getSelectionStart() && this.getElement().getEndOffset() + 1 <= context.getSelectionEnd();
        }
        FontResource font = g.createFont(styles.getFont());
        ColorResource color = g.createColor(styles.getColor());
        FontResource oldFont = g.setFont(font);
        ColorResource oldColor = g.setColor(color);
        FontMetrics fm = g.getFontMetrics();
        if (drawSelected) {
            Rectangle bounds = this.drawable.getBounds();
            g.setColor(g.getSystemColor(0));
            g.fillRect(x + bounds.getX(), y, bounds.getWidth(), styles.getLineHeight() - fm.getDescent());
            g.setColor(g.getSystemColor(1));
        }
        this.drawable.draw(g, x, y);
        g.setFont(oldFont);
        g.setColor(oldColor);
        font.dispose();
        color.dispose();
    }

    public String toString() {
        return "[shape]";
    }
}

