/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class VexAnnotationSupport
extends PlatformObject {
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPropertyChangeListener;
    private IOverviewRuler fOverviewRuler;
    private Map<Object, AnnotationPreference> fAnnotationTypeKeyMap = Maps.newLinkedHashMap();
    private IPropertyChangeListener fFontPropertyChangeListener;
    private AnnotationPainter fAnnotationPainter;
    private ISharedTextColors fSharedTextColors;
    private DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();

    private void loadSupport() {
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        List prefList = preferences.getAnnotationPreferences();
        for (AnnotationPreference annotationPreference : prefList) {
            this.setAnnotationPreference(annotationPreference);
        }
        this.install(EditorsPlugin.getDefault().getPreferenceStore());
    }

    public VexAnnotationSupport() {
        this.loadSupport();
    }

    protected void install(IPreferenceStore store) {
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    VexAnnotationSupport.this.handlePreferenceStoreChanged(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.updateTextDecorations();
        this.updateOverviewDecorations();
    }

    protected void uninstall() {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
            this.fPreferenceStore = null;
        }
    }

    private void updateTextDecorations() {
        for (Object type : this.fAnnotationTypeKeyMap.keySet()) {
            if (this.areAnnotationsHighlighted(type) || this.areAnnotationsShown(type)) {
                this.showAnnotations(type, false);
                continue;
            }
            this.hideAnnotations(type, false);
        }
        this.updateAnnotationPainter();
    }

    public String getAnnotationDecorationType(String annotationType) {
        AnnotationPreference info;
        if (this.areAnnotationsHighlighted(annotationType)) {
            return null;
        }
        if (this.areAnnotationsShown(annotationType) && this.fPreferenceStore != null && (info = this.getPreference(annotationType)) != null) {
            String key = info.getTextStylePreferenceKey();
            if (key != null) {
                return this.fPreferenceStore.getString(key);
            }
            return "SQUIGGLES";
        }
        return "NONE";
    }

    public void updateOverviewDecorations() {
        if (this.fOverviewRuler != null) {
            for (Object type : this.fAnnotationTypeKeyMap.keySet()) {
                if (this.isAnnotationOverviewShown(type)) {
                    this.showAnnotationOverview(type, false);
                    continue;
                }
                this.hideAnnotationOverview(type, false);
            }
            this.fOverviewRuler.update();
        }
    }

    public void dispose() {
        this.uninstall();
        this.updateTextDecorations();
        this.updateOverviewDecorations();
        if (this.fFontPropertyChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
            this.fFontPropertyChangeListener = null;
        }
        this.fOverviewRuler = null;
        this.fAnnotationPainter = null;
        if (this.fAnnotationTypeKeyMap != null) {
            this.fAnnotationTypeKeyMap.clear();
        }
    }

    public void setAnnotationPainterPreferenceKeys(Object type, String colorKey, String editorKey, String overviewRulerKey, int layer) {
        AnnotationPreference info = new AnnotationPreference(type, colorKey, editorKey, overviewRulerKey, layer);
        this.fAnnotationTypeKeyMap.put(type, info);
    }

    public void setAnnotationPreference(AnnotationPreference info) {
        this.fAnnotationTypeKeyMap.put(info.getAnnotationType(), info);
    }

    private AnnotationPreference getAnnotationPreferenceInfo(String preferenceKey) {
        for (AnnotationPreference info : this.fAnnotationTypeKeyMap.values()) {
            if (info == null || !info.isPreferenceKey(preferenceKey)) continue;
            return info;
        }
        return null;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        AnnotationPreference info = this.getAnnotationPreferenceInfo(p);
        if (info != null) {
            if (info.getColorPreferenceKey().equals(p)) {
                Color color = this.getColor(info.getColorPreferenceKey());
                if (this.fAnnotationPainter != null) {
                    this.fAnnotationPainter.setAnnotationTypeColor(info.getAnnotationType(), color);
                    this.fAnnotationPainter.paint(16);
                }
                this.setAnnotationOverviewColor(info.getAnnotationType(), color);
                return;
            }
            Object type = info.getAnnotationType();
            if (info.getTextPreferenceKey().equals(p) || info.getTextStylePreferenceKey() != null && info.getTextStylePreferenceKey().equals(p) || info.getHighlightPreferenceKey() != null && info.getHighlightPreferenceKey().equals(p)) {
                if (this.areAnnotationsHighlighted(type) || this.areAnnotationsShown(type)) {
                    this.showAnnotations(type, true);
                } else {
                    this.hideAnnotations(type, true);
                }
                return;
            }
            if (info.getOverviewRulerPreferenceKey().equals(p)) {
                if (this.isAnnotationOverviewShown(info.getAnnotationType())) {
                    this.showAnnotationOverview(info.getAnnotationType(), true);
                } else {
                    this.hideAnnotationOverview(info.getAnnotationType(), true);
                }
                return;
            }
        }
    }

    private Color getColor(String key) {
        if (this.fPreferenceStore != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)key);
            return this.getColor(rgb);
        }
        return null;
    }

    private Color getColor(RGB rgb) {
        return this.fSharedTextColors.getColor(rgb);
    }

    private Color getAnnotationTypeColor(Object annotationType) {
        AnnotationPreference info = this.fAnnotationTypeKeyMap.get(annotationType);
        if (info != null) {
            return this.getColor(info.getColorPreferenceKey());
        }
        return null;
    }

    private int getAnnotationTypeLayer(Object annotationType) {
        AnnotationPreference info = this.fAnnotationTypeKeyMap.get(annotationType);
        if (info != null) {
            return info.getPresentationLayer();
        }
        return 0;
    }

    private void showAnnotations(Object annotationType, boolean updatePainter) {
        if (updatePainter) {
            this.updateAnnotationPainter();
        }
    }

    protected AnnotationPainter createAnnotationPainter() {
        return null;
    }

    private void updateAnnotationPainter() {
        if (this.fAnnotationPainter == null) {
            return;
        }
    }

    private void hideAnnotations(Object annotationType, boolean updatePainter) {
        if (this.fAnnotationPainter != null) {
            this.fAnnotationPainter.removeAnnotationType(annotationType);
            if (updatePainter) {
                this.updateAnnotationPainter();
            }
        }
    }

    private boolean areAnnotationsShown(Object annotationType) {
        AnnotationPreference info;
        if (this.fPreferenceStore != null && (info = this.getPreference(annotationType)) != null) {
            String key = info.getTextPreferenceKey();
            return key != null && this.fPreferenceStore.getBoolean(key);
        }
        return false;
    }

    private boolean areAnnotationsHighlighted(Object annotationType) {
        AnnotationPreference info;
        if (this.fPreferenceStore != null && (info = this.fAnnotationTypeKeyMap.get(annotationType)) != null) {
            return info.getHighlightPreferenceKey() != null && this.fPreferenceStore.getBoolean(info.getHighlightPreferenceKey());
        }
        return false;
    }

    private boolean isAnnotationOverviewShown(Object annotationType) {
        AnnotationPreference info;
        if (this.fPreferenceStore != null && this.fOverviewRuler != null && (info = this.fAnnotationTypeKeyMap.get(annotationType)) != null) {
            return this.fPreferenceStore.getBoolean(info.getOverviewRulerPreferenceKey());
        }
        return false;
    }

    private void showAnnotationOverview(Object annotationType, boolean update) {
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.setAnnotationTypeColor(annotationType, this.getAnnotationTypeColor(annotationType));
            this.fOverviewRuler.setAnnotationTypeLayer(annotationType, this.getAnnotationTypeLayer(annotationType));
            this.fOverviewRuler.addAnnotationType(annotationType);
            if (update) {
                this.fOverviewRuler.update();
            }
        }
    }

    private void hideAnnotationOverview(Object annotationType, boolean update) {
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.removeAnnotationType(annotationType);
            if (update) {
                this.fOverviewRuler.update();
            }
        }
    }

    public void hideAnnotationOverview() {
        if (this.fOverviewRuler != null) {
            Iterator<Object> e = this.fAnnotationTypeKeyMap.keySet().iterator();
            while (e.hasNext()) {
                this.fOverviewRuler.removeAnnotationType(e.next());
            }
            this.fOverviewRuler.update();
        }
    }

    private void setAnnotationOverviewColor(Object annotationType, Color color) {
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.setAnnotationTypeColor(annotationType, color);
            this.fOverviewRuler.update();
        }
    }

    public AnnotationPreference getPreference(Object annotationType) {
        AnnotationPreference preference = this.fAnnotationTypeKeyMap.get(annotationType);
        if (preference == null) {
            Object[] supertypes;
            Object[] objectArray = supertypes = this.getAccess().getSupertypes(annotationType);
            int n = supertypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object supertype = objectArray[n2];
                AnnotationPreference superPreference = this.fAnnotationTypeKeyMap.get(supertype);
                if (superPreference != null) {
                    return superPreference;
                }
                ++n2;
            }
        }
        return preference;
    }

    public AnnotationPreference getPreference(Annotation annotation) {
        return this.getPreference(annotation.getType());
    }

    public DefaultMarkerAnnotationAccess getAccess() {
        return this.access;
    }
}

