/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.IntervalMultimap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.VexAnnotationSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class VexAnnotationTracker
extends PlatformObject
implements IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private final Object input;
    private final IDocumentProvider provider;
    private final IStructuredDocument document;
    private final IAnnotationModel annotationModel;
    private final BiMap<Annotation, IVexNode> annotationModelMap = HashBiMap.create();
    private final IntervalMultimap<Annotation> annotationPositionMap = new IntervalMultimap();
    private final VexAnnotationSupport support;
    private final Map<Annotation, AnnotationRenderingInfo> renderingInfoCache = Maps.newHashMap();

    public VexAnnotationTracker(Object input, IDocumentProvider provider) {
        this.input = input;
        this.provider = provider;
        IDocument idocument = provider.getDocument(input);
        Assert.isLegal((boolean)(idocument instanceof IStructuredDocument), (String)"Can only track input that resolves to IStructuredDocuments.");
        this.document = (IStructuredDocument)idocument;
        this.annotationModel = provider.getAnnotationModel(input);
        this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)this);
        this.support = new VexAnnotationSupport();
    }

    public void dispose() {
        this.annotationModel.removeAnnotationModelListener((IAnnotationModelListener)this);
    }

    public void modelChanged(IAnnotationModel model) {
    }

    public void modelChanged(AnnotationModelEvent event) {
        Annotation[] annotationArray = event.getRemovedAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.removeAnnotation(annotation);
            ++n2;
        }
        Annotation[] addedAnnotations = event.getAddedAnnotations();
        Annotation[] changedAnnotations = event.getChangedAnnotations();
        if (addedAnnotations.length > 0 || changedAnnotations.length > 0) {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(this.document);
            try {
                Annotation annotation;
                Annotation[] annotationArray2 = addedAnnotations;
                int n3 = addedAnnotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    annotation = annotationArray2[n4];
                    this.putAnnotation(annotation, model);
                    ++n4;
                }
                annotationArray2 = changedAnnotations;
                n3 = changedAnnotations.length;
                n4 = 0;
                while (n4 < n3) {
                    annotation = annotationArray2[n4];
                    this.putAnnotation(annotation, model);
                    ++n4;
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
    }

    private void removeAnnotation(Annotation annotation) {
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/annotations") && annotation.getType().equalsIgnoreCase("org.eclipse.wst.sse.ui.temp.error")) {
            System.out.println(MessageFormat.format("Removing a {1}\u00a0annotation for {0}: {2}", this.annotationModelMap.get((Object)annotation), annotation.getType(), annotation.getText()));
        }
        this.annotationModelMap.remove((Object)annotation);
        this.annotationPositionMap.remove((Object)annotation);
        this.renderingInfoCache.remove(annotation);
    }

    private void putAnnotation(Annotation annotation, IStructuredModel model) {
        IndexedRegion region;
        IVexNode linkedNode;
        Position position = this.annotationModel.getPosition(annotation);
        if (position == null) {
            position = new Position(0);
        }
        if ((linkedNode = (IVexNode)AdapterUtils.getAdapter((Object)(region = model.getIndexedRegion(position.offset)), IVexNode.class)) != null) {
            this.annotationModelMap.forcePut((Object)annotation, (Object)linkedNode);
            LinkedDocument linkedDocument = ((LinkedNode)linkedNode).getDocument();
            if (linkedDocument != null) {
                IntervalMultimap.Interval contentInterval = IntervalMultimap.Interval.of((IRegion)linkedDocument.contentRegionFor((IRegion)IntervalMultimap.Interval.of((Position)position)));
                this.annotationPositionMap.add(contentInterval, (Object)annotation);
            } else {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("There was a problem adding some annotation: I have not found a linked document corresponding to the node's annotation. Please help Thorsten by providing an exact description on how you got here (see TG-803):\n  Annotation:\t {0}\n  Indexed Region:\t {1}  Linked Node:\t {2}\n", annotation, region, linkedNode), (Throwable)new IllegalStateException()), 3);
            }
            if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/annotations")) {
                System.out.println(MessageFormat.format("Adding a {1} annotation for {0}: {2}", linkedNode, annotation.getType(), annotation.getText()));
            }
        } else {
            StatusManager.getManager().handle((IStatus)new Status(2, "net.sf.vex.toolkit", NLS.bind((String)"Added an annotation for a region that cannot be mapped to a linked node.\n  Annotation: {0}, Region: {1}", (Object)annotation, (Object)region)));
        }
    }

    public Annotation getAnnotation(IVexNode node) {
        return (Annotation)this.annotationModelMap.inverse().get((Object)node);
    }

    public Set<Annotation> getOverlappingAnnotations(IntervalMultimap.Interval contentInterval) {
        return this.annotationPositionMap.getOverlappingValues(contentInterval);
    }

    public AnnotationRenderingInfo getRenderingInfo(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        AnnotationRenderingInfo info = this.renderingInfoCache.get(annotation);
        if (info == null) {
            info = new AnnotationRenderingInfo(annotation, this, (IVexNode)this.annotationModelMap.get((Object)annotation));
            this.renderingInfoCache.put(annotation, info);
        }
        return info;
    }

    public static AnnotationRenderingInfo getRenderingInfo(LayoutContext context, IVexNode node) {
        if (context == null || node == null) {
            return null;
        }
        VexAnnotationTracker tracker = context.getAnnotationTracker();
        if (tracker == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("Trying to get annotation rendering info for node {0}\u00a0but there is no tracker yet!?", node), (Throwable)new IllegalStateException()));
            return null;
        }
        return tracker.getRenderingInfo(tracker.getAnnotation(node));
    }

    public static List<AnnotationRenderingInfo> getRenderingInfo(LayoutContext context, IRegion region) {
        if (context == null || region == null) {
            return ImmutableList.of();
        }
        VexAnnotationTracker tracker = context.getAnnotationTracker();
        if (tracker == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("Trying to get annotation rendering info for region {0}\u00a0but there is no tracker yet!?", region), (Throwable)new IllegalStateException()));
            return ImmutableList.of();
        }
        Set<Annotation> annotations = tracker.getOverlappingAnnotations(IntervalMultimap.Interval.of((IRegion)region));
        ArrayList result = Lists.newArrayListWithCapacity((int)annotations.size());
        for (Annotation annotation : annotations) {
            result.add(tracker.getRenderingInfo(annotation));
        }
        return result;
    }

    public VexAnnotationSupport getSupport() {
        return this.support;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }
}

