/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.impl.DocumentFragment;

public class VexSelection
extends StringSelection {
    public static final DataFlavor VEX_DOCUMENT_FRAGMENT_FLAVOR = new DataFlavor(DocumentFragment.class, "application/x-vex-document-fragment");
    private DataFlavor[] flavors;
    private IVexDocumentFragment frag;

    public VexSelection(String s, IVexDocumentFragment frag) {
        super(s);
        this.frag = frag;
        DataFlavor[] superFlavors = super.getTransferDataFlavors();
        this.flavors = new DataFlavor[superFlavors.length + 1];
        System.arraycopy(superFlavors, 0, this.flavors, 0, superFlavors.length);
        this.flavors[this.flavors.length - 1] = VEX_DOCUMENT_FRAGMENT_FLAVOR;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(VEX_DOCUMENT_FRAGMENT_FLAVOR)) {
            return this.frag;
        }
        return super.getTransferData(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(VEX_DOCUMENT_FRAGMENT_FLAVOR)) {
            return true;
        }
        return super.isDataFlavorSupported(flavor);
    }
}

