/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.vex.action.DeleteColumnAction;
import net.sf.vex.action.DeleteRowAction;
import net.sf.vex.action.DuplicateSelectionAction;
import net.sf.vex.action.IVexAction;
import net.sf.vex.action.InsertColumnAfterAction;
import net.sf.vex.action.InsertColumnBeforeAction;
import net.sf.vex.action.InsertRowAboveAction;
import net.sf.vex.action.InsertRowBelowAction;
import net.sf.vex.action.MoveColumnLeftAction;
import net.sf.vex.action.MoveColumnRightAction;
import net.sf.vex.action.MoveRowDownAction;
import net.sf.vex.action.MoveRowUpAction;
import net.sf.vex.action.NextTableCellAction;
import net.sf.vex.action.PasteTextAction;
import net.sf.vex.action.PreviousTableCellAction;
import net.sf.vex.action.RemoveElementAction;
import net.sf.vex.action.RestoreLastSelectionAction;
import net.sf.vex.action.SplitAction;
import net.sf.vex.action.SplitItemAction;
import net.sf.vex.action.linked.ChangeElementAction;
import net.sf.vex.action.linked.InsertElementAction;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.StyleSheetReader;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedDocumentReader;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.VexEditorEvent;
import net.sf.vex.editor.VexLoadWarning;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.action.VexActionAdapter;
import net.sf.vex.editor.config.DocumentType;
import net.sf.vex.editor.config.Style;
import net.sf.vex.layout.VexAnnotationTracker;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.CssWhitespacePolicy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class VexEditorPage
extends VexEditor {
    protected static final String DEFAULT_DOCTYPE_ID = "-//TEI//DTD TEI Lite XML ver. 1//EN";
    private static final int WARNING_BYTES = 0x100000;
    private StructuredTextEditor sourceEditor;
    private IDocument document;
    private IDOMModel domModel;
    private WarningState warningState = WarningState.NOT_CHECKED;
    private VexLoadWarning loadingLabel;
    private IWhitespacePolicyFactory wsFactory = new IWhitespacePolicyFactory(){

        public IWhitespacePolicy getPolicy(String publicId) {
            if (VexEditorPage.this.getDoctype() == null) {
                VexEditorPage.this.setDoctype(VexEditorPage.this.getDefaultDoctype());
                VexEditorPage.this.setUpdateDoctypeDecl(false);
                if (VexEditorPage.this.getDoctype() == null) {
                    throw new VexEditor.NoRegisteredDoctypeException(VexEditorPage.this, null);
                }
            }
            VexEditorPage.this.setStyle(VexEditor.findStyleForDoctype(VexEditorPage.this.getDoctype().getPublicId()));
            if (VexEditorPage.this.getStyle() == null) {
                throw new VexEditor.NoStyleForDoctypeException(VexEditorPage.this, VexEditorPage.this.getDoctype());
            }
            return new CssWhitespacePolicy(VexEditorPage.this.style.getStyleSheet());
        }
    };
    protected final Job checkModelJob = new UIJob("Checking WYSIWYM model consistency"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking WYSIWYM model consistency", (int)100);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            final LinkedDocument newVexDocument = LinkedDocumentReader.createVexDocument((IDocument)VexEditorPage.this.getDocument(), (IWhitespacePolicyFactory)VexEditorPage.this.getWsFactory(), (IProgressMonitor)progress.newChild(50));
            LinkedDocument oldVexDocument = VexEditorPage.this.getDoc();
            IStatus comparison = LinkedDocument.deepCompare((LinkedNode)((LinkedNode)oldVexDocument.getRootElement()), (LinkedNode)((LinkedNode)newVexDocument.getRootElement()));
            if (comparison.isOK()) {
                newVexDocument.dispose();
            } else {
                new UIJob("Reloading WYSIWYM document"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (VexEditorPage.this.getVexWidget() == null || VexEditorPage.this.getVexWidget().isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        VexEditorPage.this.reloadInput(newVexDocument);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            this.schedule(5000L);
            return Status.OK_STATUS;
        }
    };

    public LinkedDocument getDoc() {
        return (LinkedDocument)super.getDoc();
    }

    @Override
    protected void showLabel(String message) {
        VexLoadWarning warning = this.getLoadWarning();
        warning.setLoadingText(message);
    }

    private VexLoadWarning getLoadWarning() {
        if (this.loadingLabel == null) {
            if (this.getVexWidget() != null) {
                this.getVexWidget().dispose();
                this.setVexWidget(null);
            }
            this.loadingLabel = new VexLoadWarning(this.getParentControl(), 0);
            this.loadingLabel.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (VexEditorPage.this.loadingLabel.isVisible() && VexEditorPage.this.getState() == VexEditor.State.UNLOADED) {
                        VexEditorPage.this.initAndLoad();
                    }
                }
            });
            this.loadingLabel.addProceedListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VexEditorPage.this.warningState = WarningState.MAY_LOAD;
                    VexEditorPage.this.initAndLoad();
                }
            });
        }
        if (this.document != null) {
            this.document.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    if (VexEditorPage.this.loadingLabel.isVisible()) {
                        VexEditorPage.this.warningState = WarningState.NOT_CHECKED;
                        VexEditorPage.this.initAndLoad();
                    }
                    VexEditorPage.this.document.removeDocumentListener((IDocumentListener)this);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }
        return this.loadingLabel;
    }

    @Override
    protected void clearLoadingLabel() {
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
    }

    @Override
    public IWhitespacePolicyFactory getWsFactory() {
        return this.wsFactory;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    @Override
    public boolean isDirty() {
        return this.getSourceEditor().isDirty();
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.getSelectionProvider());
        this.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        VexPlugin.getInstance().registerEditor(this);
    }

    protected DocumentType getDefaultDoctype() {
        DocumentType documentType = DocumentType.getDocumentType(DEFAULT_DOCTYPE_ID);
        return documentType;
    }

    public VexEditorPage(StructuredTextEditor sourceEditor, IDocument document) {
        this.sourceEditor = sourceEditor;
        this.document = document;
    }

    protected IPreferenceStore getWSTPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IDocument getDocument() {
        return this.document;
    }

    @Override
    protected void loadInput() {
        if (this.getVexWidget() != null) {
            this.getVexEditorListeners().fireEvent("documentUnloaded", (EventObject)new VexEditorEvent(this));
        }
        this.setLoaded(false);
        if (this.warningState == WarningState.NOT_CHECKED) {
            this.performDocumentChecks();
        }
        if (this.warningState == WarningState.MAY_LOAD) {
            Job loadJob = new Job("Loading WYSIWYM view"){

                public IStatus run(IProgressMonitor monitor) {
                    Object styleSheet;
                    final LinkedDocument vexDocument = LinkedDocumentReader.createVexDocument((IDocument)VexEditorPage.this.getDocument(), (IWhitespacePolicyFactory)VexEditorPage.this.getWsFactory(), (IProgressMonitor)monitor);
                    VexEditorPage.this.setDoc((IVexDocument)vexDocument);
                    StyleSheet suppliedStyleSheet = null;
                    if (vexDocument.getCSSfileLocation() != null) {
                        suppliedStyleSheet = VexEditorPage.this.loadStyleSheet(vexDocument.getCSSfileLocation());
                    }
                    if ((styleSheet = suppliedStyleSheet != null ? suppliedStyleSheet : (VexEditorPage.this.getStyle() != null ? VexEditorPage.this.getStyle().getStyleSheet() : null)) != null) {
                        new Job("Preloading stylesheet ...", (StyleSheet)styleSheet){
                            private SubMonitor progress;
                            private int lastProgress;
                            private final /* synthetic */ StyleSheet val$styleSheet;
                            {
                                this.val$styleSheet = styleSheet;
                                super($anonymous0);
                                this.lastProgress = 0;
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                long start = System.currentTimeMillis();
                                System.err.println("Starting preload ...");
                                this.progress = SubMonitor.convert((IProgressMonitor)monitor, (int)VexEditorPage.this.getDoc().getLength());
                                this.preload(VexEditorPage.this.getDoc().getRootElement());
                                System.err.println("Preload took " + (System.currentTimeMillis() - start) + "ms.");
                                return Status.OK_STATUS;
                            }

                            private void preload(IVexElement element) {
                                int startOffset = element.getStartOffset();
                                this.progress.worked(startOffset - this.lastProgress);
                                this.lastProgress = startOffset;
                                this.val$styleSheet.getStyles(element);
                                IVexElement[] iVexElementArray = element.getChildElements();
                                int n = iVexElementArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IVexElement child = iVexElementArray[n2];
                                    this.preload(child);
                                    ++n2;
                                }
                            }
                        }.schedule(20L);
                    }
                    UIJob configureJob = new UIJob("Configuring WYSIWYM view", (StyleSheet)styleSheet){
                        private final /* synthetic */ StyleSheet val$styleSheet;
                        {
                            this.val$styleSheet = styleSheet;
                            super($anonymous0);
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            VexEditorPage.this.showVexWidget();
                            VexEditorPage.this.getVexWidget().setDebugging(VexEditorPage.this.isDebugging());
                            VexEditorPage.this.getVexWidget().setAnnotationTracker(new VexAnnotationTracker((Object)VexEditorPage.this.getEditorInput(), VexEditorPage.this.getSourceEditor().getDocumentProvider()));
                            VexEditorPage.this.getVexWidget().setDocument((IVexDocument)vexDocument, this.val$styleSheet);
                            if (VexEditorPage.this.isUpdateDoctypeDecl()) {
                                VexEditorPage.this.getDoc().setPublicID(VexEditorPage.this.getDoctype().getPublicId());
                                VexEditorPage.this.getDoc().setSystemID(VexEditorPage.this.getDoctype().getSystemId());
                                VexEditorPage.this.doSave(null);
                            }
                            VexEditorPage.this.setLoaded(true);
                            VexEditorPage.this.setSavedUndoDepth(VexEditorPage.this.getVexWidget().getUndoDepth());
                            VexEditorPage.this.firePropertyChange(257);
                            VexEditorPage.this.setWasDirty(VexEditorPage.this.isDirty());
                            VexEditorPage.this.getVexEditorListeners().fireEvent("documentLoaded", (EventObject)new VexEditorEvent(VexEditorPage.this));
                            return Status.OK_STATUS;
                        }
                    };
                    configureJob.schedule(30L);
                    return Status.OK_STATUS;
                }
            };
            loadJob.setUser(true);
            loadJob.schedule();
        }
    }

    private void performDocumentChecks() {
        block20: {
            IDocument document = this.getDocument();
            int length = document.getLength();
            if (length > 0x100000) {
                this.warningState = WarningState.NOT_CONFIRMED;
                this.getLoadWarning().showSizeWarning(0x100000L);
            }
            IModelManager modelManager = StructuredModelManager.getModelManager();
            if (document instanceof IStructuredDocument) {
                IStructuredDocument sdocument = (IStructuredDocument)document;
                IStructuredModel modelForRead = modelManager.getModelForRead(sdocument);
                try {
                    try {
                        IDOMModel domModel;
                        IDOMDocument dom;
                        if (modelForRead instanceof IDOMModel && (dom = (domModel = (IDOMModel)modelForRead).getDocument()) != null) {
                            Element documentElement = dom.getDocumentElement();
                            if (documentElement == null) {
                                this.getLoadWarning().showRootElementError();
                                this.warningState = WarningState.NOT_CHECKED;
                            } else {
                                IVexNode adapter = (IVexNode)AdapterUtils.getAdapter((Object)documentElement, IVexNode.class);
                                if (adapter != null) {
                                    this.getLoadWarning().showDuplicateError();
                                    this.warningState = WarningState.NOT_CHECKED;
                                } else if ("TEI".equals(documentElement.getLocalName()) || "teiCorpus".equals(documentElement.getLocalName()) || "TEI.2".equals(documentElement.getLocalName())) {
                                    this.warningState = WarningState.MAY_LOAD;
                                } else {
                                    StylesheetInfo stylesheetInfo = VexEditorPage.findActiveStylesheet(domModel);
                                    if (stylesheetInfo != null) {
                                        this.warningState = WarningState.MAY_LOAD;
                                    } else {
                                        this.warningState = WarningState.NOT_CONFIRMED;
                                        this.getLoadWarning().showCSSWarning();
                                    }
                                }
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        if (modelForRead != null) {
                            modelForRead.releaseFromRead();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (modelForRead != null) {
                        modelForRead.releaseFromRead();
                    }
                    throw throwable;
                }
                if (modelForRead != null) {
                    modelForRead.releaseFromRead();
                }
            }
        }
        if (this.warningState != WarningState.MAY_LOAD) {
            this.setState(VexEditor.State.UNLOADED);
        }
    }

    private StyleSheet loadStyleSheet(String cssfile) {
        StyleSheet styleSheet = null;
        if (cssfile != null) {
            try {
                URI cssURI = new URI(cssfile.trim());
                InputStream cssInputStream = null;
                URL cssURL = null;
                if ("textgrid".equals(cssURI.getScheme())) {
                    TextGridObject cssObject = TextGridObject.getInstanceOffline((URI)cssURI);
                    IFile cssFile = (IFile)AdapterUtils.getAdapter((Object)cssObject, IFile.class);
                    if (cssFile != null) {
                        cssInputStream = cssFile.getContents();
                    }
                } else {
                    URI fileURI;
                    URL context = null;
                    IFile file = (IFile)AdapterUtils.getAdapter((Object)this.getEditorInput(), IFile.class);
                    if (file != null && (fileURI = file.getLocationURI()) != null) {
                        context = fileURI.toURL();
                    }
                    cssURL = new URL(context, cssfile);
                    cssInputStream = cssURL.openStream();
                }
                if (cssInputStream != null) {
                    InputSource source = new InputSource((Reader)new InputStreamReader(cssInputStream, "UTF-8"));
                    styleSheet = new StyleSheetReader().read(source, null);
                    cssInputStream.close();
                }
            }
            catch (URISyntaxException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.editor", NLS.bind((String)"Specified stylesheet string, {0}, is not a valid URI.", (Object)cssfile), (Throwable)e));
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "net.sf.vex.editor");
            }
            catch (UnsupportedEncodingException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.editor", e.getLocalizedMessage(), (Throwable)e));
            }
            catch (CSSException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.editor", NLS.bind((String)"Error parsing specified stylesheet {0}: {1}", (Object)cssfile, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.editor", NLS.bind((String)"Error reading specified stylesheet {0}: {1}", (Object)cssfile, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        return styleSheet;
    }

    public void reloadInput(boolean force) {
        this.getStyle().getStyleSheet().clearDocumentCache();
        LinkedDocument newVexDocument = LinkedDocumentReader.createVexDocument((IDocument)this.getDocument(), (IWhitespacePolicyFactory)this.getWsFactory(), null);
        LinkedDocument oldVexDocument = this.getDoc();
        IStatus comparison = LinkedDocument.deepCompare((LinkedNode)((LinkedNode)oldVexDocument.getRootElement()), (LinkedNode)((LinkedNode)newVexDocument.getRootElement()));
        if (!comparison.isOK()) {
            StatusManager.getManager().handle(comparison);
        }
        if (force || !comparison.isOK()) {
            this.reloadInput(newVexDocument);
        } else {
            newVexDocument.dispose();
        }
    }

    protected void reloadInput(LinkedDocument newVexDocument) {
        LinkedDocument oldVexDocument = this.getDoc();
        if (this.getVexWidget() != null) {
            this.getVexEditorListeners().fireEvent("documentUnloaded", (EventObject)new VexEditorEvent(this));
            int selectionStart = this.getVexWidget().getSelectionStart();
            int selectionEnd = this.getVexWidget().getSelectionEnd();
            this.setLoaded(false);
            this.setDoc((IVexDocument)newVexDocument);
            if (oldVexDocument instanceof LinkedDocument) {
                LinkedDocument oldLinkedDocument = oldVexDocument;
                oldLinkedDocument.dispose();
            }
            VexWidget widget = this.getVexWidget();
            widget.setDocument((IVexDocument)this.getDoc(), this.getStyle().getStyleSheet());
            this.setLoaded(true);
            this.getVexWidget().moveTo(selectionStart);
            if (selectionEnd > 0 && selectionEnd != selectionStart) {
                this.getVexWidget().moveBy(selectionEnd - selectionStart, true);
            }
        }
    }

    public void notifyActivate() {
        VexWidget widget = this.getVexWidget();
        if (widget != null) {
            widget.reLayout();
        }
        IContextService contextService = (IContextService)this.getSite().getWorkbenchWindow().getWorkbench().getService(IContextService.class);
        contextService.activateContext("net.sf.vex.editor.VexEditorContext");
    }

    public void selectSourceRegion(IRegion selection) {
        if (this.getVexWidget() == null || selection.getLength() == 0) {
            return;
        }
        this.getVexWidget().selectSourceRegion(selection);
    }

    @Override
    protected void registerBindings() {
        IKeyBindingService kbs = this.getSite().getKeyBindingService();
        kbs.setScopes(new String[]{"net.sf.vex.editor.VexEditorContext"});
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new ChangeElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DeleteColumnAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DeleteRowAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DuplicateSelectionAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertColumnAfterAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertColumnBeforeAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertRowAboveAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertRowBelowAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveColumnLeftAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveColumnRightAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveRowDownAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveRowUpAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new NextTableCellAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new PasteTextAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new PreviousTableCellAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new RemoveElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new RestoreLastSelectionAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new SplitAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new SplitItemAction()));
    }

    public void selectDOMNodes(IDOMNode firstNode, IDOMNode lastNode) {
        if (this.getVexWidget() != null) {
            this.getVexWidget().selectDOMNodes(firstNode, lastNode);
        }
    }

    public void gotoDOMNode(IDOMNode domNode) {
        if (this.getVexWidget() != null) {
            this.getVexWidget().gotoDOMNode(domNode);
        }
    }

    public void setStylesheet(String latestURI) {
        if (this.getVexWidget() != null) {
            StyleSheet styleSheet;
            if (latestURI == null) {
                Style findStyleForDoctype = VexEditorPage.findStyleForDoctype(this.getDocumentType().getPublicId());
                styleSheet = findStyleForDoctype.getStyleSheet();
            } else {
                styleSheet = this.loadStyleSheet(latestURI);
            }
            this.getVexWidget().setStyleSheet(styleSheet);
        }
    }

    private static Map<String, String> getPseudoAttributes(String data) {
        Matcher matcher = Pattern.compile("[a-zA-Z-]+=\"[^\"]*\"").matcher(data);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            String av = matcher.group();
            String key = av.substring(0, av.indexOf(61));
            String value = av.substring(av.indexOf(34) + 1, av.lastIndexOf(34)).trim();
            map.put(key, value);
        }
        return map;
    }

    public static StylesheetInfo findActiveStylesheet(IDOMModel model) throws URISyntaxException {
        IDOMDocument domDocument = model.getDocument();
        NodeList childNodes = domDocument.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Map<String, String> attributes;
            ProcessingInstruction pi;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 7 && (pi = (ProcessingInstruction)node).getTarget().equals("xml-stylesheet") && (attributes = VexEditorPage.getPseudoAttributes(pi.getData())).containsKey("type") && attributes.get("type").equals("text/css") && attributes.containsKey("href")) {
                ProcessingInstruction stylesheetNode = pi;
                URI stylesheetURI = new URI(attributes.get("href"));
                return new StylesheetInfo(stylesheetNode, stylesheetURI);
            }
            ++i;
        }
        return null;
    }

    public static class StylesheetInfo {
        public final ProcessingInstruction stylesheetNode;
        public final URI stylesheetURI;

        public StylesheetInfo(ProcessingInstruction stylesheetNode, URI stylesheetURI) {
            this.stylesheetNode = stylesheetNode;
            this.stylesheetURI = stylesheetURI;
        }
    }

    private static enum WarningState {
        NOT_CHECKED,
        NOT_CONFIRMED,
        MAY_LOAD;

    }
}

