/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import net.sf.vex.core.ListenerList;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.DoctypeFactory;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.IConfigListener;
import net.sf.vex.editor.config.PluginProject;
import net.sf.vex.editor.config.StyleFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.swt.widgets.Display;

public class ConfigRegistry {
    private static ConfigRegistry instance = new ConfigRegistry();
    private ILock lock = Platform.getJobManager().newLock();
    private List configs = new ArrayList();
    private ListenerList configListeners = new ListenerList(IConfigListener.class, ConfigEvent.class);
    private boolean configLoaded = false;
    private List configItemFactories = new ArrayList();
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                PluginProject pp = PluginProject.get((IProject)event.getResource());
                if (pp != null) {
                    ConfigRegistry.this.removeConfigSource(pp);
                    ConfigRegistry.this.fireConfigChanged(new ConfigEvent(this));
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] resources = event.getDelta().getAffectedChildren();
                int i = 0;
                while (i < resources.length) {
                    IResourceDelta delta = resources[i];
                    if (delta.getResource() instanceof IProject) {
                        final IProject project = (IProject)delta.getResource();
                        PluginProject pluginProject = PluginProject.get(project);
                        boolean hasPluginProjectNature = false;
                        try {
                            hasPluginProjectNature = project.hasNature("net.sf.vex.editor.pluginNature");
                        }
                        catch (CoreException coreException) {}
                        if (!project.isOpen() && pluginProject != null) {
                            ConfigRegistry.this.removeConfigSource(pluginProject);
                            ConfigRegistry.this.fireConfigChanged(new ConfigEvent(this));
                        } else if (project.isOpen() && pluginProject == null && hasPluginProjectNature) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    PluginProject.load(project);
                                }
                            };
                            Display.getDefault().asyncExec(runnable);
                        }
                    }
                    ++i;
                }
            }
        }
    };

    public static ConfigRegistry getInstance() {
        return instance;
    }

    public void addConfigSource(ConfigSource config) {
        try {
            this.lock();
            this.configs.add(config);
        }
        finally {
            this.unlock();
        }
    }

    public void addConfigListener(IConfigListener listener) {
        this.configListeners.add((Object)listener);
    }

    public void fireConfigChanged(final ConfigEvent e) {
        if (this.isConfigLoaded()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ConfigRegistry.this.configListeners.fireEvent("configChanged", (EventObject)e);
                }
            };
            Display display = Display.getDefault();
            if (display.getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                display.asyncExec(runnable);
            }
        }
    }

    public void fireConfigLoaded(final ConfigEvent e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ConfigRegistry.this.configLoaded = true;
                ConfigRegistry.this.configListeners.fireEvent("configLoaded", (EventObject)e);
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    public IConfigItemFactory[] getAllConfigItemFactories() {
        List f = this.configItemFactories;
        return f.toArray(new IConfigItemFactory[f.size()]);
    }

    public List getAllConfigItems(String extensionPoint) {
        try {
            this.lock();
            ArrayList items = new ArrayList();
            for (ConfigSource config : this.configs) {
                items.addAll(config.getValidItems(extensionPoint));
            }
            ArrayList arrayList = items;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    public List getAllConfigSources() {
        try {
            this.lock();
            ArrayList result = new ArrayList();
            result.addAll(this.configs);
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    public ConfigItem getConfigItem(String extensionPoint, String id) {
        try {
            this.lock();
            List items = this.getAllConfigItems(extensionPoint);
            for (ConfigItem item : items) {
                if (!item.getUniqueId().equals(id)) continue;
                ConfigItem configItem = item;
                return configItem;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    public IConfigItemFactory getConfigItemFactory(String extensionPointId) {
        for (IConfigItemFactory factory : this.configItemFactories) {
            if (!factory.getExtensionPointId().equals(extensionPointId)) continue;
            return factory;
        }
        return null;
    }

    public boolean isConfigLoaded() {
        return this.configLoaded;
    }

    public void lock() {
        this.lock.acquire();
    }

    public void removeConfigSource(ConfigSource config) {
        try {
            this.lock();
            this.configs.remove(config);
        }
        finally {
            this.unlock();
        }
    }

    public void removeConfigListener(IConfigListener listener) {
        this.configListeners.remove((Object)listener);
    }

    public void unlock() {
        this.lock.release();
    }

    private ConfigRegistry() {
        this.configItemFactories.add(new DoctypeFactory());
        this.configItemFactories.add(new StyleFactory());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }
}

