/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.debug;

import info.textgrid.lab.core.model.TGContentType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportContentTypesHandler
extends AbstractHandler
implements IHandler {
    static final String[][] FORMATS = new String[][]{{"contentTypes : {\n", "  %s : {\n\tid : \"%1$s\",\n\tmimeType : \"%s\",\n\tdescription : \"%s\",\n\tfile : \"%s\",\n\textension : \"%s\",\n\teclipse : \"%s\",\n\tplugin : \"%s\",\n  },\n", "}\n"}, {"|| ||MIME Type||Name||Filename Extension||Eclipse Content Type||Contributing Plugin||\n", "|!%4$s|alt=%1$s,title=%1$s!|%2$s|%3$s|%5$s|%6$s|%7$s|\n", "\n"}};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText("Save filetype list");
        dialog.setFilterExtensions(new String[]{"json", "wiki"});
        dialog.setFilterNames(new String[]{"JSON", "Confluence Wiki"});
        dialog.setFileName("contentTypes.json");
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File outputFile = new File(fileName);
        int format = dialog.getFilterIndex();
        try {
            PrintStream out = new PrintStream(outputFile);
            out.print(FORMATS[format][0]);
            ImageLoader loader = new ImageLoader();
            TGContentType[] tGContentTypeArray = TGContentType.getContentTypes((boolean)false);
            int n = tGContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TGContentType contentType = tGContentTypeArray[n2];
                String detailId = contentType.getId().substring(contentType.getId().indexOf(47) + 1);
                int plusIndex = detailId.indexOf(43);
                String shortId = plusIndex > 0 && detailId.endsWith("+xml") ? detailId.substring(0, plusIndex) : detailId;
                if (shortId.startsWith("tg.")) {
                    shortId = shortId.substring(3);
                }
                shortId = shortId.replaceAll("[^a-zA-Z0-9_-]+", "-");
                File imageFile = new File(outputFile.getParent(), String.valueOf(shortId) + ".png");
                loader.data = new ImageData[]{contentType.getImage(true).getImageData()};
                loader.save(imageFile.getPath(), 5);
                out.format(FORMATS[format][1], shortId, contentType.getId(), contentType.getDescription(), imageFile.getName(), contentType.getExtension(), contentType.getEclipseContentType(), contentType.getContributor().getName());
                ++n2;
            }
            out.print(FORMATS[format][2]);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

