/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.vex.core.FontSpec;
import net.sf.vex.css.BackgroundImageProperty;
import net.sf.vex.css.BorderSpacingProperty;
import net.sf.vex.css.BorderStyleProperty;
import net.sf.vex.css.BorderWidthProperty;
import net.sf.vex.css.ColorProperty;
import net.sf.vex.css.DisplayProperty;
import net.sf.vex.css.FontFamilyProperty;
import net.sf.vex.css.FontSizeProperty;
import net.sf.vex.css.FontStyleProperty;
import net.sf.vex.css.FontWeightProperty;
import net.sf.vex.css.GeneratedContentPropertiesImpl;
import net.sf.vex.css.IProperty;
import net.sf.vex.css.ImageHeightProperty;
import net.sf.vex.css.ImageWidthProperty;
import net.sf.vex.css.LengthProperty;
import net.sf.vex.css.LineHeightProperty;
import net.sf.vex.css.ListStyleTypeProperty;
import net.sf.vex.css.PropertyDecl;
import net.sf.vex.css.PseudoElement;
import net.sf.vex.css.Rule;
import net.sf.vex.css.Styles;
import net.sf.vex.css.TextAlignProperty;
import net.sf.vex.css.TextDecorationProperty;
import net.sf.vex.css.WhiteSpaceProperty;
import net.sf.vex.dom.IVexElement;
import org.w3c.css.sac.LexicalUnit;

public class StyleSheet
extends GeneratedContentPropertiesImpl
implements Serializable {
    private static final IProperty[] CSS_PROPERTIES = new IProperty[]{new DisplayProperty(), new LineHeightProperty(), new ListStyleTypeProperty(), new TextAlignProperty(), new WhiteSpaceProperty(), new FontFamilyProperty(), new FontSizeProperty(), new FontStyleProperty(), new FontWeightProperty(), new TextDecorationProperty(), new ColorProperty("color"), new ColorProperty("background-color"), new LengthProperty("margin-bottom", 1), new LengthProperty("margin-left", 0), new LengthProperty("margin-right", 0), new LengthProperty("margin-top", 1), new LengthProperty("padding-bottom", 1), new LengthProperty("padding-left", 0), new LengthProperty("padding-right", 0), new LengthProperty("padding-top", 1), new ColorProperty("border-bottom-color"), new ColorProperty("border-left-color"), new ColorProperty("border-right-color"), new ColorProperty("border-top-color"), new BorderStyleProperty("border-bottom-style"), new BorderStyleProperty("border-left-style"), new BorderStyleProperty("border-right-style"), new BorderStyleProperty("border-top-style"), new BorderWidthProperty("border-bottom-width", "border-bottom-style", 1), new BorderWidthProperty("border-left-width", "border-left-style", 0), new BorderWidthProperty("border-right-width", "border-right-style", 0), new BorderWidthProperty("border-top-width", "border-top-style", 1), new BorderSpacingProperty(), new ImageHeightProperty(), new ImageWidthProperty(), new BackgroundImageProperty()};
    private static IProperty[] properties = CSS_PROPERTIES;
    public static final byte SOURCE_DEFAULT = 0;
    public static final byte SOURCE_AUTHOR = 1;
    public static final byte SOURCE_USER = 2;
    private Rule[] rules;
    private transient Map<IVexElement, Styles> styleMap = null;
    private Set<IVexElement> elementsWithDisplayFix = Sets.newHashSet();

    public StyleSheet(Rule[] rules) {
        this.rules = rules;
    }

    public void flushStyles(IVexElement element) {
        this.getStyleMap().remove(element);
    }

    public void clearDocumentCache() {
        if (this.styleMap != null) {
            this.styleMap.clear();
        }
    }

    public IVexElement getAfterElement(IVexElement element) {
        PseudoElement pe = new PseudoElement(element, "after");
        Styles styles = this.getStyles(pe);
        if (styles == null) {
            return null;
        }
        return pe;
    }

    public IVexElement getBeforeElement(IVexElement element) {
        PseudoElement pe = new PseudoElement(element, "before");
        Styles styles = this.getStyles(pe);
        if (styles == null) {
            return null;
        }
        return pe;
    }

    public IVexElement getFirstLetterElement(IVexElement element) {
        PseudoElement pf = new PseudoElement(element, "first-letter");
        Styles styles = this.getStyles(pf);
        if (styles == null) {
            return null;
        }
        return pf;
    }

    public IVexElement getFirstLineElement(IVexElement element) {
        PseudoElement pf = new PseudoElement(element, "first-line");
        Styles styles = this.getStyles(pf);
        if (styles == null) {
            return null;
        }
        return pf;
    }

    public static IProperty[] getCssProperties() {
        return CSS_PROPERTIES;
    }

    public Styles getStyles(IVexElement element) {
        Styles styles = this.getStyleMap().get(element);
        if (styles != null) {
            return styles;
        }
        this.getStyleMap().containsKey(element);
        styles = element.getName().equals("first-letter") || element.getName().equals("first-line") ? this.calculateFirst_Letter_Line_Styles(element) : this.calculateStyles(element);
        if (styles == null) {
            this.getStyleMap().put(element, null);
        } else {
            this.getStyleMap().put(element, styles);
        }
        return styles;
    }

    private Styles calculateFirst_Letter_Line_Styles(IVexElement element) {
        String textDecoration;
        Map<String, LexicalUnit> decls;
        Styles styles = new Styles();
        Styles parentStyles = null;
        if (element.getParent() != null) {
            parentStyles = this.getStyles(element.getParent());
        }
        if ((decls = this.getApplicableDecls(element)).isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < properties.length) {
            IProperty property = properties[i];
            LexicalUnit lu = decls.get(property.getName());
            Object value = property.calculate(lu, parentStyles, styles);
            styles.put(property.getName(), value);
            ++i;
        }
        int styleFlags = 0;
        String fontStyle = styles.getFontStyle();
        if (fontStyle.equalsIgnoreCase("italic") || fontStyle.equalsIgnoreCase("oblique")) {
            styleFlags |= 2;
        }
        if (styles.getFontWeight() > 550) {
            styleFlags |= 1;
        }
        if ((textDecoration = styles.getTextDecoration()).equalsIgnoreCase("underline")) {
            styleFlags |= 4;
        } else if (textDecoration.equalsIgnoreCase("overline")) {
            styleFlags |= 8;
        } else if (textDecoration.equalsIgnoreCase("line-through")) {
            styleFlags |= 0x10;
        }
        styles.setFont(new FontSpec(styles.getFontFamilies(), styleFlags, Math.round(styles.getFontSize())));
        return styles;
    }

    private Styles calculateStyles(IVexElement element) {
        String textDecoration;
        Object value;
        LexicalUnit lu;
        Styles styles = new Styles();
        Styles parentStyles = null;
        if (element.getParent() != null) {
            parentStyles = this.getStyles(element.getParent());
        }
        Map<String, LexicalUnit> decls = this.getApplicableDecls(element);
        ArrayList<Object> content = new ArrayList<Object>();
        if (element instanceof PseudoElement) {
            if (element.getName().equals("before")) {
                this.generateCounterBefore(element);
            }
            if ((lu = decls.get("content")) == null) {
                return null;
            }
            String myStringValue = "";
            while (lu != null) {
                String re;
                if (lu.getLexicalUnitType() == 25) {
                    String val = lu.getParameters().getStringValue();
                    if (val.equalsIgnoreCase("div1")) {
                        if (element.getParent().getParent().getName().equalsIgnoreCase("div")) {
                            content.add(Integer.toString(this.mc_div));
                        } else {
                            content.add(Integer.toString(this.mc1));
                        }
                    } else if (val.equalsIgnoreCase("div2")) {
                        content.add(Integer.toString(this.mc2));
                    } else if (val.equalsIgnoreCase("div3")) {
                        content.add(Integer.toString(this.mc3));
                    }
                } else if (lu.getLexicalUnitType() == 37) {
                    String attributeName = lu.getStringValue();
                    value = element.getParent().getAttribute(attributeName);
                    if (value != null) {
                        content.add(value);
                    }
                }
                if (lu.getLexicalUnitType() == 36) {
                    myStringValue = lu.getStringValue();
                    content.add(myStringValue);
                }
                if ((re = lu.getStringValue()) != null && (re.equalsIgnoreCase("open-quote") || re.equalsIgnoreCase("close-quote"))) {
                    content.add("\"");
                }
                lu = lu.getNextLexicalUnit();
            }
            styles.setContent(content);
        }
        int i = 0;
        while (i < properties.length) {
            IProperty property = properties[i];
            lu = decls.get(property.getName());
            value = property.calculate(lu, parentStyles, styles);
            if (element.equals(element.getDocument().getRootElement())) {
                if (property.getName().equals("display") && value.equals("inline")) {
                    styles.put(property.getName(), "block");
                } else {
                    styles.put(property.getName(), value);
                }
            } else {
                styles.put(property.getName(), value);
            }
            ++i;
        }
        if (parentStyles != null && styles.isBlock() && !parentStyles.isBlock()) {
            Styles ancestorStyles;
            IVexElement ancestor = element.getParent();
            while (!(ancestorStyles = this.getStyles(ancestor)).isBlock()) {
                ancestorStyles.put("display", "block");
                this.reportDisplayFix(ancestor);
                if ((ancestor = ancestor.getParent()) != null) continue;
            }
        }
        if (parentStyles == null) {
            styles.put("display", "block");
        }
        int styleFlags = 0;
        String fontStyle = styles.getFontStyle();
        if (fontStyle.equalsIgnoreCase("italic") || fontStyle.equalsIgnoreCase("oblique")) {
            styleFlags |= 2;
        }
        if (styles.getFontWeight() > 550) {
            styleFlags |= 1;
        }
        if ((textDecoration = styles.getTextDecoration()).equalsIgnoreCase("underline")) {
            styleFlags |= 4;
        } else if (textDecoration.equalsIgnoreCase("overline")) {
            styleFlags |= 8;
        } else if (textDecoration.equalsIgnoreCase("line-through")) {
            styleFlags |= 0x10;
        }
        styles.setFont(new FontSpec(styles.getFontFamilies(), styleFlags, Math.round(styles.getFontSize())));
        return styles;
    }

    private void reportDisplayFix(IVexElement ancestor) {
        this.elementsWithDisplayFix.add(ancestor);
    }

    public static IProperty[] getProperties() {
        return properties;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public static void setProperties(IProperty[] properties) {
        StyleSheet.properties = properties;
    }

    public Map<String, LexicalUnit> getApplicableDecls(IVexElement element) {
        ArrayList<PropertyDecl> declList = new ArrayList<PropertyDecl>();
        Rule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            Rule rule = rules[i];
            if (rule.matches(element)) {
                PropertyDecl[] ruleDecls = rule.getPropertyDecls();
                int j = 0;
                while (j < ruleDecls.length) {
                    declList.add(ruleDecls[j]);
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(declList);
        HashMap<String, PropertyDecl> decls = new HashMap<String, PropertyDecl>();
        for (PropertyDecl decl : declList) {
            PropertyDecl prevDecl = (PropertyDecl)decls.get(decl.getProperty());
            if (prevDecl != null && prevDecl.isImportant() && !decl.isImportant()) continue;
            decls.put(decl.getProperty(), decl);
        }
        HashMap<String, LexicalUnit> values = new HashMap<String, LexicalUnit>();
        Iterator it = decls.keySet().iterator();
        while (it.hasNext()) {
            PropertyDecl decl = (PropertyDecl)decls.get(it.next());
            values.put(decl.getProperty(), decl.getValue());
        }
        return values;
    }

    private Map<IVexElement, Styles> getStyleMap() {
        if (this.styleMap == null) {
            this.styleMap = Collections.synchronizedMap(new WeakHashMap());
        }
        return this.styleMap;
    }
}

