/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.Position;

public class GapContent
implements Content {
    private char[] content;
    private int gapStart;
    private int gapEnd;
    private final Map positions = new HashMap();
    private static final int GROWTH_SLOWDOWN_SIZE = 100000;
    private static final int GROWTH_RATE_FAST = 2;
    private static final float GROWTH_RATE_SLOW = 5.1f;

    public GapContent(int initialCapacity) {
        GapContent.assertPositive(initialCapacity);
        this.content = new char[initialCapacity];
        this.gapStart = 0;
        this.gapEnd = initialCapacity;
    }

    @Override
    public Position createPosition(int offset) {
        GapContent.assertOffset(offset, 0, this.getLength());
        GapContentPosition pos = new GapContentPosition(offset);
        this.positions.put(pos, pos);
        return pos;
    }

    @Override
    public void insertString(int offset, String s) {
        GapContent.assertOffset(offset, 0, this.getLength());
        if (s.length() > this.gapEnd - this.gapStart) {
            this.expandContent(this.getLength() + s.length());
        }
        boolean atEnd = offset == this.getLength() && offset == this.gapStart;
        this.moveGap(offset);
        s.getChars(0, s.length(), this.content, offset);
        this.gapStart += s.length();
        if (!atEnd) {
            for (GapContentPosition pos : this.positions.keySet()) {
                if (pos.getOffset() < offset) continue;
                pos.setOffset(pos.getOffset() + s.length());
            }
        }
    }

    @Override
    public void remove(int offset, int length) {
        GapContent.assertOffset(offset, 0, this.getLength() - length);
        GapContent.assertPositive(length);
        this.moveGap(offset + length);
        this.gapStart -= length;
        for (GapContentPosition pos : this.positions.keySet()) {
            if (pos.getOffset() >= offset + length) {
                pos.setOffset(pos.getOffset() - length);
                continue;
            }
            if (pos.getOffset() < offset) continue;
            pos.setOffset(offset);
        }
    }

    @Override
    public String getString(int offset, int length) {
        GapContent.assertOffset(offset, 0, this.getLength() - length);
        GapContent.assertPositive(length);
        if (offset + length <= this.gapStart) {
            return new String(this.content, offset, length);
        }
        if (offset >= this.gapStart) {
            return new String(this.content, offset - this.gapStart + this.gapEnd, length);
        }
        StringBuffer sb = new StringBuffer(length);
        sb.append(this.content, offset, this.gapStart - offset);
        sb.append(this.content, this.gapEnd, offset + length - this.gapStart);
        return sb.toString();
    }

    @Override
    public int getLength() {
        return this.content.length - (this.gapEnd - this.gapStart);
    }

    private static void assertOffset(int offset, int min, int max) {
        if (offset < min || offset > max) {
            throw new IllegalArgumentException("Bad offset " + offset + "must be between " + min + " and " + max);
        }
    }

    private static void assertPositive(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value should be zero or positive, but it was " + value);
        }
    }

    private void expandContent(int newLength) {
        int newCapacity = newLength < 100000 ? Math.max(newLength * 2, 32) : (int)((float)newLength * 5.1f);
        char[] newContent = new char[newCapacity];
        System.arraycopy(this.content, 0, newContent, 0, this.gapStart);
        int tailLength = this.content.length - this.gapEnd;
        System.arraycopy(this.content, this.gapEnd, newContent, newCapacity - tailLength, tailLength);
        this.content = newContent;
        this.gapEnd = newCapacity - tailLength;
    }

    private void moveGap(int offset) {
        GapContent.assertOffset(offset, 0, this.getLength());
        if (offset <= this.gapStart) {
            int length = this.gapStart - offset;
            System.arraycopy(this.content, offset, this.content, this.gapEnd - length, length);
            this.gapStart -= length;
            this.gapEnd -= length;
        } else {
            int length = offset - this.gapStart;
            System.arraycopy(this.content, this.gapEnd, this.content, this.gapStart, length);
            this.gapStart += length;
            this.gapEnd += length;
        }
    }

    private static class GapContentPosition
    implements Position {
        private int offset;

        public GapContentPosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String toString() {
            return Integer.toString(this.offset);
        }
    }
}

