/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import net.sf.vex.dom.AttributeDefinition;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.Validator;
import net.sf.vex.editor.Messages;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ElementPropertySource
implements IPropertySource2 {
    private static final String ATTR_ID = "id";
    private IVexElement element;
    private Validator validator;
    private boolean multi;

    public ElementPropertySource(IVexElement element, Validator validator, boolean multi) {
        this.element = element;
        this.validator = validator;
        this.multi = multi;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        AttributeDefinition[] attrDefs = this.validator.getAttributeDefinitions(this.element.getName());
        IPropertyDescriptor[] pds = new IPropertyDescriptor[attrDefs.length];
        int i = 0;
        while (i < attrDefs.length) {
            AttributeDefinition def = attrDefs[i];
            pds[i] = this.multi && def.getName().equals(ATTR_ID) ? new PropertyDescriptor((Object)def.getName(), def.getName()) : (def.isFixed() ? new PropertyDescriptor((Object)def.getName(), def.getName()) : (def.getType() == AttributeDefinition.Type.ENUMERATION ? new ComboBoxPropertyDescriptor((Object)def.getName(), def.getName(), this.getEnumValues(def)) : new TextPropertyDescriptor((Object)def.getName(), def.getName())));
            ++i;
        }
        return pds;
    }

    public Object getPropertyValue(Object id) {
        if (this.multi && id.equals(ATTR_ID)) {
            return Messages.getString("ElementPropertySource.multiple");
        }
        AttributeDefinition def = this.validator.getAttributeDefinition(this.element.getName(), (String)id);
        String value = this.element.getAttribute((String)id);
        if (value == null && (value = def.getDefaultValue()) == null) {
            value = "";
        }
        if (def.getType() == AttributeDefinition.Type.ENUMERATION) {
            String[] values = this.getEnumValues(def);
            int i = 0;
            while (i < values.length) {
                if (values[i].equals(value)) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            AttributeDefinition def = this.validator.getAttributeDefinition(this.element.getName(), (String)id);
            if (def.getType() == AttributeDefinition.Type.ENUMERATION) {
                int i = (Integer)value;
                String s = this.getEnumValues(def)[i];
                if (!def.isRequired() && s.equals("")) {
                    this.element.removeAttribute(def.getName());
                } else {
                    this.element.setAttribute(def.getName(), s);
                }
            } else {
                String s = (String)value;
                if (s.equals("")) {
                    this.element.removeAttribute(def.getName());
                } else {
                    this.element.setAttribute(def.getName(), s);
                }
            }
        }
        catch (DocumentValidationException documentValidationException) {}
    }

    public boolean isPropertyResettable(Object id) {
        return true;
    }

    private String[] getEnumValues(AttributeDefinition def) {
        String[] values = def.getValues();
        if (def.isRequired()) {
            return values;
        }
        String[] values2 = new String[values.length + 1];
        values2[0] = "";
        System.arraycopy(values, 0, values2, 1, values.length);
        return values2;
    }
}

