/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.vex.editor.config.IConfigElement;

public class ConfigurationElement
implements IConfigElement {
    private String name;
    private String value;
    private Map attributes = new HashMap();
    private List children = new ArrayList();

    public ConfigurationElement() {
    }

    public ConfigurationElement(String name) {
        this.name = name;
    }

    public void addChild(IConfigElement child) {
        this.children.add(child);
    }

    @Override
    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    @Override
    public String[] getAttributeNames() {
        Set keys = this.attributes.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public IConfigElement[] getChildren() {
        return this.children.toArray(new IConfigElement[this.children.size()]);
    }

    @Override
    public IConfigElement[] getChildren(String name) {
        ArrayList<IConfigElement> kids = new ArrayList<IConfigElement>();
        for (IConfigElement child : this.children) {
            if (!child.getName().equals(name)) continue;
            kids.add(child);
        }
        return kids.toArray(new IConfigElement[kids.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setAttribute(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void setChildren(IConfigElement[] children) {
        this.children.clear();
        this.children.addAll(Arrays.asList(children));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

