/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import net.sf.vex.css.StyleSheetReader;
import net.sf.vex.editor.config.BuildProblem;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.ConfigurationElement;
import net.sf.vex.editor.config.IBuildProblemHandler;
import net.sf.vex.editor.config.IConfigElement;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.Style;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;

public class StyleFactory
implements IConfigItemFactory {
    private static final String[] EXTS = new String[]{"css"};

    public static List getStylesForDoctype(String publicId) {
        return null;
    }

    @Override
    public IConfigElement[] createConfigurationElements(ConfigItem item) {
        Style style = (Style)item;
        ConfigurationElement element = new ConfigurationElement("style");
        element.setAttribute("css", style.getResourcePath());
        Set doctypes = style.getDocumentTypes();
        for (String publicId : doctypes) {
            ConfigurationElement child = new ConfigurationElement("doctypeRef");
            child.setAttribute("publicId", publicId);
            element.addChild(child);
        }
        return new IConfigElement[]{element};
    }

    @Override
    public ConfigItem createItem(ConfigSource config, IConfigElement[] configElements) throws IOException {
        if (configElements.length < 1) {
            return null;
        }
        IConfigElement configElement = configElements[0];
        Style style = new Style(config);
        style.setResourcePath(configElement.getAttribute("css"));
        IConfigElement[] doctypeRefs = configElement.getChildren();
        int j = 0;
        while (j < doctypeRefs.length) {
            style.addDocumentType(doctypeRefs[j].getAttribute("publicId"));
            ++j;
        }
        return style;
    }

    @Override
    public String getExtensionPointId() {
        return "net.sf.vex.editor.styles";
    }

    @Override
    public String[] getFileExtensions() {
        return EXTS;
    }

    @Override
    public String getPluralName() {
        return Messages.getString("StyleFactory.pluralName");
    }

    @Override
    public Object parseResource(URL baseUrl, String resourcePath, IBuildProblemHandler problemHandler) throws IOException {
        try {
            return new StyleSheetReader().read(new URL(baseUrl, resourcePath));
        }
        catch (CSSParseException ex) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem();
                problem.setSeverity(1);
                problem.setResourcePath(ex.getURI());
                problem.setMessage(ex.getMessage());
                problem.setLineNumber(ex.getLineNumber());
                problemHandler.foundProblem(problem);
            }
            throw ex;
        }
        catch (CSSException ex) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem();
                problem.setSeverity(1);
                problem.setResourcePath(String.valueOf(baseUrl.getPath()) + resourcePath);
                problem.setMessage(ex.getMessage());
                problemHandler.foundProblem(problem);
            }
            throw ex;
        }
    }
}

