/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import info.textgrid.lab.core.metadataeditor.MetaDataSection;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import info.textgrid.lab.ui.core.dialogs.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MetadataPage
extends WizardPage
implements ITextGridWizardPage {
    private MetaDataSection metaDataSection = null;
    private TextGridObject textGridObject;
    private boolean needsCompleteMetadata;
    private ITextGridWizard wizard;
    private Composite container = null;
    private ScrolledForm mdPageScrolledForm = null;

    public MetadataPage(String pageName) {
        super(pageName, Messages.MetadataPage_PageName, null);
    }

    public boolean isPageComplete() {
        return !this.needsCompleteMetadata || this.textGridObject != null && this.textGridObject.isSubmittable();
    }

    public MetadataPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData(parent.getLayoutData());
        this.container.setLayout(parent.getLayout());
        String info = Messages.MetadataPage_UI_EnterName;
        if (!this.isNeedsCompleteMetadata()) {
            info = String.valueOf(info) + Messages.MetadataPage_UI_EnterLater;
        }
        this.setMessage(info);
        this.metaDataSection = new MetaDataSection(this.container, this.mdPageScrolledForm, this.wizard.getTextGridObject());
        this.setControl((Control)this.container);
    }

    @Override
    public void finishPage() {
        this.metaDataSection.updateTextGridObject();
    }

    @Override
    public void init(ITextGridWizard wizard, INewObjectPreparator preparator) {
        this.wizard = wizard;
    }

    @Override
    public void loadObject(TextGridObject textGridObject) {
        if (this.metaDataSection != null) {
            this.metaDataSection.setNewTGObject(textGridObject, true);
        }
    }

    public void setNeedsCompleteMetadata(boolean needsCompleteMetadata) {
        this.needsCompleteMetadata = needsCompleteMetadata;
    }

    public boolean isNeedsCompleteMetadata() {
        return this.needsCompleteMetadata;
    }
}

