/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.IOpenHandler;
import info.textgrid.lab.ui.core.OpenHandlerContribution;
import info.textgrid.lab.ui.core.handlers.DefaultOpenHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ContributableOpenHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            TextGridObject[] objects;
            MultiStatus multiStatus = new MultiStatus("info.textgrid.lab.core.metadataeditor", 0, "Some objects could not be opened.", null);
            TextGridObject[] textGridObjectArray = objects = (TextGridObject[])AdapterUtils.getAdapters((Object[])((IStructuredSelection)selection).toArray(), TextGridObject.class, (boolean)false);
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject object = textGridObjectArray[n2];
                try {
                    ContributableOpenHandler.openObject(object);
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
                ++n2;
            }
            if (multiStatus.getSeverity() >= 2) {
                StatusManager.getManager().handle((IStatus)multiStatus);
            }
            if (multiStatus.getSeverity() >= 4) {
                String title = "Could not open some objects.";
                String message = "Opening some or all of the objects you selected failed. Please see the details for an overview of what went wrong with which object.";
                ErrorDialog errorDialog = new ErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), title, message, (IStatus)multiStatus, 0);
                errorDialog.setBlockOnOpen(false);
                errorDialog.open();
            }
        }
        return null;
    }

    public static void openObject(TextGridObject object) throws CoreException {
        OpenHandlerContribution contribution = OpenHandlerContribution.bestContributionFor(object.getContentType(false));
        IOpenHandler handler = null;
        if (contribution != null) {
            handler = contribution.getHandler();
        }
        if (handler == null) {
            handler = new DefaultOpenHandler(contribution);
        }
        handler.open(object);
    }
}

