/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.io.Serializable;
import net.sf.vex.css.Rule;
import org.w3c.css.sac.LexicalUnit;

public class PropertyDecl
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte SOURCE_DEFAULT = 0;
    public static final byte SOURCE_AUTHOR = 1;
    public static final byte SOURCE_USER = 2;
    private Rule rule;
    private String property;
    private LexicalUnit value;
    private boolean important;

    public PropertyDecl(Rule rule, String property, LexicalUnit value, boolean important) {
        this.rule = rule;
        this.property = property;
        this.value = value;
        this.important = important;
    }

    public int compareTo(Object o) {
        int otherWeight;
        PropertyDecl other = (PropertyDecl)o;
        int thisWeight = this.getWeight();
        if (thisWeight != (otherWeight = other.getWeight())) {
            return thisWeight - otherWeight;
        }
        int thisSpec = this.getRule().getSpecificity();
        int otherSpec = other.getRule().getSpecificity();
        return thisSpec - otherSpec;
    }

    public boolean isImportant() {
        return this.important;
    }

    public String getProperty() {
        return this.property;
    }

    public Rule getRule() {
        return this.rule;
    }

    public LexicalUnit getValue() {
        return this.value;
    }

    private int getWeight() {
        byte source = this.getRule().getSource();
        if (this.isImportant() && source == 2) {
            return 4;
        }
        if (this.isImportant() && source == 1) {
            return 3;
        }
        if (!this.isImportant() && source == 1) {
            return 2;
        }
        if (!this.isImportant() && source == 2) {
            return 1;
        }
        return 0;
    }
}

