/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SacFactory {
    private Map cache = new HashMap();

    public Condition cloneCondition(Condition condition) {
        ConditionImpl clone = null;
        if (condition == null) {
            return null;
        }
        if (condition instanceof AttributeCondition) {
            clone = new AttributeConditionImpl((AttributeCondition)condition);
        } else if (condition instanceof CombinatorCondition) {
            clone = new CombinatorConditionImpl((CombinatorCondition)condition, this);
        } else if (condition instanceof ContentCondition) {
            clone = new ContentConditionImpl((ContentCondition)condition);
        } else if (condition instanceof LangCondition) {
            clone = new LangConditionImpl((LangCondition)condition);
        } else if (condition instanceof NegativeCondition) {
            clone = new NegativeConditionImpl((NegativeCondition)condition, this);
        } else if (condition instanceof PositionalCondition) {
            clone = new PositionalConditionImpl((PositionalCondition)condition);
        } else {
            throw new IllegalArgumentException("Unsupported condition type: " + condition.getClass());
        }
        return clone;
    }

    public LexicalUnit cloneLexicalUnit(LexicalUnit lu) {
        if (lu == null) {
            return null;
        }
        if (this.cache.containsKey(lu)) {
            return (LexicalUnit)this.cache.get(lu);
        }
        return new LexicalUnitImpl(lu, this);
    }

    public Selector cloneSelector(Selector selector) {
        SelectorImpl clone = null;
        if (selector == null) {
            return null;
        }
        if (selector instanceof CharacterDataSelector) {
            clone = new CharacterDataSelectorImpl((CharacterDataSelector)selector);
        } else if (selector instanceof ConditionalSelector) {
            clone = new ConditionalSelectorImpl((ConditionalSelector)selector, this);
        } else if (selector instanceof DescendantSelector) {
            clone = new DescendantSelectorImpl((DescendantSelector)selector, this);
        } else if (selector instanceof ElementSelector) {
            clone = new ElementSelectorImpl((ElementSelector)selector);
        } else if (selector instanceof NegativeSelector) {
            clone = new NegativeSelectorImpl((NegativeSelector)selector, this);
        } else if (selector instanceof ProcessingInstructionSelector) {
            clone = new ProcessingInstructionSelectorImpl((ProcessingInstructionSelector)selector);
        } else if (selector instanceof SiblingSelector) {
            clone = new SiblingSelectorImpl((SiblingSelector)selector, this);
        } else {
            throw new IllegalArgumentException("Unsupported selector type: " + selector.getClass());
        }
        return clone;
    }

    private static class AttributeConditionImpl
    extends ConditionImpl
    implements AttributeCondition {
        private String namespaceURI;
        private String localName;
        private boolean specified;
        private String value;

        public AttributeConditionImpl(AttributeCondition condition) {
            super((Condition)condition);
            this.namespaceURI = condition.getNamespaceURI();
            this.localName = condition.getLocalName();
            this.specified = condition.getSpecified();
            this.value = condition.getValue();
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getLocalName() {
            return this.localName;
        }

        public boolean getSpecified() {
            return this.specified;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class CharacterDataSelectorImpl
    extends SelectorImpl
    implements CharacterDataSelector {
        private String data;

        public CharacterDataSelectorImpl(CharacterDataSelector selector) {
            super((Selector)selector);
            this.data = selector.getData();
        }

        public String getData() {
            return this.data;
        }
    }

    private static class CombinatorConditionImpl
    extends ConditionImpl
    implements CombinatorCondition {
        private Condition firstCondition;
        private Condition secondCondition;

        public CombinatorConditionImpl(CombinatorCondition condition, SacFactory factory) {
            super((Condition)condition);
            this.firstCondition = factory.cloneCondition(condition.getFirstCondition());
            this.secondCondition = factory.cloneCondition(condition.getSecondCondition());
        }

        public Condition getFirstCondition() {
            return this.firstCondition;
        }

        public Condition getSecondCondition() {
            return this.secondCondition;
        }
    }

    private static class ConditionImpl
    implements Condition,
    Serializable {
        private short type;

        public ConditionImpl(Condition condition) {
            this.type = condition.getConditionType();
        }

        public short getConditionType() {
            return this.type;
        }
    }

    private static class ConditionalSelectorImpl
    extends SelectorImpl
    implements ConditionalSelector {
        private Condition condition;
        private SimpleSelector simpleSelector;

        public ConditionalSelectorImpl(ConditionalSelector selector, SacFactory factory) {
            super((Selector)selector);
            this.condition = factory.cloneCondition(selector.getCondition());
            this.simpleSelector = (SimpleSelector)factory.cloneSelector((Selector)selector.getSimpleSelector());
        }

        public SimpleSelector getSimpleSelector() {
            return this.simpleSelector;
        }

        public Condition getCondition() {
            return this.condition;
        }
    }

    private static class ContentConditionImpl
    extends ConditionImpl
    implements ContentCondition {
        private String data;

        public ContentConditionImpl(ContentCondition condition) {
            super((Condition)condition);
            this.data = condition.getData();
        }

        public String getData() {
            return this.data;
        }
    }

    private static class DescendantSelectorImpl
    extends SelectorImpl
    implements DescendantSelector {
        private Selector ancestor;
        private SimpleSelector simpleSelector;

        public DescendantSelectorImpl(DescendantSelector selector, SacFactory factory) {
            super((Selector)selector);
            this.ancestor = factory.cloneSelector(selector.getAncestorSelector());
            this.simpleSelector = (SimpleSelector)factory.cloneSelector((Selector)selector.getSimpleSelector());
        }

        public Selector getAncestorSelector() {
            return this.ancestor;
        }

        public SimpleSelector getSimpleSelector() {
            return this.simpleSelector;
        }
    }

    private static class ElementSelectorImpl
    extends SelectorImpl
    implements ElementSelector {
        private String namespaceURI;
        private String localName;

        public ElementSelectorImpl(ElementSelector selector) {
            super((Selector)selector);
            this.namespaceURI = selector.getNamespaceURI();
            this.localName = selector.getLocalName();
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getLocalName() {
            return this.localName;
        }
    }

    private static class LangConditionImpl
    extends ConditionImpl
    implements LangCondition {
        private String lang;

        public LangConditionImpl(LangCondition condition) {
            super((Condition)condition);
            this.lang = condition.getLang();
        }

        public String getLang() {
            return this.lang;
        }
    }

    private static class LexicalUnitImpl
    implements LexicalUnit,
    Serializable {
        private short type;
        private LexicalUnit next;
        private LexicalUnit prev;
        private LexicalUnit parameters;
        private String s;
        private int i;
        private float f;
        private String functionName;
        private String dimensionText;
        private String stringRepresentation;

        public LexicalUnitImpl(LexicalUnit lu, SacFactory factory) {
            factory.cache.put(lu, this);
            this.type = lu.getLexicalUnitType();
            try {
                this.s = lu.getStringValue();
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.i = lu.getIntegerValue();
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.f = lu.getFloatValue();
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.functionName = lu.getFunctionName();
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.next = factory.cloneLexicalUnit(lu.getNextLexicalUnit());
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.prev = factory.cloneLexicalUnit(lu.getPreviousLexicalUnit());
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                this.parameters = factory.cloneLexicalUnit(lu.getParameters());
            }
            catch (IllegalStateException illegalStateException) {}
            if (this.type == 23 || this.type == 15 || this.type == 16 || this.type == 17 || this.type == 19 || this.type == 20 || this.type == 18 || this.type == 21 || this.type == 22 || this.type == 28 || this.type == 30 || this.type == 29 || this.type == 31 || this.type == 32 || this.type == 33 || this.type == 34 || this.type == 42) {
                this.dimensionText = lu.getDimensionUnitText();
            }
            this.stringRepresentation = lu.toString();
        }

        public short getLexicalUnitType() {
            return this.type;
        }

        public LexicalUnit getNextLexicalUnit() {
            return this.next;
        }

        public LexicalUnit getPreviousLexicalUnit() {
            return this.prev;
        }

        public int getIntegerValue() {
            return this.i;
        }

        public float getFloatValue() {
            return this.f;
        }

        public String getDimensionUnitText() {
            return this.dimensionText;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }

        public String getStringValue() {
            return this.s;
        }

        public String getStringRepresentation() {
            return this.stringRepresentation;
        }

        public LexicalUnit getSubValues() {
            return this.parameters;
        }

        private LexicalUnitImpl() {
        }
    }

    private static class NegativeConditionImpl
    extends ConditionImpl
    implements NegativeCondition {
        private Condition condition;

        public NegativeConditionImpl(NegativeCondition condition, SacFactory factory) {
            super((Condition)condition);
            this.condition = factory.cloneCondition(condition.getCondition());
        }

        public Condition getCondition() {
            return this.condition;
        }
    }

    private static class NegativeSelectorImpl
    extends SelectorImpl
    implements NegativeSelector {
        private SimpleSelector simpleSelector;

        public NegativeSelectorImpl(NegativeSelector selector, SacFactory factory) {
            super((Selector)selector);
            this.simpleSelector = (SimpleSelector)factory.cloneSelector((Selector)selector.getSimpleSelector());
        }

        public SimpleSelector getSimpleSelector() {
            return this.simpleSelector;
        }
    }

    private static class PositionalConditionImpl
    extends ConditionImpl
    implements PositionalCondition {
        private int position;
        private boolean typeNode;
        private boolean type;

        public PositionalConditionImpl(PositionalCondition condition) {
            super((Condition)condition);
            this.position = condition.getPosition();
            this.typeNode = condition.getTypeNode();
            this.type = condition.getType();
        }

        public int getPosition() {
            return this.position;
        }

        public boolean getTypeNode() {
            return this.typeNode;
        }

        public boolean getType() {
            return this.type;
        }
    }

    private static class ProcessingInstructionSelectorImpl
    extends SelectorImpl
    implements ProcessingInstructionSelector {
        private String target;
        private String data;

        public ProcessingInstructionSelectorImpl(ProcessingInstructionSelector selector) {
            super((Selector)selector);
            this.target = selector.getTarget();
            this.data = selector.getData();
        }

        public String getTarget() {
            return this.target;
        }

        public String getData() {
            return this.data;
        }
    }

    private static class SelectorImpl
    implements Selector,
    Serializable {
        private short type;

        public SelectorImpl(Selector selector) {
            this.type = selector.getSelectorType();
        }

        public short getSelectorType() {
            return this.type;
        }
    }

    private static class SiblingSelectorImpl
    extends SelectorImpl
    implements SiblingSelector {
        private short nodeType;
        private Selector selector;
        private SimpleSelector siblingSelector;

        private SiblingSelectorImpl(SiblingSelector selector, SacFactory factory) {
            super((Selector)selector);
            this.nodeType = selector.getNodeType();
            this.selector = factory.cloneSelector(selector.getSelector());
            this.siblingSelector = (SimpleSelector)factory.cloneSelector((Selector)selector.getSiblingSelector());
        }

        public short getNodeType() {
            return this.nodeType;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public SimpleSelector getSiblingSelector() {
            return this.siblingSelector;
        }
    }
}

