/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.dialogs.Messages;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wb.swt.SWTResourceManager;

public class AllMetadataDialog
extends TitleAreaDialog {
    private Text textgridUriTextBox;
    private Text datacontributorTextBox;
    private Text fileformatTextBox;
    private Text filenameTextBox;
    private Text filesizeTextBox;
    private Text permissionsTextBox;
    private Text projectnameTextBox;
    private Text revisionnumberTextBox;
    private Text timecreatedTextBox;
    private Text timeoflastchangeTextBox;
    private TextGridObject textGridObject;
    private Text xmlTextField;
    private Button refreshButton;
    private String fileName;
    private TextGridObjectChangeListener textGridObjectChangeListener;

    public AllMetadataDialog(Shell parentShell, TextGridObject object) {
        super(parentShell);
        this.setShellStyle(2256);
        this.textGridObject = object;
        this.textGridObjectChangeListener = new TextGridObjectChangeListener();
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this.textGridObjectChangeListener);
    }

    public boolean close() {
        TextGridObject.removeListener((TextGridObject.ITextGridObjectListener)this.textGridObjectChangeListener);
        this.textGridObjectChangeListener = null;
        this.textGridObject = null;
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.refreshButton = this.createButton(parent, 8, Messages.AllMetadataDialog_Refresh, false);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllMetadataDialog.this.reloadMetaData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AllMetadataDialog.this.reloadMetaData();
            }
        });
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AllMetadataDialog_TitleName);
        this.setDialogMessage();
        this.getShell().setText(Messages.AllMetadataDialog_GenericTitle);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setBounds(0, 0, 490, 398);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tbtmDefaultMetadata = new TabItem(tabFolder, 0);
        tbtmDefaultMetadata.setText("Default Metadata");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tbtmDefaultMetadata.setControl((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        Group grpObjectProperties = new Group(composite, 0);
        FormData fd_grpObjectProperties = new FormData();
        fd_grpObjectProperties.right = new FormAttachment(100, 4);
        fd_grpObjectProperties.left = new FormAttachment(0);
        grpObjectProperties.setLayoutData((Object)fd_grpObjectProperties);
        grpObjectProperties.setFont(SWTResourceManager.getFont("Lucida Grande", 11, 1));
        grpObjectProperties.setText(Messages.AllMetadataDialog_ObjectProperties);
        grpObjectProperties.setLayout((Layout)new FormLayout());
        Label lblNewLabel = new Label((Composite)grpObjectProperties, 0);
        FormData fd_lblFileName = new FormData();
        fd_lblFileName.top = new FormAttachment(0, 10);
        fd_lblFileName.left = new FormAttachment(0);
        lblNewLabel.setLayoutData((Object)fd_lblFileName);
        lblNewLabel.setText(Messages.AllMetadataDialog_ObjectTitle);
        this.filenameTextBox = new Text((Composite)grpObjectProperties, 2048);
        FormData fd_lblFilenamecontent = new FormData();
        fd_lblFilenamecontent.right = new FormAttachment(100, -5);
        fd_lblFilenamecontent.top = new FormAttachment(0, 10);
        fd_lblFilenamecontent.left = new FormAttachment(0, 116);
        this.filenameTextBox.setLayoutData((Object)fd_lblFilenamecontent);
        AllMetadataDialog.formatTextBox(this.filenameTextBox);
        this.filenameTextBox.setText(this.fileName);
        Label lblNewLabel_1 = new Label((Composite)grpObjectProperties, 0);
        FormData fd_lblFileFormat = new FormData();
        fd_lblFileFormat.top = new FormAttachment(0, 35);
        fd_lblFileFormat.left = new FormAttachment(0);
        lblNewLabel_1.setLayoutData((Object)fd_lblFileFormat);
        lblNewLabel_1.setText(Messages.AllMetadataDialog_MIMEType);
        this.fileformatTextBox = new Text((Composite)grpObjectProperties, 2048);
        FormData fd_lblFileformatcontent = new FormData();
        fd_lblFileformatcontent.right = new FormAttachment(100, -5);
        fd_lblFileformatcontent.top = new FormAttachment(0, 35);
        fd_lblFileformatcontent.left = new FormAttachment(0, 116);
        this.fileformatTextBox.setLayoutData((Object)fd_lblFileformatcontent);
        AllMetadataDialog.formatTextBox(this.fileformatTextBox);
        Label lblNewLabel_3 = new Label((Composite)grpObjectProperties, 0);
        FormData fd_lblFileSize = new FormData();
        fd_lblFileSize.top = new FormAttachment(0, 60);
        fd_lblFileSize.left = new FormAttachment(0);
        lblNewLabel_3.setLayoutData((Object)fd_lblFileSize);
        lblNewLabel_3.setText(Messages.AllMetadataDialog_ObjectSize);
        this.filesizeTextBox = new Text((Composite)grpObjectProperties, 2048);
        FormData fd_lblFilesizecontent = new FormData();
        fd_lblFilesizecontent.right = new FormAttachment(100, -5);
        fd_lblFilesizecontent.top = new FormAttachment(0, 60);
        fd_lblFilesizecontent.left = new FormAttachment(0, 116);
        this.filesizeTextBox.setLayoutData((Object)fd_lblFilesizecontent);
        this.filesizeTextBox.setEditable(false);
        AllMetadataDialog.formatTextBox(this.filesizeTextBox);
        Group grpChanges = new Group(composite, 0);
        FormData fd_grpChanges = new FormData();
        fd_grpChanges.top = new FormAttachment(0, 103);
        fd_grpChanges.left = new FormAttachment(0);
        fd_grpChanges.right = new FormAttachment(100, 4);
        grpChanges.setLayoutData((Object)fd_grpChanges);
        grpChanges.setFont(SWTResourceManager.getFont("Lucida Grande", 11, 1));
        grpChanges.setText(Messages.AllMetadataDialog_Changes);
        grpChanges.setLayout((Layout)new FormLayout());
        Label lblNewLabel_2 = new Label((Composite)grpChanges, 0);
        FormData fd_lblRevisionNumber = new FormData();
        fd_lblRevisionNumber.top = new FormAttachment(0, 10);
        fd_lblRevisionNumber.left = new FormAttachment(0);
        lblNewLabel_2.setLayoutData((Object)fd_lblRevisionNumber);
        lblNewLabel_2.setText("Revision:");
        this.revisionnumberTextBox = new Text((Composite)grpChanges, 2048);
        FormData fd_lblRevisionnumbercontent = new FormData();
        fd_lblRevisionnumbercontent.right = new FormAttachment(100, -5);
        fd_lblRevisionnumbercontent.top = new FormAttachment(0, 10);
        fd_lblRevisionnumbercontent.left = new FormAttachment(0, 116);
        this.revisionnumberTextBox.setLayoutData((Object)fd_lblRevisionnumbercontent);
        AllMetadataDialog.formatTextBox(this.revisionnumberTextBox);
        Label lblNewLabel_4 = new Label((Composite)grpChanges, 0);
        FormData fd_lblTimeOfLast = new FormData();
        fd_lblTimeOfLast.top = new FormAttachment(0, 35);
        fd_lblTimeOfLast.left = new FormAttachment(0);
        lblNewLabel_4.setLayoutData((Object)fd_lblTimeOfLast);
        lblNewLabel_4.setText("Last change:");
        this.timeoflastchangeTextBox = new Text((Composite)grpChanges, 2048);
        FormData fd_lblTimeoflastchangecontent = new FormData();
        fd_lblTimeoflastchangecontent.right = new FormAttachment(100, -5);
        fd_lblTimeoflastchangecontent.top = new FormAttachment(0, 35);
        fd_lblTimeoflastchangecontent.left = new FormAttachment(0, 116);
        this.timeoflastchangeTextBox.setLayoutData((Object)fd_lblTimeoflastchangecontent);
        AllMetadataDialog.formatTextBox(this.timeoflastchangeTextBox);
        Group grpCreation = new Group(composite, 0);
        FormData fd_grpCreation = new FormData();
        fd_grpCreation.left = new FormAttachment(0);
        fd_grpCreation.right = new FormAttachment(100, 4);
        fd_grpCreation.top = new FormAttachment(0, 181);
        grpCreation.setLayoutData((Object)fd_grpCreation);
        grpCreation.setFont(SWTResourceManager.getFont("Lucida Grande", 11, 1));
        grpCreation.setText(Messages.AllMetadataDialog_Creation);
        grpCreation.setLayout((Layout)new FormLayout());
        Label lblNewLabel_5 = new Label((Composite)grpCreation, 0);
        FormData fd_lblDataContributor = new FormData();
        fd_lblDataContributor.top = new FormAttachment(0, 10);
        fd_lblDataContributor.left = new FormAttachment(0);
        lblNewLabel_5.setLayoutData((Object)fd_lblDataContributor);
        lblNewLabel_5.setText("Data contributor:");
        this.datacontributorTextBox = new Text((Composite)grpCreation, 2048);
        FormData fd_lblDatacontributorcontent = new FormData();
        fd_lblDatacontributorcontent.right = new FormAttachment(100, -5);
        fd_lblDatacontributorcontent.top = new FormAttachment(0, 10);
        fd_lblDatacontributorcontent.left = new FormAttachment(0, 116);
        this.datacontributorTextBox.setLayoutData((Object)fd_lblDatacontributorcontent);
        AllMetadataDialog.formatTextBox(this.datacontributorTextBox);
        Label lblNewLabel_6 = new Label((Composite)grpCreation, 0);
        FormData fd_lblTimeCreated = new FormData();
        fd_lblTimeCreated.top = new FormAttachment(0, 35);
        fd_lblTimeCreated.left = new FormAttachment(0);
        lblNewLabel_6.setLayoutData((Object)fd_lblTimeCreated);
        lblNewLabel_6.setText("Time created:");
        this.timecreatedTextBox = new Text((Composite)grpCreation, 2048);
        FormData fd_lblTimecreatedcontent = new FormData();
        fd_lblTimecreatedcontent.right = new FormAttachment(100, -5);
        fd_lblTimecreatedcontent.top = new FormAttachment(0, 35);
        fd_lblTimecreatedcontent.left = new FormAttachment(0, 116);
        this.timecreatedTextBox.setLayoutData((Object)fd_lblTimecreatedcontent);
        AllMetadataDialog.formatTextBox(this.timecreatedTextBox);
        Group grpPermissions = new Group(composite, 0);
        FormData fd_grpServerStorage = new FormData();
        fd_grpServerStorage.left = new FormAttachment(0);
        fd_grpServerStorage.right = new FormAttachment(100, 4);
        fd_grpServerStorage.top = new FormAttachment(0, 260);
        grpPermissions.setLayoutData((Object)fd_grpServerStorage);
        grpPermissions.setFont(SWTResourceManager.getFont("Lucida Grande", 11, 1));
        grpPermissions.setText(Messages.AllMetadataDialog_Permissions);
        grpPermissions.setLayout((Layout)new FormLayout());
        Label lblNewLabel_7 = new Label((Composite)grpPermissions, 0);
        FormData fd_lblProjectName = new FormData();
        fd_lblProjectName.top = new FormAttachment(0, 10);
        fd_lblProjectName.left = new FormAttachment(0);
        lblNewLabel_7.setLayoutData((Object)fd_lblProjectName);
        lblNewLabel_7.setText(Messages.AllMetadataDialog_ProjectID);
        this.projectnameTextBox = new Text((Composite)grpPermissions, 2048);
        FormData fd_lblProjectnamecontent = new FormData();
        fd_lblProjectnamecontent.right = new FormAttachment(100, -5);
        fd_lblProjectnamecontent.top = new FormAttachment(0, 10);
        fd_lblProjectnamecontent.left = new FormAttachment(0, 116);
        this.projectnameTextBox.setLayoutData((Object)fd_lblProjectnamecontent);
        AllMetadataDialog.formatTextBox(this.projectnameTextBox);
        Label lblNewLabel_8 = new Label((Composite)grpPermissions, 0);
        FormData fd_lblPermissions = new FormData();
        fd_lblPermissions.top = new FormAttachment(0, 35);
        fd_lblPermissions.left = new FormAttachment(0);
        lblNewLabel_8.setLayoutData((Object)fd_lblPermissions);
        lblNewLabel_8.setText(Messages.AllMetadataDialog_Permissions2);
        this.permissionsTextBox = new Text((Composite)grpPermissions, 2048);
        FormData fd_lblPermissionscontent = new FormData();
        fd_lblPermissionscontent.right = new FormAttachment(100, -5);
        fd_lblPermissionscontent.top = new FormAttachment(0, 35);
        fd_lblPermissionscontent.left = new FormAttachment(0, 116);
        this.permissionsTextBox.setLayoutData((Object)fd_lblPermissionscontent);
        AllMetadataDialog.formatTextBox(this.permissionsTextBox);
        Label lblNewLabel_9 = new Label((Composite)grpPermissions, 0);
        FormData fd_lblTextgridUri = new FormData();
        fd_lblTextgridUri.top = new FormAttachment(0, 60);
        fd_lblTextgridUri.left = new FormAttachment(0);
        lblNewLabel_9.setLayoutData((Object)fd_lblTextgridUri);
        lblNewLabel_9.setText(Messages.AllMetadataDialog_TextGridUri);
        this.textgridUriTextBox = new Text((Composite)grpPermissions, 2048);
        FormData fd_lblTextgridUricontent = new FormData();
        fd_lblTextgridUricontent.right = new FormAttachment(100, -5);
        fd_lblTextgridUricontent.top = new FormAttachment(0, 60);
        fd_lblTextgridUricontent.left = new FormAttachment(0, 116);
        this.textgridUriTextBox.setLayoutData((Object)fd_lblTextgridUricontent);
        AllMetadataDialog.formatTextBox(this.textgridUriTextBox);
        Label incompleteWarning = new Label(parent, 64);
        incompleteWarning.setLayoutData((Object)new GridData(4, 4, false, false));
        incompleteWarning.setText(Messages.AllMetadataDialog_UI_KnownMetadata);
        this.reloadMetaData();
        TabItem tbtmRawMetadata = new TabItem(tabFolder, 0);
        tbtmRawMetadata.setText("Raw Metadata");
        Composite compositeRaw = new Composite((Composite)tabFolder, 0);
        tbtmRawMetadata.setControl((Control)compositeRaw);
        compositeRaw.setLayout((Layout)new GridLayout(1, false));
        this.xmlTextField = new Text(compositeRaw, 2826);
        this.xmlTextField.setLayoutData((Object)new GridData(4, 4, true, true));
        return area;
    }

    private void setDialogMessage() {
        this.getFileName();
        this.setMessage("\t\t" + this.fileName);
    }

    private String getFileName() {
        this.fileName = "name";
        try {
            this.fileName = this.textGridObject.getTitle();
        }
        catch (CoreException coreException) {
            this.fileName = this.textGridObject.toString();
            try {
                this.fileName = this.textGridObject.getNameCandidate();
            }
            catch (CoreException e1) {
                Activator.handleError(e1, "problem retrieving name candidate", new Object[0]);
            }
        }
        return this.fileName;
    }

    protected Point getInitialSize() {
        return new Point(450, 620);
    }

    private void reloadMetaData() {
        Job reloadJob = new Job(NLS.bind((String)Messages.AllMetadataDialog_ReloadMetadata, (Object)this.textGridObject.toString())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AllMetadataDialog.this.textGridObject.reloadMetadata(true);
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e, Messages.AllMetadataDialog_CouldntReloadMetadata, AllMetadataDialog.this.textGridObject);
                }
                return new Status(0, "info.textgrid.lab.ui.core", Messages.AllMetadataDialog_ReadMetadata);
            }
        };
        reloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    UIJob uiJob = new UIJob(Messages.AllMetadataDialog_UpdateGUI){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                AllMetadataDialog.this.updateGui();
                            }
                            catch (CrudServiceException e) {
                                return Activator.handleError(e, Messages.AllMetadataDialog_EM_CoundntReadMetadata, null);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                }
            }
        });
        reloadJob.setUser(true);
        reloadJob.schedule();
    }

    private static void formatTextBox(Text preText) {
        preText.setEditable(false);
        preText.setBackground(SWTResourceManager.getColor(19));
    }

    public static AllMetadataDialog show(TextGridObject textGridObject, Shell parentShell) {
        AllMetadataDialog dialog = new AllMetadataDialog(parentShell, textGridObject);
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    private void updateGui() throws CrudServiceException {
        ObjectType metadataForReading = this.textGridObject.getMetadataForReading();
        String formatContentString = metadataForReading.getGeneric().getProvided().getFormat();
        String permissionsContentString = metadataForReading.getGeneric().getGenerated().getPermissions();
        String createdContentString = metadataForReading.getGeneric().getGenerated().getCreated().toString();
        String lastModifiedContentString = metadataForReading.getGeneric().getGenerated().getLastModified().toString();
        String revisionContentString = String.valueOf(metadataForReading.getGeneric().getGenerated().getRevision());
        String textgridUriContentString = metadataForReading.getGeneric().getGenerated().getTextgridUri().getValue();
        String projectContentString = metadataForReading.getGeneric().getGenerated().getProject().getId();
        String dataContributorContentString = metadataForReading.getGeneric().getGenerated().getDataContributor();
        String extentContentString = String.valueOf(metadataForReading.getGeneric().getGenerated().getExtent());
        int parsedExtent = Integer.parseInt(extentContentString);
        extentContentString = " Byte";
        if (parsedExtent > 1024) {
            parsedExtent /= 1024;
            extentContentString = " KiloByte";
        }
        if (parsedExtent > 1024) {
            parsedExtent /= 1024;
            extentContentString = " MegaByte";
        }
        extentContentString = String.valueOf(parsedExtent) + extentContentString;
        this.setDialogMessage();
        this.filenameTextBox.setText(this.getFileName());
        this.fileformatTextBox.setText(formatContentString);
        this.filesizeTextBox.setText(extentContentString);
        this.revisionnumberTextBox.setText(revisionContentString);
        this.timeoflastchangeTextBox.setText(lastModifiedContentString);
        this.projectnameTextBox.setText(projectContentString);
        this.permissionsTextBox.setText(permissionsContentString);
        this.textgridUriTextBox.setText(textgridUriContentString);
        this.datacontributorTextBox.setText(dataContributorContentString);
        this.timecreatedTextBox.setText(createdContentString);
        this.xmlTextField.setText(this.textGridObject.serialize());
    }

    private class TextGridObjectChangeListener
    implements TextGridObject.ITextGridObjectListener {
        private TextGridObjectChangeListener() {
        }

        public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
            if (event == TextGridObject.ITextGridObjectListener.Event.METADATA_CHANGED_FROM_OUTSIDE) {
                AllMetadataDialog.this.reloadMetaData();
            }
        }
    }
}

