/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class HeadingFigure
extends Figure {
    public static final Color headerColor = new Color(null, 224, 233, 246);
    Label label;
    Color[] gradientColor = new Color[]{ColorConstants.white, ColorConstants.lightGray, ColorConstants.lightBlue, ColorConstants.gray};
    boolean isSelected = false;
    boolean isReadOnly = false;

    public HeadingFigure() {
        this.label = new Label();
        this.label.setBorder((Border)new MarginBorder(2));
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)toolbarLayout);
        this.add((IFigure)this.label);
    }

    public void setGradientColors(Color[] colors) {
        this.gradientColor = colors;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.pushState();
        try {
            Color gradient1;
            Rectangle r = this.getBounds().getCopy();
            graphics.setBackgroundColor(ColorConstants.lightGray);
            Color color = gradient1 = this.isReadOnly ? this.gradientColor[1] : headerColor;
            if (this.isSelected && this.isReadOnly) {
                gradient1 = this.gradientColor[3];
            } else if (this.isSelected && !this.isReadOnly) {
                gradient1 = this.gradientColor[2];
            }
            Color gradient2 = this.gradientColor[0];
            graphics.setForegroundColor(gradient1);
            graphics.setBackgroundColor(gradient2);
            Rectangle labelBounds = this.label.getBounds();
            graphics.fillGradient(r.x + 1, r.y + 1, r.width - 2, labelBounds.height - 2, true);
            graphics.setForegroundColor(ColorConstants.darkGray);
            this.label.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            graphics.popState();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        graphics.popState();
    }

    public Label getLabel() {
        return this.label;
    }
}

