/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.model;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TextGridObject;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class TGOentry
implements IAdaptable {
    private Aggregation parent;
    private TextGridObject tgo = null;
    private boolean latest = true;
    private TextGridObject revision = null;
    private RestrictedTextGridObject rtgo = null;

    public TGOentry(String uri) {
        URI tgouri = null;
        try {
            tgouri = new URI(uri);
        }
        catch (URISyntaxException e) {
            AggregationsUIPlugin.handleError(e, "Aggregation Composer Error.", new Object[0]);
        }
        this.tgo = TextGridObject.getInstanceOffline((URI)tgouri);
    }

    public TGOentry(RestrictedTextGridObject rtgo) {
        this.rtgo = rtgo;
    }

    public Aggregation getParent() {
        return this.parent;
    }

    public void setParent(Aggregation newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
    }

    public String getTitle() throws CoreException {
        if (this.tgo != null) {
            return this.tgo.getTitle();
        }
        return String.valueOf(RestrictedTextGridObject.TITLE) + " (" + this.rtgo.getURI() + ")";
    }

    public TextGridObject getTgo() {
        return this.tgo;
    }

    public void delete() {
        this.parent.removeChild(this);
        this.setParent(null);
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    public boolean getLatest() {
        return this.latest;
    }

    public TextGridObject getRevision() {
        return this.revision;
    }

    public void setRevision(TextGridObject revision) {
        this.revision = revision;
    }

    public boolean isRestrictedTextGridObject() {
        return this.rtgo != null;
    }

    public RestrictedTextGridObject getRestrictedTgo() {
        return this.rtgo;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TextGridObject.class) {
            return this.tgo;
        }
        return null;
    }
}

