/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.util.ArrayList;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class FontFamilyProperty
extends AbstractProperty {
    private static final String[] DEFAULT_FONT_FAMILY = new String[]{"sans-serif"};

    public FontFamilyProperty() {
        super("font-family");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (FontFamilyProperty.isFontFamily(lu)) {
            return FontFamilyProperty.getFontFamilies(lu);
        }
        if (parentStyles != null) {
            return parentStyles.getFontFamilies();
        }
        return DEFAULT_FONT_FAMILY;
    }

    private static boolean isFontFamily(LexicalUnit lu) {
        return lu != null && (lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 35);
    }

    private static String[] getFontFamilies(LexicalUnit lu) {
        ArrayList<String> list = new ArrayList<String>();
        while (lu != null) {
            if (lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 35) {
                list.add(lu.getStringValue());
            }
            lu = lu.getNextLexicalUnit();
        }
        return list.toArray(new String[list.size()]);
    }
}

