/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.vex.core.Insets;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.LayoutContext;

public class BinTree
extends AbstractBlockBox {
    private boolean content = false;

    @Override
    protected List createChildren(LayoutContext context) {
        Box[] newChildren = (Box[])this.children.clone();
        return Arrays.asList(newChildren);
    }

    public BinTree(List<BlockBox> boxes, LayoutContext context, BlockBox parent, IVexElement element) {
        super(context, parent, null);
        if (boxes.size() <= 0) {
            this.children = new Box[0];
            return;
        }
        this.startPosition = context.getDocument().createPosition(context.getDocument().getLength());
        this.endPosition = context.getDocument().createPosition(0);
        if (boxes.size() == 1) {
            BlockBox topChild = boxes.get(0);
            topChild.setParent(this);
            this.children = new Box[]{topChild};
            if (topChild.hasContent()) {
                this.backPropagateAttributes(context, topChild.getStartOffset(), topChild.getEndOffset(), topChild.hasContent());
            }
            return;
        }
        int splitIndex = boxes.size() / 2;
        BinTree topChild = new BinTree(boxes.subList(0, splitIndex), context, this, element);
        BinTree bottomChild = new BinTree(boxes.subList(splitIndex, boxes.size()), context, this, element);
        this.children = new Box[]{topChild, bottomChild};
    }

    void backPropagateAttributes(LayoutContext context, int startOffset, int endOffset, boolean hasContent) {
        boolean bl = this.content = this.content || hasContent;
        if (this.startPosition.getOffset() > startOffset) {
            this.startPosition = context.getDocument().createPosition(startOffset);
            if (this.getParent() instanceof BinTree) {
                ((BinTree)this.getParent()).backPropagateAttributes(context, startOffset, endOffset, this.content);
            }
        }
        if (this.endPosition.getOffset() < endOffset) {
            this.endPosition = context.getDocument().createPosition(endOffset);
            if (this.getParent() instanceof BinTree) {
                ((BinTree)this.getParent()).backPropagateAttributes(context, startOffset, endOffset, this.content);
            }
        }
    }

    @Override
    public int getStartOffset() {
        return this.startPosition.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.endPosition.getOffset();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    public String toString() {
        String s = "BinTree (" + this.getStartOffset() + ", " + this.getEndOffset() + ", " + this.content + ")" + "[";
        Box[] boxArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Box b = boxArray[n2];
            s = String.valueOf(s) + b.toString() + " ,";
            ++n2;
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return Insets.ZERO_INSETS;
    }

    public List<BlockBox> toList() {
        ArrayList<BlockBox> list = new ArrayList<BlockBox>();
        Box[] boxArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Box c = boxArray[n2];
            if (c instanceof BinTree) {
                list.addAll(((BinTree)c).toList());
            } else if (c instanceof BlockBox) {
                list.add((BlockBox)c);
            } else {
                throw new IllegalStateException("A BinTree should only have children of type BlockBox!");
            }
            ++n2;
        }
        return list;
    }

    @Override
    public Box getFirstChild() {
        if (this.children.length == 0) {
            return null;
        }
        if (this.children[0] instanceof BinTree) {
            return ((BinTree)this.children[0]).getFirstChild();
        }
        return this.children[0];
    }

    @Override
    public boolean hasContent() {
        return this.content;
    }
}

