/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.widget;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.vex.core.Caret;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.EditorOptions;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.StyleSheetReader;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.DocumentEvent;
import net.sf.vex.dom.DocumentListener;
import net.sf.vex.dom.DocumentReader;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import net.sf.vex.dom.Position;
import net.sf.vex.dom.Validator;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.BoxAndOffset;
import net.sf.vex.layout.BoxFactory;
import net.sf.vex.layout.CssBoxFactory;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.RootBox;
import net.sf.vex.layout.VexAnnotationTracker;
import net.sf.vex.undo.CannotRedoException;
import net.sf.vex.undo.CannotUndoException;
import net.sf.vex.undo.CompoundEdit;
import net.sf.vex.undo.IUndoableEdit;
import net.sf.vex.widget.CssWhitespacePolicy;
import net.sf.vex.widget.HostComponent;
import net.sf.vex.widget.IBoxFilter;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xml.sax.SAXException;

public class VexWidgetImpl
implements IVexWidget {
    private static final int LAYOUT_WINDOW = 5000;
    private static final int LAYOUT_TOLERANCE = 500;
    private static final int MIN_LAYOUT_WIDTH = 200;
    private boolean debugging;
    private HostComponent hostComponent;
    private int layoutWidth = 500;
    private IVexDocument document;
    private StyleSheet styleSheet;
    private BoxFactory boxFactory = new CssBoxFactory();
    private final Map<IVexElement, Boolean> collapsed = new WeakHashMap<IVexElement, Boolean>();
    private RootBox rootBox;
    private LinkedList undoList = new LinkedList();
    private LinkedList redoList = new LinkedList();
    private static final int MAX_UNDO_STACK_SIZE = 100;
    private int undoDepth;
    private int beginWorkCount = 0;
    private int beginWorkCaretOffset;
    private CompoundEdit compoundEdit;
    private int caretOffset;
    private int mark;
    private int selectionStart;
    private int selectionEnd;
    private IVexElement currentElement;
    private boolean caretVisible = true;
    private Caret caret;
    private Color caretColor;
    private int magicX = -1;
    private boolean antiAliased = false;
    private Rectangle debugRect = null;
    private final UIJob relayoutJob = new UIJob("Adjusting WYSIWYM layout"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (VexWidgetImpl.this.beginWorkCount == 0) {
                VexWidgetImpl.this.relayout();
            }
            return Status.OK_STATUS;
        }
    };
    private DocumentListener documentListener = new WidgetDocumentListener();
    private EditorOptions editorOptions = new EditorOptions();
    private LinkedNode currentNode = null;
    private String inputErrorMessage;
    private VexAnnotationTracker annotationTracker;
    private IProgressMonitor progressMonitor;

    public VexWidgetImpl(HostComponent hostComponent) {
        this.hostComponent = hostComponent;
    }

    @Override
    public void beginWork() {
        if (this.beginWorkCount == 0) {
            this.beginWorkCaretOffset = this.getCaretOffset();
            this.compoundEdit = new CompoundEdit();
        }
        ++this.beginWorkCount;
    }

    public boolean canInsertFragment(IVexDocumentFragment frag) {
        IVexDocument doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Validator validator = doc.getValidator();
        if (validator == null) {
            return true;
        }
        int startOffset = this.getCaretOffset();
        int endOffset = this.getCaretOffset();
        if (this.hasSelection()) {
            startOffset = this.getSelectionStart();
            endOffset = this.getSelectionEnd();
        }
        IVexElement parent = this.getDocument().getElementAt(startOffset);
        String[] seq1 = doc.getNodeNames(parent.getStartOffset() + 1, startOffset);
        String[] seq2 = frag.getNodeNames();
        String[] seq3 = doc.getNodeNames(endOffset, parent.getEndOffset());
        return validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true);
    }

    public boolean canInsertText() {
        IVexDocument doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Validator validator = this.document.getValidator();
        if (validator == null) {
            return true;
        }
        int startOffset = this.getCaretOffset();
        int endOffset = this.getCaretOffset();
        if (this.hasSelection()) {
            startOffset = this.getSelectionStart();
            endOffset = this.getSelectionEnd();
        }
        IVexElement parent = this.getDocument().getElementAt(startOffset);
        String[] seq1 = doc.getNodeNames(parent.getStartOffset() + 1, startOffset);
        String[] seq2 = new String[]{"#PCDATA"};
        String[] seq3 = doc.getNodeNames(endOffset, parent.getEndOffset());
        return validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true);
    }

    @Override
    public boolean canPaste() {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public boolean canPasteText() {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public boolean canRedo() {
        return this.redoList.size() > 0;
    }

    @Override
    public boolean canUndo() {
        return this.undoList.size() > 0;
    }

    @Override
    public boolean canUnwrap() {
        IVexDocument doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Validator validator = doc.getValidator();
        if (validator == null) {
            return false;
        }
        IVexElement element = doc.getElementAt(this.getCaretOffset());
        IVexElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        String[] seq1 = doc.getNodeNames(parent.getStartOffset() + 1, element.getStartOffset());
        String[] seq2 = doc.getNodeNames(element.getStartOffset() + 1, element.getEndOffset());
        String[] seq3 = doc.getNodeNames(element.getEndOffset() + 1, parent.getEndOffset());
        return validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true);
    }

    @Override
    public void copySelection() {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public void cutSelection() {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public void deleteNextChar() throws DocumentValidationException {
        if (this.hasSelection()) {
            this.deleteSelection();
        } else {
            int offset = this.getCaretOffset();
            IVexDocument doc = this.getDocument();
            int n = doc.getLength() - 1;
            IVexElement element = doc.getElementAt(offset);
            if (offset != n) {
                if (this.isBetweenMatchingElements(offset)) {
                    this.joinElementsAt(offset);
                } else if (this.isBetweenMatchingElements(offset + 1)) {
                    this.joinElementsAt(offset + 1);
                } else if (element.isEmpty()) {
                    this.moveTo(offset - 1, false);
                    this.moveTo(offset + 1, true);
                    this.deleteSelection();
                } else if (doc.getElementAt(offset + 1).isEmpty()) {
                    this.moveTo(offset + 2, true);
                    this.deleteSelection();
                } else if (doc.getCharacterAt(offset) != '\u0000') {
                    this.moveTo(offset, false);
                    this.moveTo(offset + 1, true);
                    this.deleteSelection();
                }
            }
        }
    }

    @Override
    public void deletePreviousChar() throws DocumentValidationException {
        if (this.hasSelection()) {
            this.deleteSelection();
        } else {
            int offset = this.getCaretOffset();
            IVexDocument doc = this.getDocument();
            IVexElement element = doc.getElementAt(offset);
            if (offset != 1) {
                if (this.isBetweenMatchingElements(offset)) {
                    this.joinElementsAt(offset);
                } else if (this.isBetweenMatchingElements(offset - 1)) {
                    this.joinElementsAt(offset - 1);
                } else if (element.isEmpty()) {
                    this.moveTo(offset - 1, false);
                    this.moveTo(offset + 1, true);
                    this.deleteSelection();
                } else if (doc.getElementAt(offset - 1).isEmpty()) {
                    this.moveTo(offset - 2, true);
                    this.deleteSelection();
                } else if (doc.getCharacterAt(--offset) != '\u0000') {
                    this.moveTo(offset, false);
                    this.moveTo(offset + 1, true);
                    this.deleteSelection();
                }
            }
        }
    }

    @Override
    public void deleteSelection() {
        try {
            if (this.hasSelection()) {
                this.document.delete(this.getSelectionStart(), this.getSelectionEnd());
                this.relayout();
                this.moveTo(this.getSelectionStart());
            }
        }
        catch (DocumentValidationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void doWork(Runnable runnable) {
        this.doWork(false, runnable);
    }

    @Override
    public void doWork(boolean savePosition, Runnable runnable) {
        Position position = null;
        if (savePosition) {
            position = this.getDocument().createPosition(this.getCaretOffset());
        }
        boolean success = false;
        try {
            try {
                this.beginWork();
                runnable.run();
                success = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.endWork(success);
                if (position != null) {
                    this.moveTo(position.getOffset());
                }
            }
        }
        finally {
            this.endWork(success);
            if (position != null) {
                this.moveTo(position.getOffset());
            }
        }
    }

    @Override
    public void endWork(boolean success) {
        --this.beginWorkCount;
        if (this.beginWorkCount == 0) {
            if (success) {
                this.undoList.add(new UndoableAndOffset(this.compoundEdit, this.beginWorkCaretOffset));
                ++this.undoDepth;
                if (this.undoList.size() > 100) {
                    this.undoList.removeFirst();
                }
                this.redoList.clear();
                this.relayout();
                this.hostComponent.fireSelectionChanged();
            } else {
                try {
                    this.compoundEdit.undo();
                    this.moveTo(this.beginWorkCaretOffset);
                }
                catch (CannotUndoException cannotUndoException) {}
            }
            this.compoundEdit = null;
        }
    }

    @Override
    public Box findInnermostBox(IBoxFilter filter) {
        return this.findInnermostBox(filter, this.getCaretOffset());
    }

    private Box findInnermostBox(IBoxFilter filter, int offset) {
        Box original;
        Box box = this.rootBox.getChildren()[0];
        Box matchingBox = null;
        block0: do {
            if (filter.matches(box)) {
                matchingBox = box;
            }
            original = box;
            Box[] children = box.getChildren();
            int i = 0;
            while (i < children.length) {
                Box child = children[i];
                if (child.hasContent() && offset >= child.getStartOffset() && offset <= child.getEndOffset()) {
                    box = child;
                    continue block0;
                }
                ++i;
            }
        } while (box != original);
        return matchingBox;
    }

    public Color getBackgroundColor() {
        if (this.document == null) {
            return new Color(255, 255, 255);
        }
        IVexElement rootElement = this.document.getRootElement();
        Styles styles = this.styleSheet.getStyles(rootElement);
        return styles.getBackgroundColor();
    }

    @Override
    public BoxFactory getBoxFactory() {
        return this.boxFactory;
    }

    public Caret getCaret() {
        return this.caret;
    }

    @Override
    public int getCaretOffset() {
        return this.caretOffset;
    }

    @Override
    public IVexElement getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public IVexDocument getDocument() {
        return this.document;
    }

    public int getHeight() {
        return this.rootBox.getHeight();
    }

    @Override
    public String[] getValidInsertElements() {
        IVexDocument doc = this.getDocument();
        if (doc == null) {
            return new String[0];
        }
        Validator validator = doc.getValidator();
        if (validator == null) {
            return new String[0];
        }
        int startOffset = this.getCaretOffset();
        int endOffset = this.getCaretOffset();
        if (this.hasSelection()) {
            startOffset = this.getSelectionStart();
            endOffset = this.getSelectionEnd();
        }
        IVexElement parent = doc.getElementAt(startOffset);
        String[] prefix = doc.getNodeNames(parent.getStartOffset() + 1, startOffset);
        String[] suffix = doc.getNodeNames(endOffset, parent.getEndOffset());
        ArrayList candidates = new ArrayList();
        candidates.addAll(validator.getValidItems(parent.getName(), prefix, suffix));
        candidates.remove("#PCDATA");
        if (this.hasSelection()) {
            String[] selectedNodes = doc.getNodeNames(startOffset, endOffset);
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                String candidate = (String)iter.next();
                if (validator.isValidSequence(candidate, selectedNodes, true)) continue;
                iter.remove();
            }
        }
        Collections.sort(candidates);
        return candidates.toArray(new String[candidates.size()]);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    @Override
    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public String[] getValidMorphElements() {
        IVexDocument doc = this.getDocument();
        if (doc == null) {
            return new String[0];
        }
        Validator validator = doc.getValidator();
        if (validator == null) {
            return new String[0];
        }
        IVexElement element = doc.getElementAt(this.getCaretOffset());
        IVexElement parent = element.getParent();
        if (parent == null) {
            return new String[0];
        }
        String[] prefix = doc.getNodeNames(parent.getStartOffset() + 1, element.getStartOffset());
        String[] suffix = doc.getNodeNames(element.getEndOffset() + 1, parent.getEndOffset());
        ArrayList candidates = new ArrayList();
        candidates.addAll(validator.getValidItems(parent.getName(), prefix, suffix));
        candidates.remove("#PCDATA");
        String[] content = doc.getNodeNames(element.getStartOffset() + 1, element.getEndOffset());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            String candidate = (String)iter.next();
            if (validator.isValidSequence(candidate, content, true)) continue;
            iter.remove();
        }
        Collections.sort(candidates);
        return candidates.toArray(new String[candidates.size()]);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    @Override
    public int getSelectionStart() {
        return this.selectionStart;
    }

    @Override
    public IVexDocumentFragment getSelectedFragment() {
        if (this.hasSelection()) {
            return this.document.getFragment(this.getSelectionStart(), this.getSelectionEnd());
        }
        return null;
    }

    @Override
    public String getSelectedText() {
        if (this.hasSelection()) {
            return this.document.getText(this.getSelectionStart(), this.getSelectionEnd());
        }
        return "";
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public int getUndoDepth() {
        return this.undoDepth;
    }

    @Override
    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    public RootBox getRootBox() {
        return this.rootBox;
    }

    @Override
    public boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    @Override
    public void insertChar(char c) throws DocumentValidationException {
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        if (Character.isWhitespace(c) && !this.currentElement.isPre() && (this.getCaretOffset() > 0 && Character.isWhitespace(this.document.getCharacterAt(this.getCaretOffset() - 1)) || Character.isWhitespace(this.document.getCharacterAt(this.getCaretOffset())))) {
            this.setInputErrorMessage("Consecutive space characters are only possible in elements styled as preformatted.");
            return;
        }
        this.document.insertText(this.getCaretOffset(), Character.toString(c));
        this.moveBy(1);
        this.setInputErrorMessage(null);
    }

    protected void setInputErrorMessage(String message) {
        if (message == null && this.inputErrorMessage == null) {
            return;
        }
        IStatusLineManager statusLineManager = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
        statusLineManager.setErrorMessage(message);
        this.inputErrorMessage = message;
    }

    @Override
    public void insertFragment(IVexDocumentFragment frag) throws DocumentValidationException {
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        this.document.insertFragment(this.getCaretOffset(), frag);
        this.relayout();
        this.moveTo(this.getCaretOffset() + frag.getLength());
    }

    @Override
    public void insertElement(IVexElement element) throws DocumentValidationException {
        boolean success = false;
        try {
            this.beginWork();
            IVexDocumentFragment frag = null;
            if (this.hasSelection()) {
                frag = this.getSelectedFragment();
                this.deleteSelection();
            }
            this.document.insertElement(this.getCaretOffset(), element);
            this.relayout();
            this.moveTo(this.getCaretOffset() + 1);
            if (frag != null) {
                this.insertFragment(frag);
            }
            this.relayout();
            this.scrollCaretVisible();
            success = true;
        }
        finally {
            this.endWork(success);
        }
    }

    @Override
    public void insertText(String text) throws DocumentValidationException {
        if (this.hasSelection()) {
            this.deleteSelection();
        }
        boolean success = false;
        try {
            int j;
            this.beginWork();
            int i = 0;
            while ((j = text.indexOf(10, i)) != -1) {
                this.document.insertText(this.getCaretOffset(), text.substring(i, j));
                this.moveTo(this.getCaretOffset() + (j - i));
                this.split();
                i = j + 1;
            }
            if (i < text.length()) {
                this.document.insertText(this.getCaretOffset(), text.substring(i));
                this.moveTo(this.getCaretOffset() + (text.length() - i));
            }
            success = true;
        }
        finally {
            this.endWork(success);
        }
    }

    @Override
    public void morph(IVexElement element) throws DocumentValidationException {
        int offset;
        IVexDocument doc = this.getDocument();
        IVexElement currentElement = doc.getElementAt(offset = this.getCaretOffset());
        if (currentElement == doc.getRootElement()) {
            throw new DocumentValidationException("Cannot morph the root element.");
        }
        boolean success = false;
        try {
            this.beginWork();
            this.moveTo(currentElement.getStartOffset() + 1, false);
            this.moveTo(currentElement.getEndOffset(), true);
            IVexDocumentFragment frag = this.getSelectedFragment();
            this.deleteSelection();
            this.moveBy(-1, false);
            this.moveBy(2, true);
            this.deleteSelection();
            this.insertElement(element);
            if (frag != null) {
                this.insertFragment(frag);
            }
            this.moveTo(offset, false);
            success = true;
        }
        finally {
            this.endWork(success);
        }
    }

    @Override
    public void moveBy(int distance) {
        this.moveBy(distance, false);
    }

    @Override
    public void moveBy(int distance, boolean select) {
        int offset = this.getCaretOffset();
        IVexDocument doc = this.getDocument();
        int destination = offset + distance;
        char[] chars = new char[]{doc.getCharacterAt(destination - 1), doc.getCharacterAt(destination)};
        if (Character.codePointCount(chars, 0, 2) == 2) {
            this.moveTo(destination, select);
        } else {
            this.moveTo(destination += Integer.signum(distance), select);
        }
    }

    @Override
    public void moveTo(int offset) {
        this.moveTo(offset, false);
    }

    @Override
    public void moveTo(int offset, boolean select) {
        if (offset >= 1 && offset <= this.document.getLength() - 1) {
            IVexDocument doc = this.getDocument();
            char[] chars = new char[]{doc.getCharacterAt(offset - 1), doc.getCharacterAt(offset)};
            if (Character.codePointCount(chars, 0, 2) < 2) {
                ++offset;
            }
            this.repaintCaret();
            this.repaintRange(this.getSelectionStart(), this.getSelectionEnd());
            IVexElement oldElement = this.currentElement;
            this.caretOffset = offset;
            if (this.document instanceof LinkedDocument) {
                this.currentNode = ((LinkedDocument)this.document).getNodeAt(offset);
                this.currentElement = this.currentNode instanceof IVexElement ? (IVexElement)((Object)this.currentNode) : (IVexElement)((Object)this.currentNode.getParent());
            } else {
                this.currentElement = this.document.getElementAt(offset);
            }
            if (select) {
                this.selectionStart = Math.min(this.mark, this.caretOffset);
                this.selectionEnd = Math.max(this.mark, this.caretOffset);
                IVexElement commonElement = this.document.findCommonElement(this.selectionStart, this.selectionEnd);
                IVexElement element = this.document.getElementAt(this.selectionStart);
                while (element != commonElement) {
                    this.selectionStart = element.getStartOffset();
                    element = this.document.getElementAt(this.selectionStart);
                }
                element = this.document.getElementAt(this.selectionEnd);
                while (element != commonElement) {
                    this.selectionEnd = element.getEndOffset() + 1;
                    element = this.document.getElementAt(this.selectionEnd);
                }
            } else {
                this.mark = offset;
                this.selectionStart = offset;
                this.selectionEnd = offset;
            }
            if (this.beginWorkCount == 0) {
                this.relayout();
            }
            Graphics g = this.hostComponent.createDefaultGraphics();
            LayoutContext context = this.createLayoutContext(g);
            this.caret = this.rootBox.getCaret(context, offset);
            IVexElement element = this.getCurrentElement();
            if (element != oldElement) {
                this.caretColor = Color.BLACK;
                while (element != null) {
                    Color bgColor = this.styleSheet.getStyles(element).getBackgroundColor();
                    if (bgColor != null) {
                        int red = ~bgColor.getRed() & 0xFF;
                        int green = ~bgColor.getGreen() & 0xFF;
                        int blue = ~bgColor.getBlue() & 0xFF;
                        this.caretColor = new Color(red, green, blue);
                        break;
                    }
                    element = element.getParent();
                }
            }
            g.dispose();
            this.magicX = -1;
            this.scrollCaretVisible();
            this.hostComponent.fireSelectionChanged();
            this.caretVisible = true;
            this.repaintRange(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    @Override
    public LinkedNode getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void moveToLineEnd(boolean select) {
        this.moveTo(this.rootBox.getLineEndOffset(this.getCaretOffset()), select);
    }

    @Override
    public void moveToLineStart(boolean select) {
        this.moveTo(this.rootBox.getLineStartOffset(this.getCaretOffset()), select);
    }

    @Override
    public void moveToNextLine(boolean select) {
        int x = this.magicX == -1 ? this.caret.getBounds().getX() : this.magicX;
        Graphics g = this.hostComponent.createDefaultGraphics();
        int offset = this.rootBox.getNextLineOffset(this.createLayoutContext(g), this.getCaretOffset(), x);
        g.dispose();
        this.moveTo(offset, select);
        this.magicX = x;
    }

    @Override
    public void moveToNextPage(boolean select) {
        int x = this.magicX == -1 ? this.caret.getBounds().getX() : this.magicX;
        int y = this.caret.getY() + Math.round((float)this.hostComponent.getViewport().getHeight() * 0.9f);
        this.moveTo(this.viewToModel(x, y), select);
        this.magicX = x;
    }

    @Override
    public void moveToNextWord(boolean select) {
        IVexDocument doc = this.getDocument();
        int n = doc.getLength() - 1;
        int offset = this.getCaretOffset();
        while (offset < n && !Character.isLetterOrDigit(doc.getCharacterAt(offset))) {
            ++offset;
        }
        while (offset < n && Character.isLetterOrDigit(doc.getCharacterAt(offset))) {
            ++offset;
        }
        this.moveTo(offset, select);
    }

    @Override
    public void moveToPreviousLine(boolean select) {
        int x = this.magicX == -1 ? this.caret.getBounds().getX() : this.magicX;
        Graphics g = this.hostComponent.createDefaultGraphics();
        int offset = this.rootBox.getPreviousLineOffset(this.createLayoutContext(g), this.getCaretOffset(), x);
        g.dispose();
        this.moveTo(offset, select);
        this.magicX = x;
    }

    @Override
    public void moveToPreviousPage(boolean select) {
        int x = this.magicX == -1 ? this.caret.getBounds().getX() : this.magicX;
        int y = this.caret.getY() - Math.round((float)this.hostComponent.getViewport().getHeight() * 0.9f);
        this.moveTo(this.viewToModel(x, y), select);
        this.magicX = x;
    }

    @Override
    public void moveToPreviousWord(boolean select) {
        IVexDocument doc = this.getDocument();
        int offset = this.getCaretOffset();
        while (offset > 1 && !Character.isLetterOrDigit(doc.getCharacterAt(offset - 1))) {
            --offset;
        }
        while (offset > 1 && Character.isLetterOrDigit(doc.getCharacterAt(offset - 1))) {
            --offset;
        }
        this.moveTo(offset, select);
    }

    public void paint(Graphics g, int x, int y) {
        if (this.rootBox == null) {
            return;
        }
        LayoutContext context = this.createLayoutContext(g);
        Rectangle rect = g.getClipBounds();
        int oldHeight = this.rootBox.getHeight();
        this.rootBox.layout(context, rect.getY(), rect.getY() + rect.getHeight());
        if (this.rootBox.getHeight() != oldHeight) {
            this.hostComponent.setPreferredSize(this.rootBox.getWidth(), this.rootBox.getHeight());
        }
        try {
            this.rootBox.paint(context, 0, 0, rect);
        }
        catch (IllegalStateException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "net.sf.vex.toolkit", MessageFormat.format("Layout is in an illegal state: {0}.\nPerforming a re-layout.", e.getMessage()), (Throwable)e));
            this.rootBox.invalidate(true);
            this.relayout();
        }
        if (this.caretVisible) {
            this.caret.draw(g, this.caretColor);
        }
        if (this.debugRect != null) {
            ColorResource yellow = g.createColor(new Color(255, 255, 0));
            ColorResource oldColor = g.setColor(yellow);
            g.drawRect(this.debugRect.getX(), this.debugRect.getY(), this.debugRect.getWidth(), this.debugRect.getHeight());
            int i = 0;
            while (i < this.debugRect.getHeight()) {
                g.drawLine(this.debugRect.getX(), this.debugRect.getY() + i, this.debugRect.getX() + this.debugRect.getWidth(), this.debugRect.getY() + i);
                i += 2;
            }
            g.setColor(oldColor);
            yellow.dispose();
        }
    }

    @Override
    public void paste() throws DocumentValidationException {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public void pasteText() throws DocumentValidationException {
        throw new UnsupportedOperationException("Must be implemented in tookit-specific widget.");
    }

    @Override
    public void redo() {
        if (this.redoList.size() == 0) {
            throw new CannotRedoException();
        }
        UndoableAndOffset event = (UndoableAndOffset)this.redoList.removeLast();
        this.moveTo(event.caretOffset, false);
        event.edit.redo();
        this.undoList.add(event);
        ++this.undoDepth;
    }

    @Override
    public void removeAttribute(String attributeName) {
        try {
            IVexElement element = this.getCurrentElement();
            if (element.getAttribute(attributeName) != null) {
                element.removeAttribute(attributeName);
            }
        }
        catch (DocumentValidationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void savePosition(Runnable runnable) {
        Position pos = this.getDocument().createPosition(this.getCaretOffset());
        try {
            runnable.run();
        }
        finally {
            this.moveTo(pos.getOffset());
        }
    }

    @Override
    public void selectAll() {
        this.moveTo(1);
        this.moveTo(this.getDocument().getLength() - 1, true);
    }

    @Override
    public void selectWord() {
        IVexDocument doc = this.getDocument();
        int startOffset = this.getCaretOffset();
        int endOffset = this.getCaretOffset();
        while (startOffset > 1 && Character.isLetterOrDigit(doc.getCharacterAt(startOffset - 1))) {
            --startOffset;
        }
        int n = doc.getLength() - 1;
        while (endOffset < n && Character.isLetterOrDigit(doc.getCharacterAt(endOffset))) {
            ++endOffset;
        }
        if (startOffset < endOffset) {
            this.moveTo(startOffset, false);
            this.moveTo(endOffset, true);
        }
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
    }

    @Override
    public void setAttribute(String attributeName, String value) {
        try {
            IVexElement element = this.getCurrentElement();
            if (value == null) {
                this.removeAttribute(attributeName);
            } else if (!value.equals(element.getAttribute(attributeName))) {
                element.setAttribute(attributeName, value);
            }
        }
        catch (DocumentValidationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setBoxFactory(BoxFactory boxFactory) {
        this.boxFactory = boxFactory;
        if (this.document != null) {
            this.relayout();
        }
    }

    @Override
    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public void setDocument(IVexDocument document, StyleSheet styleSheet) {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = document;
        this.styleSheet = styleSheet;
        this.undoList = new LinkedList();
        this.undoDepth = 0;
        this.redoList = new LinkedList();
        this.beginWorkCount = 0;
        this.compoundEdit = null;
        this.createRootBox();
        this.moveTo(1);
        this.document.addDocumentListener(this.documentListener);
    }

    @Override
    public void setDocument(URL docUrl, URL ssURL) throws IOException, ParserConfigurationException, SAXException {
        StyleSheetReader ssReader = new StyleSheetReader();
        final StyleSheet ss = ssReader.read(ssURL);
        DocumentReader reader = new DocumentReader();
        reader.setWhitespacePolicyFactory(new IWhitespacePolicyFactory(){

            @Override
            public IWhitespacePolicy getPolicy(String publicId) {
                return new CssWhitespacePolicy(ss);
            }
        });
        IVexDocument doc = reader.read(docUrl);
        this.setDocument(doc, ss);
    }

    public void setFocus(boolean focus) {
        this.caretVisible = true;
        this.repaintCaret();
    }

    @Override
    public void setLayoutWidth(int width) {
        width = Math.max(width, 200);
        if (this.getDocument() != null && width != this.getLayoutWidth()) {
            this.relayoutAll(width, this.styleSheet);
        } else {
            this.layoutWidth = width;
        }
    }

    @Override
    public void setStyleSheet(StyleSheet styleSheet) {
        if (this.getDocument() != null) {
            this.relayoutAll(this.layoutWidth, styleSheet);
        }
    }

    @Override
    public void setStyleSheet(URL ssUrl) throws IOException {
        StyleSheetReader reader = new StyleSheetReader();
        StyleSheet ss = reader.read(ssUrl);
        this.setStyleSheet(ss);
    }

    @Override
    public void split() throws DocumentValidationException {
        long start = System.currentTimeMillis();
        IVexDocument doc = this.getDocument();
        IVexElement element = doc.getElementAt(this.getCaretOffset());
        Styles styles = this.getStyleSheet().getStyles(element);
        while (!styles.isBlock()) {
            element = element.getParent();
            styles = this.getStyleSheet().getStyles(element);
        }
        boolean success = false;
        try {
            this.beginWork();
            if (styles.getWhiteSpace().equalsIgnoreCase("pre")) {
                int offset = this.getCaretOffset();
                doc.insertText(offset, "\n");
                this.moveTo(offset + 1);
            } else {
                boolean atEnd;
                IVexDocumentFragment frag = null;
                int offset = this.getCaretOffset();
                boolean bl = atEnd = offset == element.getEndOffset();
                if (!atEnd) {
                    this.moveTo(element.getEndOffset(), true);
                    frag = this.getSelectedFragment();
                    this.deleteSelection();
                }
                this.moveTo(this.getCaretOffset() + 1);
                this.insertElement(new Element(element.getName()));
                if (!atEnd) {
                    offset = this.getCaretOffset();
                    this.insertFragment(frag);
                    this.moveTo(offset, false);
                }
            }
            success = true;
        }
        finally {
            this.endWork(success);
        }
        if (this.isDebugging()) {
            long end = System.currentTimeMillis();
            System.out.println("split() took " + (end - start) + "ms");
        }
    }

    public void toggleCaret() {
        this.caretVisible = !this.caretVisible;
        this.repaintCaret();
    }

    @Override
    public void undo() {
        if (this.undoList.size() == 0) {
            throw new CannotUndoException();
        }
        UndoableAndOffset event = (UndoableAndOffset)this.undoList.removeLast();
        --this.undoDepth;
        event.edit.undo();
        this.moveTo(event.caretOffset, false);
        this.redoList.add(event);
    }

    @Override
    public int viewToModel(int x, int y) {
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        int offset = this.rootBox.viewToModel(context, x, y);
        g.dispose();
        return offset;
    }

    private void addEdit(IUndoableEdit edit, int caretOffset) {
        if (edit == null) {
            return;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(edit);
        } else {
            if (this.undoList.size() > 0 && ((UndoableAndOffset)this.undoList.getLast()).edit.combine(edit)) {
                return;
            }
            this.undoList.add(new UndoableAndOffset(edit, caretOffset));
            ++this.undoDepth;
            if (this.undoList.size() > 100) {
                this.undoList.removeFirst();
            }
            this.redoList.clear();
        }
    }

    private LayoutContext createLayoutContext(Graphics g) {
        LayoutContext context = new LayoutContext();
        context.setBoxFactory(this.getBoxFactory());
        context.setDocument(this.getDocument());
        context.setGraphics(g);
        context.setStyleSheet(this.getStyleSheet());
        context.setEditorOptions(this.editorOptions);
        if (this.annotationTracker == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", "Initializing layout context but don't have a VexAnnotationTracker yet!?", (Throwable)new IllegalStateException()));
        } else {
            context.setAnnotationTracker(this.annotationTracker);
        }
        context.setProgressMonitor(this.progressMonitor);
        if (this.hasSelection()) {
            context.setSelectionStart(this.getSelectionStart());
            context.setSelectionEnd(this.getSelectionEnd());
        } else {
            context.setSelectionStart(this.getCaretOffset());
            context.setSelectionEnd(this.getCaretOffset());
        }
        context.setCollapsedList(this.collapsed);
        return context;
    }

    private void createRootBox() {
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        this.rootBox = new RootBox(context, this.document.getRootElement(), this.getLayoutWidth(), this);
        g.dispose();
    }

    private void invalidateElementBox(final IVexElement element) {
        BlockBox elementBox = (BlockBox)this.findInnermostBox(new IBoxFilter(){

            @Override
            public boolean matches(Box box) {
                return box instanceof BlockBox && box.getElement() != null && box.getStartOffset() <= element.getStartOffset() + 1 && box.getEndOffset() >= element.getEndOffset();
            }
        });
        if (elementBox != null) {
            elementBox.invalidate(true);
        }
    }

    private boolean isBetweenMatchingElements(int offset) {
        IVexElement e2;
        if (offset <= 1 || offset >= this.getDocument().getLength() - 1) {
            return false;
        }
        IVexElement e1 = this.getDocument().getElementAt(offset - 1);
        return e1 != (e2 = this.getDocument().getElementAt(offset + 1)) && e1.getParent() == e2.getParent() && e1.getName().equals(e2.getName());
    }

    private void iterateLayout(int offset) {
        Rectangle viewport;
        int oldLayoutY;
        int repaintStart = Integer.MAX_VALUE;
        int repaintEnd = 0;
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        int layoutY = this.rootBox.getCaret(context, offset).getY();
        do {
            oldLayoutY = layoutY;
            IntRange repaintRange = this.rootBox.layout(context, layoutY - 2500, layoutY + 2500);
            if (repaintRange == null) continue;
            repaintStart = Math.min(repaintStart, repaintRange.getStart());
            repaintEnd = Math.max(repaintEnd, repaintRange.getEnd());
        } while (Math.abs((layoutY = this.rootBox.getCaret(context, offset).getY()) - oldLayoutY) >= 500);
        g.dispose();
        if (repaintStart < repaintEnd && repaintStart < (viewport = this.hostComponent.getViewport()).getY() + viewport.getHeight() && repaintEnd > viewport.getY()) {
            int start = Math.max(repaintStart, viewport.getY());
            int end = Math.min(repaintEnd, viewport.getY() + viewport.getHeight());
            this.hostComponent.repaint(viewport.getX(), start, viewport.getWidth(), end - start);
        }
    }

    private void joinElementsAt(int offset) throws DocumentValidationException {
        if (!this.isBetweenMatchingElements(offset)) {
            throw new DocumentValidationException("Cannot join elements at offset " + offset);
        }
        boolean success = false;
        try {
            this.beginWork();
            this.moveTo(offset + 1);
            IVexElement element = this.getCurrentElement();
            boolean moveContent = !element.isEmpty();
            IVexDocumentFragment frag = null;
            if (moveContent) {
                this.moveTo(element.getEndOffset(), true);
                frag = this.getSelectedFragment();
                this.deleteSelection();
            }
            this.moveBy(-1);
            this.moveBy(2, true);
            this.deleteSelection();
            this.moveBy(-1);
            if (moveContent) {
                int savedOffset = this.getCaretOffset();
                this.insertFragment(frag);
                this.moveTo(savedOffset, false);
            }
            success = true;
        }
        finally {
            this.endWork(success);
        }
    }

    private void relayout() {
        long start = System.currentTimeMillis();
        int oldHeight = this.rootBox.getHeight();
        this.iterateLayout(this.getCaretOffset());
        if (this.rootBox.getHeight() != oldHeight) {
            this.hostComponent.setPreferredSize(this.rootBox.getWidth(), this.rootBox.getHeight());
        }
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        this.caret = this.rootBox.getCaret(context, this.getCaretOffset());
        g.dispose();
        if (this.isDebugging()) {
            long end = System.currentTimeMillis();
            System.out.println("VexWidget layout took " + (end - start) + "ms");
        }
    }

    private void relayoutAll(int newWidth, StyleSheet newStyleSheet) {
        int offset;
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        Rectangle viewport = this.hostComponent.getViewport();
        boolean caretVisible = viewport.intersects(this.caret.getBounds());
        int relCaretY = 0;
        if (caretVisible) {
            relCaretY = this.caret.getY() - viewport.getY();
            offset = this.getCaretOffset();
        } else {
            offset = this.rootBox.viewToModel(context, 0, viewport.getY());
        }
        this.layoutWidth = newWidth;
        this.styleSheet = newStyleSheet;
        context = this.createLayoutContext(g);
        this.createRootBox();
        this.iterateLayout(offset);
        this.hostComponent.setPreferredSize(this.rootBox.getWidth(), this.rootBox.getHeight());
        this.caret = this.rootBox.getCaret(context, this.getCaretOffset());
        if (caretVisible) {
            int viewportY = this.caret.getY() - Math.min(relCaretY, viewport.getHeight());
            viewportY = Math.min(this.rootBox.getHeight() - viewport.getHeight(), viewportY);
            viewportY = Math.max(0, viewportY);
            this.hostComponent.scrollTo(viewport.getX(), viewportY);
            this.scrollCaretVisible();
        } else {
            int viewportY = this.rootBox.getCaret(context, offset).getY();
            this.hostComponent.scrollTo(viewport.getX(), viewportY);
        }
        this.hostComponent.repaint();
        g.dispose();
    }

    private void repaintCaret() {
        if (this.caret != null) {
            Rectangle bounds = this.caret.getBounds();
            this.hostComponent.repaint(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
    }

    private void repaintRange(int startOffset, int endOffset) {
        int bottom;
        Graphics g = this.hostComponent.createDefaultGraphics();
        LayoutContext context = this.createLayoutContext(g);
        Rectangle startBounds = this.rootBox.getCaret(context, startOffset).getBounds();
        int top1 = startBounds.getY();
        int bottom1 = top1 + startBounds.getHeight();
        Rectangle endBounds = this.rootBox.getCaret(context, endOffset).getBounds();
        int top2 = endBounds.getY();
        int bottom2 = top2 + endBounds.getHeight();
        int top = Math.min(top1, top2);
        if (top == (bottom = Math.max(bottom1, bottom2))) {
            this.hostComponent.repaint(0, top - 1, this.getLayoutWidth(), bottom - top + 1);
        } else {
            this.hostComponent.repaint(0, top, this.getLayoutWidth(), bottom - top);
        }
        g.dispose();
    }

    private void scrollCaretVisible() {
        Rectangle caretBounds = this.caret.getBounds();
        Rectangle viewport = this.hostComponent.getViewport();
        int x = viewport.getX();
        int y = 0;
        int offset = this.getCaretOffset();
        if (offset == 1) {
            y = 0;
        } else if (offset == this.getDocument().getLength() - 1) {
            y = this.rootBox.getHeight() < viewport.getHeight() ? 0 : this.rootBox.getHeight() - viewport.getHeight();
        } else if (caretBounds.getY() < viewport.getY()) {
            y = caretBounds.getY();
        } else if (caretBounds.getY() + caretBounds.getHeight() > viewport.getY() + viewport.getHeight()) {
            y = caretBounds.getY() + caretBounds.getHeight() - viewport.getHeight();
        } else {
            return;
        }
        this.hostComponent.scrollTo(x, y);
    }

    @Override
    public void reLayout() {
        if (this.rootBox != null) {
            this.getRootBox().invalidate(true);
            this.relayoutAll(this.layoutWidth, this.styleSheet);
        }
    }

    @Override
    public BoxAndOffset getBoxAt(int x, int y) {
        BoxAndOffset result = this.rootBox.getChildAt(x - this.rootBox.getX(), y - this.rootBox.getY());
        if (result != null) {
            result.x += this.rootBox.getX();
            result.y += this.rootBox.getY();
        }
        return result;
    }

    public void setDebugRect(Rectangle debugRect) {
        this.debugRect = debugRect;
    }

    public void repaint() {
        this.hostComponent.repaint();
    }

    @Override
    public EditorOptions getEditorOptions() {
        return this.editorOptions;
    }

    @Override
    public void selectSourceRegion(IRegion region) {
        if (!(this.getDocument() instanceof LinkedDocument)) {
            WrongModelException.throwIfNeeded(this.getDocument(), LinkedDocument.class);
        }
        IRegion contentRegion = ((LinkedDocument)this.getDocument()).contentRegionFor(region);
        this.moveTo(contentRegion.getOffset());
        this.moveBy(contentRegion.getLength(), true);
    }

    public void setAnnotationTracker(VexAnnotationTracker tracker) {
        this.annotationTracker = tracker;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    private class UndoableAndOffset {
        public IUndoableEdit edit;
        public int caretOffset;

        public UndoableAndOffset(IUndoableEdit edit, int caretOffset) {
            this.edit = edit;
            this.caretOffset = caretOffset;
        }
    }

    private final class WidgetDocumentListener
    implements DocumentListener {
        private WidgetDocumentListener() {
        }

        @Override
        public void attributeChanged(DocumentEvent e) {
            VexWidgetImpl.this.invalidateElementBox(e.getParentElement());
            VexWidgetImpl.this.getStyleSheet().flushStyles(e.getParentElement());
            if (VexWidgetImpl.this.beginWorkCount == 0) {
                VexWidgetImpl.this.relayout();
            }
            VexWidgetImpl.this.addEdit(e.getUndoableEdit(), VexWidgetImpl.this.getCaretOffset());
            VexWidgetImpl.this.hostComponent.fireSelectionChanged();
        }

        @Override
        public void beforeContentDeleted(DocumentEvent e) {
        }

        @Override
        public void beforeContentInserted(DocumentEvent e) {
        }

        @Override
        public void contentDeleted(DocumentEvent e) {
            VexWidgetImpl.this.invalidateElementBox(e.getParentElement());
            this.expandParents(e);
            if (VexWidgetImpl.this.beginWorkCount == 0) {
                VexWidgetImpl.this.relayout();
            }
            VexWidgetImpl.this.addEdit(e.getUndoableEdit(), VexWidgetImpl.this.getCaretOffset());
        }

        @Override
        public void contentInserted(DocumentEvent e) {
            VexWidgetImpl.this.invalidateElementBox(e.getParentElement());
            this.expandParents(e);
            if (VexWidgetImpl.this.beginWorkCount == 0) {
                VexWidgetImpl.this.relayout();
            }
            VexWidgetImpl.this.addEdit(e.getUndoableEdit(), VexWidgetImpl.this.getCaretOffset());
        }

        private void expandParents(DocumentEvent e) {
            LayoutContext lc = VexWidgetImpl.this.createLayoutContext(null);
            IVexElement element = e.getDocument().getElementAt(e.getOffset());
            do {
                lc.expand(element);
                if (element == e.getDocument().getRootElement()) continue;
                element = element.getParent();
            } while (element != e.getDocument().getRootElement());
        }

        @Override
        public void elementChanged(DocumentEvent event) {
            VexWidgetImpl.this.invalidateElementBox(event.getParentElement());
            if (VexWidgetImpl.this.relayoutJob.getState() == 0) {
                VexWidgetImpl.this.relayoutJob.schedule(50L);
            }
        }
    }
}

