/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.configurators;

import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.importexport.configurators.Messages;
import info.textgrid.lab.core.importexport.model.AbstractImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.model.TGContentType;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class XMLConfigurator
extends AbstractImportEntryConfigurator
implements IImportEntryConfigurator {
    private static final String TEI_NS = "http://www.tei-c.org/ns/1.0";
    private static final TGContentType XML_CONTENT_TYPE = TGContentType.of((String)"text/xml");
    private static final QName TEI_CORPUS = new QName("http://www.tei-c.org/ns/1.0", "teiCorpus");
    private static final QName TEI = new QName("http://www.tei-c.org/ns/1.0", "TEI");

    @Override
    public void configureImport(ImportEntry entry, IProgressMonitor monitor) {
        try {
            if (XML_CONTENT_TYPE.equals(entry.getObject().getContentType(false))) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.XMLConfigurator_AnalyzingXMLStructure, (Object)entry.getLocalFile()), (int)10);
                FileInputStream stream = new FileInputStream(entry.getLocalFile());
                this.analyzeStream(stream, entry, progress);
                stream.close();
                progress.done();
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.XMLConfigurator_ErrorAnalyzingXMLStructure, (Object)((Object)entry)), (Throwable)e));
        }
        catch (XMLStreamException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.XMLConfigurator_ErrorAnalyzingXMLStructure, (Object)((Object)entry)), (Throwable)e));
        }
    }

    private void analyzeStream(FileInputStream stream, ImportEntry entry, SubMonitor progress) throws FactoryConfigurationError, XMLStreamException {
        progress.worked(2);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader reader = factory.createXMLStreamReader(stream);
        progress.worked(2);
        reader.nextTag();
        progress.worked(4);
        QName rootElementName = reader.getName();
        if (TEI.equals(rootElementName) || TEI_CORPUS.equals(rootElementName)) {
            entry.setRewriteSetup(RewriteSetup.of(RewriteMethod.XML, "internal:tei#tei"));
        } else if (reader.getEncoding() != null && !"UTF-8".equalsIgnoreCase(reader.getEncoding())) {
            entry.setRewriteSetup(RewriteSetup.of(RewriteMethod.XML, "internal:textgrid#encoding"));
        }
        reader.close();
        progress.worked(2);
    }
}

