/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.vex.core.Color;
import net.sf.vex.core.EditorOptions;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockElementWidget;
import net.sf.vex.swt.VexWidget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class PreferenceChangeHandler
implements Preferences.IPropertyChangeListener {
    static PreferenceChangeHandler instance = new PreferenceChangeHandler();
    private Map<String, Method> handlerFunctions = new HashMap<String, Method>();

    public PreferenceChangeHandler() {
        this.registerFunction("ShowBlockMarkers", "setShowBlockMarkers");
        this.registerFunction("ShowInlineMarkers", "setShowInlineMarkers");
        this.registerFunction("InlineMarkerDisplay", "setInlineMarkerDisplay");
        this.registerFunction("BlockMarkerColor", "setBlockMarkerColor");
    }

    public void setAllPreferences() {
        for (String name : this.handlerFunctions.keySet()) {
            this.applyPreference(name, VexPlugin.getInstance().getPluginPreferences().getString(name));
        }
    }

    private void applyPreference(String preferenceName, Object preferenceValue) {
        if (this.handlerFunctions.containsKey(preferenceName)) {
            Object[] callParameters = new Object[]{preferenceValue};
            try {
                this.handlerFunctions.get(preferenceName).invoke((Object)this, callParameters);
            }
            catch (IllegalArgumentException e1) {
                this.throwImplException(e1);
            }
            catch (IllegalAccessException e1) {
                this.throwImplException(e1);
            }
            catch (InvocationTargetException e1) {
                this.throwImplException(e1);
            }
            for (VexEditor e : VexPlugin.getInstance().getRunningEditors()) {
                if (e.getVexWidget() == null) continue;
                e.getVexWidget().reLayout();
            }
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        event.getProperty();
        this.applyPreference(event.getProperty(), event.getNewValue());
    }

    private void registerFunction(String propertyName, String functionName) {
        try {
            this.handlerFunctions.put(propertyName, this.getClass().getMethod(functionName, Object.class));
        }
        catch (Exception e) {
            this.throwImplException(e);
        }
    }

    public static PreferenceChangeHandler getInstance() {
        return instance;
    }

    private void throwImplException(Exception e) {
        throw new RuntimeException("Implementation Error. Method misspelled?", e);
    }

    public void setShowBlockMarkers(Object value) {
        boolean newValue = Boolean.valueOf(value.toString());
        Iterator<VexEditor> i = VexPlugin.getInstance().getRunningEditors().iterator();
        while (i.hasNext()) {
            VexWidget widget = i.next().getVexWidget();
            if (widget == null) continue;
            widget.getEditorOptions().setShowBlockMarkers(newValue);
        }
    }

    public void setShowInlineMarkers(Object value) {
        boolean newValue = Boolean.valueOf(value.toString());
        for (VexEditor editor : VexPlugin.getInstance().getRunningEditors()) {
            VexWidget widget = editor.getVexWidget();
            if (widget == null) continue;
            EditorOptions options = widget.getEditorOptions();
            options.setShowInlineMarkers(newValue);
        }
    }

    public void setInlineMarkerDisplay(Object value) {
        block3: {
            Iterator<VexEditor> i;
            String newValue;
            block2: {
                newValue = value.toString();
                i = VexPlugin.getInstance().getRunningEditors().iterator();
                if (!newValue.equals("Labeled")) break block2;
                while (i.hasNext()) {
                    i.next().getVexWidget().getEditorOptions().setInlineMarkerStyle(EditorOptions.InlineMarkerStyle.Labeled);
                }
                break block3;
            }
            if (!newValue.equals("Unlabeled")) break block3;
            while (i.hasNext()) {
                i.next().getVexWidget().getEditorOptions().setInlineMarkerStyle(EditorOptions.InlineMarkerStyle.Unlabeled);
            }
        }
    }

    public void setBlockMarkerColor(Object value) {
        try {
            RGB rgb = StringConverter.asRGB((String)((String)value));
            Color color = new Color(rgb.red, rgb.green, rgb.blue);
            AbstractBlockBox.setMarkerColor((Color)color);
            BlockElementWidget.setBgColor((Color)color);
            BlockElementWidget.setFgColor((Color)new Color(255, 255, 255));
        }
        catch (DataFormatException e) {
            Status error = new Status(2, "net.sf.vex.editor", (value == null ? "null" : value) + " does not represent a valid RGB value.", (Throwable)e);
            VexPlugin.getInstance().getLog().log((IStatus)error);
        }
    }
}

