/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.Collections;
import java.util.List;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.IConfigListener;
import net.sf.vex.editor.config.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

public class ConfigurationView
extends ViewPart {
    private Composite parentControl;
    private Label loadingLabel;
    private TreeViewer treeViewer;
    private IConfigListener configListener = new IConfigListener(){

        @Override
        public void configChanged(ConfigEvent e) {
            ConfigurationView.this.treeViewer.refresh();
        }

        @Override
        public void configLoaded(ConfigEvent e) {
            ConfigurationView.this.loadingLabel.dispose();
            ConfigurationView.this.createTreeViewer();
            ConfigurationView.this.parentControl.layout();
        }
    };

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        ConfigRegistry registry = ConfigRegistry.getInstance();
        registry.addConfigListener(this.configListener);
        if (registry.isConfigLoaded()) {
            this.createTreeViewer();
        } else {
            this.loadingLabel = new Label(parent, 0);
            this.loadingLabel.setText(Messages.getString("ConfigurationView.loading"));
        }
    }

    public void dispose() {
        super.dispose();
        ConfigRegistry.getInstance().removeConfigListener(this.configListener);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    private void createTreeViewer() {
        this.treeViewer = new TreeViewer(this.parentControl, 4);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)ConfigRegistry.getInstance());
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IConfigItemFactory) {
                IConfigItemFactory factory = (IConfigItemFactory)parentElement;
                List items = ConfigRegistry.getInstance().getAllConfigItems(factory.getExtensionPointId());
                Collections.sort(items);
                return items.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ConfigItem) {
                ConfigItem item = (ConfigItem)element;
                return ConfigRegistry.getInstance().getConfigItemFactory(item.getExtensionPointId());
            }
            return ConfigRegistry.getInstance();
        }

        public boolean hasChildren(Object element) {
            return element instanceof IConfigItemFactory;
        }

        public Object[] getElements(Object inputElement) {
            return ConfigRegistry.getInstance().getAllConfigItemFactories();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IConfigItemFactory) {
                return ((IConfigItemFactory)element).getPluralName();
            }
            return ((ConfigItem)element).getName();
        }
    }
}

